/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class FTBTeamsIntegration {
    public static void init() {
        TeamEvent.PLAYER_LOGGED_IN.register(e -> {
            ServerPlayer player = e.getPlayer();
            if (player != null) {
                FTBTeamsIntegration.syncTeamToPlayer(player);
            }
        });
        TeamEvent.PLAYER_CHANGED.register(e -> {
            ServerPlayer player = e.getPlayer();
            if (player != null) {
                FTBTeamsIntegration.syncTeamToPlayer(player);
                TeamManager tm = TeamManager.getInstance();
                UUID teamId = tm.getPlayerTeamId(player.m_20148_());
                if (teamId != null) {
                    for (UUID memberId : tm.getTeamMembers(teamId)) {
                        ServerPlayer member;
                        if (memberId.equals(player.m_20148_()) || (member = player.m_20194_().m_6846_().m_11259_(memberId)) == null) continue;
                        FTBTeamsIntegration.syncTeamToPlayer(member);
                    }
                }
                e.getPreviousTeam().ifPresent(prev -> {
                    HashSet prevMembers = new HashSet(prev.getMembers());
                    for (UUID memberId : prevMembers) {
                        ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
                        if (member == null) continue;
                        FTBTeamsIntegration.syncTeamToPlayer(member);
                    }
                });
            }
        });
    }

    private static void broadcastToTeamMembers(ServerPlayer player) {
        TeamManager tm = TeamManager.getInstance();
        UUID teamId = tm.getPlayerTeamId(player.m_20148_());
        if (teamId != null) {
            for (UUID memberId : tm.getTeamMembers(teamId)) {
                ServerPlayer member;
                if (memberId.equals(player.m_20148_()) || (member = player.m_20194_().m_6846_().m_11259_(memberId)) == null) continue;
                FTBTeamsIntegration.syncTeamToPlayer(member);
            }
        }
    }

    private static void syncTeamToPlayer(ServerPlayer player) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.m_20148_());
        QuestTeam team = null;
        if (teamId != null && (team = teamMgr.getTeam(teamId)) == null) {
            team = teamMgr.buildExternalTeamSnapshot(teamId);
        }
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.m_20148_());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) {
                inviteTeam = teamMgr.buildExternalTeamSnapshot(inviteTeamId);
            }
            if (inviteTeam == null) continue;
            String ownerName = FTBTeamsIntegration.getPlayerName(player.m_20194_(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.m_20148_());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.m_20148_(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private static String getPlayerName(MinecraftServer server, UUID playerId) {
        ServerPlayer p = server.m_6846_().m_11259_(playerId);
        if (p != null) {
            return p.m_7755_().getString();
        }
        return playerId.toString().substring(0, 8);
    }
}

