/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.manager.QuestManager;

public class QuestPositionUpdatePacket {
    private final String questId;
    private final int x;
    private final int y;

    public QuestPositionUpdatePacket(String questId, int x, int y) {
        this.questId = questId;
        this.x = x;
        this.y = y;
    }

    public static void encode(QuestPositionUpdatePacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.questId);
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.y);
    }

    public static QuestPositionUpdatePacket decode(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int x = buf.readInt();
        int y = buf.readInt();
        return new QuestPositionUpdatePacket(id, x, y);
    }

    public void handle(ServerPlayer player) {
        try {
            QuestManager.getInstance().updateQuestPosition(this.questId, this.x, this.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

