/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class RequirementCompletePacket {
    private final String questId;
    private final int requirementIndex;

    public RequirementCompletePacket(String questId, int requirementIndex) {
        this.questId = questId;
        this.requirementIndex = requirementIndex;
    }

    public static void encode(RequirementCompletePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.questId);
        buf.writeInt(packet.requirementIndex);
    }

    public static RequirementCompletePacket decode(FriendlyByteBuf buf) {
        String questId = buf.m_130277_();
        int requirementIndex = buf.readInt();
        return new RequirementCompletePacket(questId, requirementIndex);
    }

    public void handle(ServerPlayer player) {
        Quest quest = QuestManager.getInstance().getQuest(this.questId);
        if (quest == null) {
            System.err.println("[Questory] Invalid quest ID for requirement completion: " + this.questId);
            return;
        }
        if (this.requirementIndex < 0 || this.requirementIndex >= quest.getRequirements().size()) {
            System.err.println("[Questory] Invalid requirement index: " + this.requirementIndex + " for quest: " + this.questId);
            return;
        }
        Requirement requirement = quest.getRequirements().get(this.requirementIndex);
        if (!(requirement instanceof CheckmarkRequirement)) {
            System.err.println("[Questory] Attempted to manually complete non-checkmark requirement: " + requirement.getType());
            return;
        }
        QuestProgress progress = QuestManager.getInstance().getProgress(player.m_20148_());
        if (progress.getRequirementProgress(this.questId, requirement) > 0) {
            System.out.println("[Questory] Requirement already completed for quest: " + this.questId);
            return;
        }
        progress.setRequirementProgress(this.questId, requirement, 1);
        System.out.println("[Questory] Player " + player.m_7755_().getString() + " manually completed requirement " + this.requirementIndex + " for quest: " + this.questId);
        QuestManager questManager = QuestManager.getInstance();
        if (quest.canComplete(progress)) {
            questManager.completeQuest(player, this.questId);
        } else {
            questManager.savePlayerProgress(progress);
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    public String getQuestId() {
        return this.questId;
    }

    public int getRequirementIndex() {
        return this.requirementIndex;
    }
}

