/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.quest.Reward;

public class CurrencyReward
extends Reward {
    private String currencyId;
    private long amount;

    public CurrencyReward(String currencyId, long amount) {
        super("currency");
        this.currencyId = currencyId;
        this.amount = amount;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public void grant(ServerPlayer player) {
    }

    @Override
    public String getDisplayString() {
        return this.amount + " " + this.currencyId;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "currency");
        json.addProperty("currency", this.currencyId);
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public static CurrencyReward fromJson(JsonObject json) {
        String currencyId = json.get("currency").getAsString();
        long amount = json.get("amount").getAsLong();
        return new CurrencyReward(currencyId, amount);
    }
}

