/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ItemRequirement
extends Requirement {
    private String item;
    private int count;
    private CompoundTag nbt;
    private boolean consume;
    private boolean onlyFromCrafting = false;
    private boolean taskScreenOnly = false;
    private String matchComponents = "none";

    public ItemRequirement(String item, int count) {
        super("item_obtain");
        this.item = item;
        this.count = count;
        this.nbt = null;
        this.consume = false;
    }

    public String getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean shouldConsume() {
        return this.consume;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public boolean isOnlyFromCrafting() {
        return this.onlyFromCrafting;
    }

    public void setOnlyFromCrafting(boolean onlyFromCrafting) {
        this.onlyFromCrafting = onlyFromCrafting;
    }

    public boolean isTaskScreenOnly() {
        return this.taskScreenOnly;
    }

    public void setTaskScreenOnly(boolean taskScreenOnly) {
        this.taskScreenOnly = taskScreenOnly;
    }

    public String getMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(String matchComponents) {
        this.matchComponents = matchComponents;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.count + " " + this.item;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("item", this.item);
        json.addProperty("count", (Number)this.count);
        json.addProperty("consume", Boolean.valueOf(this.consume));
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
        }
        if (this.onlyFromCrafting) {
            json.addProperty("only_from_crafting", Boolean.valueOf(true));
        }
        if (this.taskScreenOnly) {
            json.addProperty("task_screen_only", Boolean.valueOf(true));
        }
        if (!"none".equals(this.matchComponents)) {
            json.addProperty("match_components", this.matchComponents);
        }
        return json;
    }

    public static ItemRequirement fromJson(JsonObject json) {
        String item = json.get("item").getAsString();
        int count = json.get("count").getAsInt();
        ItemRequirement req = new ItemRequirement(item, count);
        if (json.has("consume")) {
            req.setConsume(json.get("consume").getAsBoolean());
        }
        if (json.has("nbt")) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)json.get("nbt").getAsString());
                req.setNbt(nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (json.has("only_from_crafting")) {
            req.setOnlyFromCrafting(json.get("only_from_crafting").getAsBoolean());
        }
        if (json.has("task_screen_only")) {
            req.setTaskScreenOnly(json.get("task_screen_only").getAsBoolean());
        }
        if (json.has("match_components")) {
            req.setMatchComponents(json.get("match_components").getAsString());
        }
        return req;
    }

    public boolean matches(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation stackId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        if (!stackId.toString().equals(this.item)) {
            return false;
        }
        if (this.nbt != null) {
            CompoundTag stackNbt = stack.m_41783_();
            if (stackNbt == null) {
                return false;
            }
            return this.nbtMatches(stackNbt, this.nbt);
        }
        return true;
    }

    private boolean nbtMatches(CompoundTag stackNbt, CompoundTag requiredNbt) {
        for (String key : requiredNbt.m_128431_()) {
            if (!stackNbt.m_128441_(key)) {
                return false;
            }
            if (stackNbt.m_128423_(key).equals((Object)requiredNbt.m_128423_(key))) continue;
            return false;
        }
        return true;
    }
}

