/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.quest.Reward;

public class RandomReward
extends Reward {
    private String tableId;
    private int count;

    public RandomReward(String tableId, int count) {
        super("random");
        this.tableId = tableId;
        this.count = count;
    }

    public String getTableId() {
        return this.tableId;
    }

    public int getCount() {
        return this.count;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void grant(ServerPlayer player) {
    }

    @Override
    public String getDisplayString() {
        return "Random reward from table: " + this.tableId + " (" + this.count + " items)";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "random");
        json.addProperty("table", this.tableId);
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public static RandomReward fromJson(JsonObject json) {
        String tableId = json.get("table").getAsString();
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        return new RandomReward(tableId, count);
    }
}

