/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.backend.sqlite;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.shaded.sqlite.JDBC;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.team.QuestTeam;

public class SqliteTeamStorageBackend
implements ITeamStorageBackend {
    private static final Gson GSON = new GsonBuilder().create();
    private final Path databasePath;
    private Connection connection;

    public SqliteTeamStorageBackend(Path dataPath, String databaseFileName) {
        this.databasePath = dataPath.resolve(databaseFileName);
    }

    @Override
    public boolean connect() {
        try {
            try {
                Class.forName(JDBC.class.getName());
            }
            catch (ClassNotFoundException e) {
                System.err.println("[Questory] SQLite JDBC driver not found: " + e.getMessage());
                return false;
            }
            String url = "jdbc:sqlite:" + String.valueOf(this.databasePath.toAbsolutePath());
            this.connection = DriverManager.getConnection(url);
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA journal_mode=WAL");
                stmt.execute("PRAGMA synchronous=NORMAL");
                stmt.execute("PRAGMA cache_size = -64000");
                stmt.execute("PRAGMA temp_store = MEMORY");
            }
            this.createTables();
            System.out.println("[Questory] SQLite team storage backend connected: " + String.valueOf(this.databasePath));
            return true;
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to connect to SQLite database for teams: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void createTables() throws SQLException {
        String createTeamsTable = "    CREATE TABLE IF NOT EXISTS teams (\n        team_id TEXT PRIMARY KEY,\n        team_data TEXT NOT NULL,\n        last_updated INTEGER DEFAULT (strftime('%s', 'now'))\n    )\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createTeamsTable);
        }
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
                System.out.println("[Questory] SQLite team storage backend disconnected");
            }
            catch (SQLException e) {
                System.err.println("[Questory] Error closing SQLite team connection: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean healthCheck() {
        boolean bl;
        block9: {
            if (!this.isConnected()) {
                return false;
            }
            Statement stmt = this.connection.createStatement();
            try {
                stmt.execute("SELECT 1");
                bl = true;
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    @Override
    public String getBackendType() {
        return "SQLite";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QuestTeam loadTeam(UUID teamId) {
        try {
            String query = "SELECT team_data FROM teams WHERE team_id = ?";
            try (PreparedStatement stmt = this.connection.prepareStatement(query);){
                stmt.setString(1, teamId.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) return null;
                String jsonData = rs.getString("team_data");
                JsonObject json = JsonParser.parseString((String)jsonData).getAsJsonObject();
                QuestTeam questTeam = QuestTeam.fromJson(json);
                return questTeam;
            }
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to load team " + String.valueOf(teamId) + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public boolean saveTeam(QuestTeam team) {
        try {
            String upsert = "    INSERT OR REPLACE INTO teams (team_id, team_data, last_updated)\n    VALUES (?, ?, strftime('%s', 'now'))\n";
            try (PreparedStatement stmt = this.connection.prepareStatement(upsert);){
                stmt.setString(1, team.getTeamId().toString());
                stmt.setString(2, GSON.toJson((JsonElement)team.toJson()));
                stmt.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to save team " + team.getTeamName() + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean deleteTeam(UUID teamId) {
        try {
            String delete = "DELETE FROM teams WHERE team_id = ?";
            try (PreparedStatement stmt = this.connection.prepareStatement(delete);){
                stmt.setString(1, teamId.toString());
                stmt.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to delete team " + String.valueOf(teamId) + ": " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<UUID, QuestTeam> loadAllTeams() {
        HashMap<UUID, QuestTeam> teams = new HashMap<UUID, QuestTeam>();
        try {
            String query = "SELECT team_id, team_data FROM teams";
            try (Statement stmt = this.connection.createStatement();
                 ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    try {
                        UUID teamId = UUID.fromString(rs.getString("team_id"));
                        String jsonData = rs.getString("team_data");
                        JsonObject json = JsonParser.parseString((String)jsonData).getAsJsonObject();
                        QuestTeam team = QuestTeam.fromJson(json);
                        if (team == null) continue;
                        teams.put(teamId, team);
                    }
                    catch (Exception e) {
                        System.err.println("[Questory] Failed to parse team data: " + e.getMessage());
                    }
                }
                return teams;
            }
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to load all teams: " + e.getMessage());
        }
        return teams;
    }
}

