/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import com.google.gson.JsonObject;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.team.TeamProgressMode;
import org.texboobcat.questory.team.TeamRewardMode;

public class TeamQuestSettings {
    private TeamProgressMode progressMode;
    private TeamRewardMode rewardMode;
    private boolean requireAllOnline;
    private boolean allowSoloCompletion;
    private int minTeamSize;
    private int maxTeamSize;
    private boolean teamEnabled;

    public TeamQuestSettings() {
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            this.progressMode = TeamProgressMode.valueOf(cfg.teamDefaultProgressMode);
            this.rewardMode = TeamRewardMode.valueOf(cfg.teamDefaultRewardMode);
            this.requireAllOnline = cfg.teamRequireAllOnlineDefault;
            this.maxTeamSize = cfg.teamMaxSize;
        }
        catch (Throwable t) {
            this.progressMode = TeamProgressMode.SHARED;
            this.rewardMode = TeamRewardMode.SHARED;
            this.requireAllOnline = false;
            this.maxTeamSize = 10;
        }
        this.allowSoloCompletion = true;
        this.minTeamSize = 1;
        this.teamEnabled = false;
    }

    public TeamProgressMode getProgressMode() {
        return this.progressMode;
    }

    public TeamRewardMode getRewardMode() {
        return this.rewardMode;
    }

    public boolean isRequireAllOnline() {
        return this.requireAllOnline;
    }

    public boolean isAllowSoloCompletion() {
        return this.allowSoloCompletion;
    }

    public int getMinTeamSize() {
        return this.minTeamSize;
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public boolean isTeamEnabled() {
        return this.teamEnabled;
    }

    public void setProgressMode(TeamProgressMode mode) {
        this.progressMode = mode;
    }

    public void setRewardMode(TeamRewardMode mode) {
        this.rewardMode = mode;
    }

    public void setRequireAllOnline(boolean require) {
        this.requireAllOnline = require;
    }

    public void setAllowSoloCompletion(boolean allow) {
        this.allowSoloCompletion = allow;
    }

    public void setMinTeamSize(int size) {
        this.minTeamSize = Math.max(1, size);
    }

    public void setMaxTeamSize(int size) {
        this.maxTeamSize = Math.max(1, size);
    }

    public void setTeamEnabled(boolean enabled) {
        this.teamEnabled = enabled;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("teamEnabled", Boolean.valueOf(this.teamEnabled));
        if (this.teamEnabled) {
            json.addProperty("progressMode", this.progressMode.name());
            json.addProperty("rewardMode", this.rewardMode.name());
            json.addProperty("requireAllOnline", Boolean.valueOf(this.requireAllOnline));
            json.addProperty("allowSoloCompletion", Boolean.valueOf(this.allowSoloCompletion));
            json.addProperty("minTeamSize", (Number)this.minTeamSize);
            json.addProperty("maxTeamSize", (Number)this.maxTeamSize);
        }
        return json;
    }

    public static TeamQuestSettings fromJson(JsonObject json) {
        TeamQuestSettings settings = new TeamQuestSettings();
        if (json.has("teamEnabled")) {
            settings.teamEnabled = json.get("teamEnabled").getAsBoolean();
        }
        if (settings.teamEnabled) {
            if (json.has("progressMode")) {
                try {
                    settings.progressMode = TeamProgressMode.valueOf(json.get("progressMode").getAsString());
                }
                catch (IllegalArgumentException e) {
                    settings.progressMode = TeamProgressMode.SHARED;
                }
            }
            if (json.has("rewardMode")) {
                try {
                    settings.rewardMode = TeamRewardMode.valueOf(json.get("rewardMode").getAsString());
                }
                catch (IllegalArgumentException e) {
                    settings.rewardMode = TeamRewardMode.SHARED;
                }
            }
            if (json.has("requireAllOnline")) {
                settings.requireAllOnline = json.get("requireAllOnline").getAsBoolean();
            }
            if (json.has("allowSoloCompletion")) {
                settings.allowSoloCompletion = json.get("allowSoloCompletion").getAsBoolean();
            }
            if (json.has("minTeamSize")) {
                settings.minTeamSize = json.get("minTeamSize").getAsInt();
            }
            if (json.has("maxTeamSize")) {
                settings.maxTeamSize = json.get("maxTeamSize").getAsInt();
            }
        }
        return settings;
    }
}

