/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.compat.map.MapCompatManager;
import org.texboobcat.questory.client.gui.QuestIconRenderer;
import org.texboobcat.questory.client.gui.QuestShape;
import org.texboobcat.questory.client.gui.SidebarPanel;
import org.texboobcat.questory.client.gui.ThemeEditorScreen;
import org.texboobcat.questory.client.rendering.AnimationHelper;
import org.texboobcat.questory.client.rendering.BackgroundRenderer;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCompleteRequestPacket;
import org.texboobcat.questory.quest.ChapterImage;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.TagAutoDetector;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class QuestGraphScreen
extends class_437 {
    private static final int DETAILS_WIDTH = 260;
    private String selectedGroup = "all";
    private List<Quest> visibleQuests = new ArrayList<Quest>();
    private SidebarPanel sidebar;
    private static final int MAX_QUESTS_PER_VIEW = 500;
    private static final int MAX_SEGMENTS_PER_PASS = 6000;
    private Quest selectedQuest = null;
    private class_4185 completeActionButton;
    private class_4185 closeButton;
    private class_4185 centerButton;
    private class_4185 fitButton;
    private class_4185 themeButton;
    private class_4185 animToggleButton;
    private class_4185 miniMapButton;
    private class_4185 heatmapButton;
    private int zoom = 16;
    private static final int MIN_ZOOM = 1;
    private static final int MAX_ZOOM = 60;
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private double scrollWidth = 0.0;
    private double scrollHeight = 0.0;
    private boolean dragging = false;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private double questMinX = 0.0;
    private double questMinY = 0.0;
    private double questMaxX = 0.0;
    private double questMaxY = 0.0;
    private int detailsPanelScroll = 0;
    private int detailsPanelContentHeight = 0;
    private int[] lastDetailsTrackRect = null;
    private BackgroundRenderer backgroundRenderer = BackgroundRenderer.darkGradient();
    private Integer backgroundTintColor;
    private boolean enableAnimations = true;
    private boolean showMiniMap = false;
    private String heatmapMode = "off";
    private int[] lastMiniMapRect = null;
    private boolean miniMapDragging = false;
    private boolean miniMapMoving = false;
    private boolean miniMapResizing = false;
    private int[] lastMiniMapHeaderRect = null;
    private int[] lastMiniMapResizeRect = null;
    private int miniMapMoveOffsetX = 0;
    private int miniMapMoveOffsetY = 0;
    private int[] lastMiniMapGearRect = null;
    private boolean miniMapSettingsOpen = false;
    private int[][] miniMapSizeOptionRects = null;
    private int[][] miniMapOpacityOptionRects = null;
    private long lastHeaderClickMs = 0L;
    private int[] lastHeatRect = null;
    private int[] lastHeatHeaderRect = null;
    private int[] lastHeatResizeRect = null;
    private boolean heatMoving = false;
    private boolean heatResizing = false;
    private int heatMoveOffsetX = 0;
    private int heatMoveOffsetY = 0;
    private static final Set<String> loggedImageGroups = new HashSet<String>();

    public QuestGraphScreen() {
        super((class_2561)class_2561.method_43470((String)"Quests"));
    }

    public void toggleTrackSelected() {
        if (this.selectedQuest == null) {
            return;
        }
        boolean wasTracked = ClientConfig.isQuestTracked(this.selectedQuest.getId());
        ClientConfig.setQuestTracked(this.selectedQuest.getId(), !wasTracked);
        try {
            MapCompatManager.onClientDataChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void doFitToScreen() {
        this.fitToScreen();
    }

    public void doCenterView() {
        this.resetScroll();
    }

    public void doZoomIn() {
        this.addZoom(5.0, (double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0);
    }

    public void doZoomOut() {
        this.addZoom(-5.0, (double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0);
    }

    private void layoutBottomButtons() {
        ArrayList<class_4185> buttons = new ArrayList<class_4185>();
        ArrayList<Integer> desired = new ArrayList<Integer>();
        ArrayList<Integer> minimum = new ArrayList<Integer>();
        this.addButtonForLayout(this.miniMapButton, buttons, desired, minimum, 80, 60);
        this.addButtonForLayout(this.heatmapButton, buttons, desired, minimum, 90, 60);
        if (this.completeActionButton != null) {
            int desiredWidth = Math.max(90, this.field_22793.method_1727(this.completeActionButton.method_25369().getString()) + 24);
            this.addButtonForLayout(this.completeActionButton, buttons, desired, minimum, desiredWidth, 70);
        }
        this.addButtonForLayout(this.closeButton, buttons, desired, minimum, 70, 60);
        int count = buttons.size();
        if (count == 0) {
            return;
        }
        int spacing = 6;
        int available = this.field_22789 - 20;
        int totalWidth = spacing * (count - 1);
        int[] widths = new int[count];
        for (int i = 0; i < count; ++i) {
            widths[i] = (Integer)desired.get(i);
            totalWidth += widths[i];
        }
        if (totalWidth > available) {
            int minSpacingTotal;
            int totalSpacing;
            int spacingReducible;
            boolean reduced;
            int deficit = totalWidth - available;
            do {
                reduced = false;
                for (int i = 0; i < count && deficit > 0; ++i) {
                    int reducible = widths[i] - (Integer)minimum.get(i);
                    if (reducible <= 0) continue;
                    int amount = Math.min(reducible, Math.max(1, deficit / (count - i)));
                    int n = i;
                    widths[n] = widths[n] - amount;
                    deficit -= amount;
                    reduced = true;
                }
            } while (deficit > 0 && reduced);
            if (deficit > 0 && count > 1 && (spacingReducible = (totalSpacing = spacing * (count - 1)) - (minSpacingTotal = 2 * (count - 1))) > 0) {
                int spacingReduction = Math.min(deficit, spacingReducible);
                deficit -= spacingReduction;
                spacing = count > 1 ? Math.max(2, (totalSpacing -= spacingReduction) / (count - 1)) : 0;
            }
            totalWidth = spacing * (count - 1);
            for (int w : widths) {
                totalWidth += w;
            }
        }
        int startX = Math.max(10, (this.field_22789 - totalWidth) / 2);
        int y = this.field_22790 - 30;
        int x = startX;
        for (int i = 0; i < count; ++i) {
            class_4185 btn = (class_4185)buttons.get(i);
            if (btn == null) continue;
            btn.method_25358(widths[i]);
            btn.method_46421(x);
            btn.method_46419(y);
            x += widths[i] + spacing;
        }
    }

    private void addButtonForLayout(class_4185 btn, List<class_4185> buttons, List<Integer> desired, List<Integer> minimum, int desiredWidth, int minWidth) {
        if (btn == null) {
            return;
        }
        int msgWidth = this.field_22793.method_1727(btn.method_25369().getString()) + 20;
        desired.add(Math.max(desiredWidth, msgWidth));
        minimum.add(Math.max(40, minWidth));
        buttons.add(btn);
    }

    private void buildSidebarEntries() {
        if (this.sidebar == null) {
            return;
        }
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        GroupNode tree = cqm.getGroupTree();
        if (tree != null && !tree.getChildren().isEmpty()) {
            this.sidebar.setCountProvider(cqm::getQuestCountForGroup);
            this.sidebar.setGroupTree(tree);
            this.sidebar.setSelectedGroup(this.selectedGroup);
            return;
        }
        ArrayList<SidebarPanel.Entry> entries = new ArrayList<SidebarPanel.Entry>();
        int total = cqm.getVisibleQuests().size();
        if (total <= 500) {
            entries.add(new SidebarPanel.Entry("all", (class_2561)class_2561.method_43470((String)"All"), total, false, 0, null, null));
        }
        for (String g : cqm.getQuestGroups()) {
            int count = cqm.getQuestsByGroup(g).size();
            entries.add(new SidebarPanel.Entry(g, (class_2561)class_2561.method_43470((String)g), count, false, 0, null, null));
        }
        this.sidebar.setEntries(entries);
        this.sidebar.setSelectedGroup(this.selectedGroup);
    }

    private void renderChapterImages(class_332 g, int graphLeft, int graphTop, int graphW, int graphH) {
        if (this.selectedGroup == null || this.selectedGroup.isEmpty()) {
            return;
        }
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        List<ChapterImage> images = cqm.getChapterImages(this.selectedGroup);
        if (images.isEmpty()) {
            return;
        }
        if (!loggedImageGroups.contains(this.selectedGroup)) {
            System.out.println("[Questory Client] Rendering chapter images for '" + this.selectedGroup + "': " + images.size());
            if (!images.isEmpty()) {
                System.out.println("  First image url= " + images.get(0).getImageUrl());
            }
            loggedImageGroups.add(this.selectedGroup);
        }
        double bs = this.getQuestButtonSize();
        images.sort(Comparator.comparingInt(ChapterImage::getOrder));
        int left = graphLeft;
        int top = graphTop;
        int right = graphLeft + graphW;
        int bottom = graphTop + graphH;
        int margin = (int)(bs * 4.0);
        for (ChapterImage img : images) {
            if (img.getDependencyQuestId() != null && !img.getDependencyQuestId().isBlank() && !cqm.isQuestCompleted(img.getDependencyQuestId())) {
                if (img != images.get(0)) continue;
                System.out.println("  Skipping image due to unmet dependency: " + img.getDependencyQuestId());
                continue;
            }
            double gridX = (double)img.getX() / 45.0;
            double gridY = (double)img.getY() / 45.0;
            double bp = this.getQuestButtonSpacing();
            double screenX = (gridX - this.questMinX) * (bs + bp) + bp / 2.0 - this.scrollX + (double)graphLeft;
            double screenY = (gridY - this.questMinY) * (bs + bp) + bp / 2.0 - this.scrollY + (double)graphTop;
            double unit = Math.max(bs + bp, 12.0);
            int iw = (int)Math.round(unit * img.getWidth());
            int ih = (int)Math.round(unit * img.getHeight());
            int x = img.isAlignToCorner() ? (int)Math.round(screenX) : (int)Math.round(screenX - (double)iw / 2.0);
            int y = img.isAlignToCorner() ? (int)Math.round(screenY) : (int)Math.round(screenY - (double)ih / 2.0);
            int clampLeft = left + 2;
            int clampTop = top + 2;
            int clampRight = right - 2;
            int clampBottom = bottom - 2;
            if (iw > clampRight - clampLeft) {
                x = clampLeft;
                iw = clampRight - clampLeft;
            } else {
                x = Math.max(clampLeft, Math.min(x, clampRight - iw));
            }
            if (ih > clampBottom - clampTop) {
                y = clampTop;
                ih = clampBottom - clampTop;
            } else {
                y = Math.max(clampTop, Math.min(y, clampBottom - ih));
            }
            if (img == images.get(0)) {
                System.out.println("  Image placement: x=" + x + ", y=" + y + ", w=" + iw + ", h=" + ih);
            }
            if (x + iw < left || x > right || y + ih < top || y > bottom) continue;
            int argb = -1;
            try {
                if (img.getColor() != null && img.getColor().startsWith("#")) {
                    int rgb = Integer.parseInt(img.getColor().substring(1), 16) & 0xFFFFFF;
                    argb = (img.getAlpha() & 0xFF) << 24 | rgb;
                }
            }
            catch (Exception rgb) {
                // empty catch block
            }
            class_2960 rl = null;
            String url = img.getImageUrl();
            if (url != null && url.contains(":")) {
                try {
                    rl = new class_2960(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rl == null && url != null && !url.contains(":")) {
                try {
                    rl = new class_2960("ftbquests", url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (rl == null) {
                    try {
                        rl = new class_2960("minecraft", url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            boolean resourceOk = false;
            if (rl != null) {
                try {
                    class_3300 rm = class_310.method_1551().method_1478();
                    Optional res = rm.method_14486(rl);
                    resourceOk = res.isPresent();
                    if (!resourceOk) {
                        String ns = rl.method_12836();
                        String path = rl.method_12832();
                        class_2960 alt = null;
                        alt = path.startsWith("textures/") ? new class_2960(ns, path.substring(9)) : new class_2960(ns, "textures/" + path);
                        Optional res2 = rm.method_14486(alt);
                        if (res2.isPresent()) {
                            rl = alt;
                            resourceOk = true;
                        }
                    }
                    if (!resourceOk && img == images.get(0)) {
                        System.out.println("  Missing texture: " + String.valueOf(rl));
                    }
                }
                catch (Throwable t) {
                    resourceOk = false;
                }
            }
            if (rl != null && resourceOk) {
                class_4587 pose = g.method_51448();
                pose.method_22903();
                pose.method_22904((double)x + (double)iw / 2.0, (double)y + (double)ih / 2.0, 0.0);
                if (img.getRotation() != 0.0) {
                    pose.method_22907(class_7833.field_40718.rotationDegrees((float)img.getRotation()));
                }
                pose.method_22904((double)(-iw) / 2.0, (double)(-ih) / 2.0, 0.0);
                float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
                float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
                float gch = (float)(argb >>> 8 & 0xFF) / 255.0f;
                float b = (float)(argb & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
                g.method_25290(rl, 0, 0, 0.0f, 0.0f, iw, ih, iw, ih);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                pose.method_22909();
                continue;
            }
            g.method_25294(x, y, x + iw, y + ih, argb);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.reloadVisibleQuests();
        this.rebuildBackgroundFromTheme();
        if (this.sidebar == null) {
            this.sidebar = new SidebarPanel(0, 30, 180, this.field_22790 - 70);
            this.sidebar.setOnSelect(this::filterByGroup);
        } else {
            this.sidebar.setBounds(0, 30, 180, this.field_22790 - 70);
        }
        this.buildSidebarEntries();
        try {
            this.sidebar.setPinned(ClientConfig.getPinnedGroups());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.sidebar.setPanelPinned(ClientConfig.isChapterPanelPinned());
            this.sidebar.setCollapsedSections(ClientConfig.getCollapsedSections());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String extraShapes = (String)ThemeProperties.EXTRA_QUEST_SHAPES.get();
        if (extraShapes != null && !extraShapes.isEmpty()) {
            QuestShape.registerExtraAliases(extraShapes);
        }
        if (this.selectedGroup == null || this.selectedGroup.isEmpty() || "all".equals(this.selectedGroup)) {
            ClientQuestManager cqm = ClientQuestManager.getInstance();
            String candidate = null;
            GroupNode tree = cqm.getGroupTree();
            if (tree != null && !tree.getChildren().isEmpty()) {
                block4: for (GroupNode sec : tree.getChildren()) {
                    for (String g : sec.getGroups()) {
                        if (cqm.getQuestCountForGroup(g) <= 0) continue;
                        candidate = g;
                        break block4;
                    }
                }
            }
            if (candidate == null) {
                for (String g : cqm.getQuestGroups()) {
                    if (cqm.getQuestsByGroup(g).size() <= 0) continue;
                    candidate = g;
                    break;
                }
            }
            if (candidate != null) {
                this.selectedGroup = candidate;
                if (this.sidebar != null) {
                    this.sidebar.setSelectedGroup(candidate);
                }
                this.reloadVisibleQuests();
            }
        }
        if (!this.visibleQuests.isEmpty()) {
            this.fitToScreen();
        } else {
            this.alignQuestPositions();
            this.resetScroll();
        }
        this.closeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(0, this.field_22790 - 30, 70, 20).method_46431());
        this.completeActionButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Complete All"), b -> {
            if (this.selectedQuest != null && ClientQuestManager.getInstance().canCompleteQuest(this.selectedQuest.getId())) {
                this.completeSelectedQuest();
            } else {
                this.completeAllCompletableQuests();
            }
        }).method_46434(0, this.field_22790 - 30, 90, 20).method_46431());
        this.miniMapButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"MiniMap"), b -> {
            this.showMiniMap = !this.showMiniMap;
        }).method_46434(0, this.field_22790 - 30, 80, 20).method_46431());
        this.heatmapButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Heat: Off"), b -> {
            this.heatmapMode = switch (this.heatmapMode) {
                case "off" -> {
                    b.method_25355((class_2561)class_2561.method_43470((String)"Heat: Diff"));
                    yield "difficulty";
                }
                case "difficulty" -> {
                    b.method_25355((class_2561)class_2561.method_43470((String)"Heat: Prog"));
                    yield "progress";
                }
                case "progress" -> {
                    b.method_25355((class_2561)class_2561.method_43470((String)"Heat: Tags"));
                    yield "tags";
                }
                default -> {
                    b.method_25355((class_2561)class_2561.method_43470((String)"Heat: Off"));
                    yield "off";
                }
            };
        }).method_46434(0, this.field_22790 - 30, 90, 20).method_46431());
        this.layoutBottomButtons();
    }

    private void reloadVisibleQuests() {
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        this.visibleQuests.clear();
        if ("all".equals(this.selectedGroup)) {
            ArrayList<String> groups;
            List<Quest> allQuests = cqm.getVisibleQuests();
            if (allQuests.size() > 500 && !(groups = new ArrayList<String>(cqm.getQuestGroups())).isEmpty()) {
                this.selectedGroup = (String)groups.get(0);
                this.reloadVisibleQuests();
                return;
            }
            this.visibleQuests.addAll(allQuests);
        } else {
            QuestProgress progress = cqm.getProgress();
            for (Quest q : cqm.getQuestsByGroup(this.selectedGroup)) {
                if (!q.isVisible(progress)) continue;
                this.visibleQuests.add(q);
            }
        }
    }

    private double getQuestButtonSize() {
        return (double)this.zoom * 3.0 / 2.0;
    }

    private double getQuestButtonSpacing() {
        double s = (Double)ThemeProperties.QUEST_SPACING.get();
        return (double)this.zoom * s / 4.0;
    }

    private void updateMinMax() {
        this.questMinX = Double.POSITIVE_INFINITY;
        this.questMinY = Double.POSITIVE_INFINITY;
        this.questMaxX = Double.NEGATIVE_INFINITY;
        this.questMaxY = Double.NEGATIVE_INFINITY;
        for (Quest q : this.visibleQuests) {
            double qx = q.getX();
            double qy = q.getY();
            this.questMinX = Math.min(this.questMinX, qx);
            this.questMinY = Math.min(this.questMinY, qy);
            this.questMaxX = Math.max(this.questMaxX, qx);
            this.questMaxY = Math.max(this.questMaxY, qy);
        }
        if (this.questMinX == Double.POSITIVE_INFINITY) {
            this.questMaxY = 0.0;
            this.questMaxX = 0.0;
            this.questMinY = 0.0;
            this.questMinX = 0.0;
        }
        this.questMinX -= 40.0;
        this.questMinY -= 30.0;
        this.questMaxX += 40.0;
        this.questMaxY += 30.0;
    }

    private void alignQuestPositions() {
        this.updateMinMax();
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        this.scrollWidth = (this.questMaxX - this.questMinX) * (bs + bp);
        this.scrollHeight = (this.questMaxY - this.questMinY) * (bs + bp);
    }

    private void resetScroll() {
        this.alignQuestPositions();
        int graphWidth = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
        int graphHeight = this.field_22790 - 70;
        this.scrollX = this.scrollWidth > (double)graphWidth ? (this.scrollWidth - (double)graphWidth) / 2.0 : 0.0;
        this.scrollY = this.scrollHeight > (double)graphHeight ? (this.scrollHeight - (double)graphHeight) / 2.0 : 0.0;
        System.out.println("[QuestUI] Centered view: zoom=" + this.zoom + ", scrollX=" + this.scrollX + ", scrollY=" + this.scrollY + ", visible=" + this.visibleQuests.size());
        System.out.println("[QuestUI] Bounds: minX=" + this.questMinX + ", maxX=" + this.questMaxX + ", minY=" + this.questMinY + ", maxY=" + this.questMaxY);
        System.out.println("[QuestUI] Scroll size: width=" + this.scrollWidth + ", height=" + this.scrollHeight);
    }

    private void addZoom(double delta, double mouseX, double mouseY) {
        int oldZoom = this.zoom;
        this.zoom = (int)class_3532.method_15350((double)((double)this.zoom + delta * 4.0), (double)1.0, (double)60.0);
        if (this.zoom != oldZoom) {
            int graphLeft = 8;
            int graphTop = 30;
            int graphWidth = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
            int graphHeight = this.field_22790 - 70;
            double oldBs = (double)oldZoom * 3.0 / 2.0;
            double oldBp = (double)oldZoom * (Double)ThemeProperties.QUEST_SPACING.get() / 4.0;
            double oldScrollWidth = (this.questMaxX - this.questMinX) * (oldBs + oldBp);
            double oldScrollHeight = (this.questMaxY - this.questMinY) * (oldBs + oldBp);
            double relMouseX = mouseX - (double)graphLeft + this.scrollX;
            double relMouseY = mouseY - (double)graphTop + this.scrollY;
            double questPosX = relMouseX / oldScrollWidth * (this.questMaxX - this.questMinX) + this.questMinX;
            double questPosY = relMouseY / oldScrollHeight * (this.questMaxY - this.questMinY) + this.questMinY;
            this.alignQuestPositions();
            double newRelMouseX = (questPosX - this.questMinX) / (this.questMaxX - this.questMinX) * this.scrollWidth;
            double newRelMouseY = (questPosY - this.questMinY) / (this.questMaxY - this.questMinY) * this.scrollHeight;
            this.scrollX = newRelMouseX - (mouseX - (double)graphLeft);
            this.scrollY = newRelMouseY - (mouseY - (double)graphTop);
            this.scrollX = Math.max(0.0, Math.min(this.scrollWidth - (double)graphWidth, this.scrollX));
            this.scrollY = Math.max(0.0, Math.min(this.scrollHeight - (double)graphHeight, this.scrollY));
        }
    }

    private void fitToScreen() {
        if (this.visibleQuests.isEmpty()) {
            return;
        }
        this.alignQuestPositions();
        int graphWidth = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
        int graphHeight = this.field_22790 - 70;
        double gridWidth = this.questMaxX - this.questMinX;
        double gridHeight = this.questMaxY - this.questMinY;
        if (gridWidth <= 0.0 || gridHeight <= 0.0) {
            this.zoom = 16;
            this.resetScroll();
            return;
        }
        double zoomForWidth = (double)graphWidth / (gridWidth * 1.5);
        double zoomForHeight = (double)graphHeight / (gridHeight * 1.5);
        int optimalZoom = (int)Math.min(zoomForWidth, zoomForHeight);
        this.zoom = (int)class_3532.method_15350((double)((double)optimalZoom * 0.9), (double)1.0, (double)60.0);
        System.out.println("[QuestUI] Fit to screen: gridW=" + gridWidth + ", gridH=" + gridHeight + ", optimalZoom=" + this.zoom);
        this.alignQuestPositions();
        this.resetScroll();
    }

    private int[] gridToScreen(int gridX, int gridY, int viewportLeft, int viewportTop) {
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        double screenX = ((double)gridX - this.questMinX) * (bs + bp) + bp / 2.0 - this.scrollX + (double)viewportLeft;
        double screenY = ((double)gridY - this.questMinY) * (bs + bp) + bp / 2.0 - this.scrollY + (double)viewportTop;
        return new int[]{(int)Math.round(screenX), (int)Math.round(screenY)};
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int[] depPos;
        Quest dep;
        int[] qPos;
        this.backgroundRenderer.render(graphics, 0, 0, this.field_22789, this.field_22790);
        if (this.sidebar != null) {
            this.sidebar.render(graphics, this.field_22793, this.field_22790, mouseX, mouseY);
        }
        int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getReservedWidth() : 0);
        int graphTop = 30;
        int graphRight = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
        int graphBottom = this.field_22790 - 40;
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        double bs = this.getQuestButtonSize();
        int margin = (int)(bs * 4.0);
        int visibleLeft = graphLeft - margin;
        int visibleTop = graphTop - margin;
        int visibleRight = graphRight + margin;
        int visibleBottom = graphBottom + margin;
        this.renderChapterImages(graphics, graphLeft, graphTop, graphRight - graphLeft, graphBottom - graphTop);
        Quest hoveredQuest = this.getHoveredQuest(mouseX, mouseY, graphLeft, graphTop);
        class_2960 lineTexture = ThemeProperties.DEPENDENCY_LINE_TEXTURE.getResourceLocation();
        if (lineTexture != null) {
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderTexture((int)0, (class_2960)lineTexture);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        int segCount = 0;
        for (Quest q : this.visibleQuests) {
            if (q.isHideDependencyLines()) continue;
            qPos = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            for (String depId : q.getDependencies()) {
                boolean touchesFocus;
                dep = cqm.getQuest(depId);
                if (dep == null || !this.visibleQuests.contains(dep) || dep.isHideDependentLines()) continue;
                boolean bl = touchesFocus = this.selectedQuest != null && (q.equals(this.selectedQuest) || dep.equals(this.selectedQuest)) || hoveredQuest != null && (q.equals(hoveredQuest) || dep.equals(hoveredQuest));
                if (touchesFocus) continue;
                depPos = this.gridToScreen(dep.getX(), dep.getY(), graphLeft, graphTop);
                if (qPos[0] < visibleLeft && depPos[0] < visibleLeft || qPos[0] > visibleRight && depPos[0] > visibleRight || qPos[1] < visibleTop && depPos[1] < visibleTop || qPos[1] > visibleBottom && depPos[1] > visibleBottom) continue;
                boolean depCompleted = cqm.isQuestCompleted(dep.getId());
                boolean qCompleted = cqm.isQuestCompleted(q.getId());
                int baseColor = qCompleted && depCompleted ? (Integer)ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR.get(q) : (!qCompleted && depCompleted ? ((Integer)ThemeProperties.DEPENDENCY_LINE_UNCOMPLETED_COLOR.get(q)).intValue() : ((Integer)ThemeProperties.DEPENDENCY_LINE_UNAVAILABLE_COLOR.get(q)).intValue());
                double thickness = (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(q);
                if (thickness <= 0.0) {
                    thickness = 0.17;
                }
                float thicknessPx = (float)(thickness * this.getQuestButtonSize());
                double unselSpeed = (Double)ThemeProperties.DEPENDENCY_LINE_UNSELECTED_SPEED.get(q);
                float offset = this.enableAnimations ? AnimationHelper.DependencyLineAnimation.getLineOffset(false, unselSpeed) : 0.0f;
                int color = QuestGraphScreen.adjustAlpha(baseColor, 90);
                boolean dashed = "dashed".equalsIgnoreCase(q.getLineStyle()) || "dashed".equalsIgnoreCase(dep.getLineStyle());
                this.drawLine(graphics, qPos[0], qPos[1], depPos[0], depPos[1], color, dashed, thicknessPx, offset, lineTexture);
                if (++segCount < 6000) continue;
                break;
            }
            if (segCount < 6000) continue;
            break;
        }
        if (lineTexture != null) {
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderTexture((int)0, (class_2960)lineTexture);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        segCount = 0;
        for (Quest q : this.visibleQuests) {
            if (q.isHideDependencyLines()) continue;
            qPos = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            for (String depId : q.getDependencies()) {
                boolean highlight;
                dep = cqm.getQuest(depId);
                if (dep == null || !this.visibleQuests.contains(dep) || dep.isHideDependentLines()) continue;
                boolean bl = highlight = this.selectedQuest != null && (q.equals(this.selectedQuest) || dep.equals(this.selectedQuest)) || hoveredQuest != null && (q.equals(hoveredQuest) || dep.equals(hoveredQuest));
                if (!highlight) continue;
                depPos = this.gridToScreen(dep.getX(), dep.getY(), graphLeft, graphTop);
                int colorProp = q.equals(dep) ? (Integer)ThemeProperties.DEPENDENCY_LINE_UNCOMPLETED_COLOR.get(q) : (q.equals(this.selectedQuest) || q.equals(hoveredQuest) ? (Integer)ThemeProperties.DEPENDENCY_LINE_REQUIRES_COLOR.get(q) : (Integer)ThemeProperties.DEPENDENCY_LINE_REQUIRED_FOR_COLOR.get(q));
                double thickness = (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(q);
                if (thickness <= 0.0) {
                    thickness = 0.17;
                }
                float thicknessPx = (float)(thickness * this.getQuestButtonSize());
                double selSpeed = (Double)ThemeProperties.DEPENDENCY_LINE_SELECTED_SPEED.get(q);
                float offset = this.enableAnimations ? AnimationHelper.DependencyLineAnimation.getLineOffset(true, selSpeed) : 0.0f;
                int color = QuestGraphScreen.adjustAlpha(colorProp, 200);
                boolean dashed = "dashed".equalsIgnoreCase(q.getLineStyle()) || "dashed".equalsIgnoreCase(dep.getLineStyle());
                this.drawLine(graphics, qPos[0], qPos[1], depPos[0], depPos[1], color, dashed, thicknessPx, offset, lineTexture);
                if (++segCount < 6000) continue;
                break;
            }
            if (segCount < 6000) continue;
            break;
        }
        for (Quest q : this.visibleQuests) {
            int[] pos = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            if (pos[0] < visibleLeft || pos[0] > visibleRight || pos[1] < visibleTop || pos[1] > visibleBottom) continue;
            this.drawNode(graphics, q, pos, (int)bs, mouseX, mouseY);
        }
        if (this.completeActionButton != null) {
            ClientQuestManager cqmBtn = ClientQuestManager.getInstance();
            if (this.selectedQuest != null) {
                boolean isCompleted = cqmBtn.isQuestCompleted(this.selectedQuest.getId());
                boolean canComplete = cqmBtn.canCompleteQuest(this.selectedQuest.getId());
                if (isCompleted) {
                    this.completeActionButton.method_25355((class_2561)class_2561.method_43470((String)"Completed"));
                    this.completeActionButton.field_22763 = false;
                } else if (canComplete) {
                    this.completeActionButton.method_25355((class_2561)class_2561.method_43470((String)"Complete Quest"));
                    this.completeActionButton.field_22763 = true;
                } else {
                    this.completeActionButton.method_25355((class_2561)class_2561.method_43470((String)"Complete Quest"));
                    this.completeActionButton.field_22763 = false;
                }
            } else {
                this.completeActionButton.method_25355((class_2561)class_2561.method_43470((String)"Complete All"));
                this.completeActionButton.field_22763 = !cqmBtn.getCompletableQuests().isEmpty();
            }
        }
        this.layoutBottomButtons();
        if (this.selectedQuest != null) {
            this.renderDetailsPanel(graphics);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.drawShadowedStringCentered(graphics, this.field_22785.getString(), this.field_22789 / 2, 10, 0xFFFFFF);
        String zoomInfo = "Zoom: " + this.zoom + "/60 (Scroll/+/-, F=Fit)";
        this.drawShadowedString(graphics, zoomInfo, 10, this.field_22790 - 15, 0xAAAAAA);
        String questInfo = this.visibleQuests.size() + " quests";
        this.drawShadowedString(graphics, questInfo, 10, this.field_22790 - 25, 0xAAAAAA);
        try {
            ClientQuestManager cqmDaily = ClientQuestManager.getInstance();
            String did = cqmDaily.getDailyId();
            if (did != null && !did.isBlank()) {
                String title = cqmDaily.getDailyTitle();
                String label = "Daily: " + (String)(title == null || title.isBlank() ? did : title + " (" + did + ")");
                QuestProgress prog = cqmDaily.getProgress();
                boolean completedToday = prog != null && did.equals(prog.getLastCompletedDailyId());
                int color = completedToday ? 0x55FF55 : 16767334;
                this.drawShadowedString(graphics, label, 10, this.field_22790 - 45, color);
            }
        }
        catch (Exception cqmDaily) {
            // empty catch block
        }
        if (this.showMiniMap) {
            int mmW = ClientConfig.getMiniMapW();
            int mmH = ClientConfig.getMiniMapH();
            if (mmW <= 0) {
                mmW = 180;
            }
            if (mmH <= 0) {
                mmH = 120;
            }
            int mmX = ClientConfig.getMiniMapX();
            int mmY = ClientConfig.getMiniMapY();
            if (mmX < 0 || mmY < 0) {
                mmX = Math.max(8, this.field_22789 - mmW - 8);
                mmY = 8;
                ClientConfig.setMiniMapRect(mmX, mmY, mmW, mmH);
            }
            this.lastMiniMapRect = new int[]{mmX, mmY, mmW, mmH};
            this.lastMiniMapHeaderRect = new int[]{mmX, mmY, mmW, 14};
            this.lastMiniMapResizeRect = new int[]{mmX + mmW - 12, mmY + mmH - 12, 12, 12};
            this.renderMiniMap(graphics, mmX, mmY, mmW, mmH, graphLeft, graphTop, graphRight, graphBottom);
        } else {
            this.lastMiniMapRect = null;
            this.lastMiniMapHeaderRect = null;
            this.lastMiniMapResizeRect = null;
        }
        if (!"off".equals(this.heatmapMode)) {
            int hx = ClientConfig.getHeatX();
            int hy = ClientConfig.getHeatY();
            int hw = Math.max(140, ClientConfig.getHeatW());
            int hh = Math.max(50, ClientConfig.getHeatH());
            if (hx < 0 || hy < 0) {
                hx = this.field_22789 - hw - 8;
                hy = this.field_22790 - hh - 8;
                ClientConfig.setHeatRect(hx, hy, hw, hh);
            }
            this.lastHeatRect = new int[]{hx, hy, hw, hh};
            this.lastHeatHeaderRect = new int[]{hx, hy, hw, 14};
            this.lastHeatResizeRect = new int[]{hx + hw - 12, hy + hh - 12, 12, 12};
            this.renderHeatmapLegend(graphics, hx, hy, hw, hh);
        } else {
            this.lastHeatRect = null;
            this.lastHeatHeaderRect = null;
            this.lastHeatResizeRect = null;
        }
        if (this.visibleQuests.isEmpty()) {
            this.drawShadowedStringCentered(graphics, "No quests in this chapter", this.field_22789 / 2, this.field_22790 / 2 - 20, 0xFFFFFF);
            this.drawShadowedStringCentered(graphics, "Select a different chapter above", this.field_22789 / 2, this.field_22790 / 2, 0xAAAAAA);
        }
    }

    private Quest getHoveredQuest(int mouseX, int mouseY, int graphLeft, int graphTop) {
        double bs = this.getQuestButtonSize();
        for (Quest q : this.visibleQuests) {
            int[] p = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            int size = this.computeQuestIconSize(q, (int)Math.round(bs));
            int x = p[0] - size / 2;
            int y = p[1] - size / 2;
            QuestShape shape = QuestShape.get(q.getShape());
            if (!shape.contains(x, y, size, mouseX, mouseY)) continue;
            return q;
        }
        return null;
    }

    private static int adjustAlpha(int argb, int newAlpha) {
        if (newAlpha < 0) {
            newAlpha = 0;
        }
        if (newAlpha > 255) {
            newAlpha = 255;
        }
        return newAlpha << 24 | argb & 0xFFFFFF;
    }

    private int computeDifficultyHeatColor(Quest q) {
        Set<String> tags = TagAutoDetector.suggestTags(q);
        if (tags.contains("hard")) {
            return -3390396;
        }
        if (tags.contains("medium")) {
            return -1660613;
        }
        if (tags.contains("easy")) {
            return -10040218;
        }
        if (tags.contains("tutorial")) {
            return -10050612;
        }
        return -8355712;
    }

    private int computeProgressHeatColor(Quest q) {
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        if (progress == null) {
            return -8355712;
        }
        if (progress.isQuestCompleted(q.getId())) {
            return -13382605;
        }
        List<Requirement> reqs = q.getRequirements();
        if (reqs == null || reqs.isEmpty()) {
            return -8355712;
        }
        int total = reqs.size();
        int met = 0;
        for (Requirement req : reqs) {
            if (!req.isMet(progress, q.getId())) continue;
            ++met;
        }
        double frac = Math.max(0.0, Math.min(1.0, total == 0 ? 0.0 : (double)met / (double)total));
        return this.colorFromFraction(frac);
    }

    private int computeTagHeatColor(Quest q) {
        HashSet<String> tags = new HashSet<String>(q.getTags());
        tags.addAll(TagAutoDetector.suggestTags(q));
        if (tags.contains("combat")) {
            return -3390396;
        }
        if (tags.contains("exploration")) {
            return -10050612;
        }
        if (tags.contains("crafting")) {
            return -1660613;
        }
        if (tags.contains("mining")) {
            return -6390961;
        }
        if (tags.contains("building")) {
            return -4473925;
        }
        if (tags.contains("trading")) {
            return -11751600;
        }
        if (tags.contains("magic")) {
            return -6543440;
        }
        if (tags.contains("technology")) {
            return -16728876;
        }
        return -8355712;
    }

    private int colorFromFraction(double f) {
        int g;
        int r;
        if (f < 0.5) {
            t = f / 0.5;
            r = 204;
            g = (int)Math.round(68.0 + t * 162.0);
        } else {
            t = (f - 0.5) / 0.5;
            r = (int)Math.round(204.0 - t * 153.0);
            g = 230;
        }
        int b = 51;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int blendARGB(int dst, int src) {
        int aS = src >>> 24 & 0xFF;
        if (aS <= 0) {
            return dst;
        }
        int rS = src >>> 16 & 0xFF;
        int gS = src >>> 8 & 0xFF;
        int bS = src & 0xFF;
        int aD = dst >>> 24 & 0xFF;
        int rD = dst >>> 16 & 0xFF;
        int gD = dst >>> 8 & 0xFF;
        int bD = dst & 0xFF;
        int aO = aS + aD * (255 - aS) / 255;
        int rO = (rS * aS + rD * (255 - aS)) / 255;
        int gO = (gS * aS + gD * (255 - aS)) / 255;
        int bO = (bS * aS + bD * (255 - aS)) / 255;
        return aO << 24 | rO << 16 | gO << 8 | bO;
    }

    private void renderMiniMap(class_332 g, int x, int y, int w, int h, int graphLeft, int graphTop, int graphRight, int graphBottom) {
        int pct = ClientConfig.getMiniMapOpacityPct();
        int baseA = (int)Math.round(192.0 * ((double)pct / 100.0));
        int panel = (baseA & 0xFF) << 24 | 0x101010;
        g.method_25294(x, y, x + w, y + h, panel);
        g.method_25294(x, y, x + w, y + 1, -12566464);
        g.method_25294(x, y + h - 1, x + w, y + h, -12566464);
        g.method_25294(x, y, x + 1, y + h, -12566464);
        g.method_25294(x + w - 1, y, x + w, y + h, -12566464);
        double gw = Math.max(1.0, this.questMaxX - this.questMinX);
        double gh = Math.max(1.0, this.questMaxY - this.questMinY);
        int headerH = 14;
        g.method_25294(x, y, x + w, y + headerH, -2145904616);
        g.method_25303(this.field_22793, "Mini-map", x + 4, y + 3, 0xFFFFFF);
        this.lastMiniMapGearRect = new int[]{x + w - 26, y + 2, 24, 10};
        g.method_25294(this.lastMiniMapGearRect[0], this.lastMiniMapGearRect[1], this.lastMiniMapGearRect[0] + this.lastMiniMapGearRect[2], this.lastMiniMapGearRect[1] + this.lastMiniMapGearRect[3], -2144128205);
        g.method_25303(this.field_22793, "\u2699", this.lastMiniMapGearRect[0] + 7, this.lastMiniMapGearRect[1] + 1, 0xFFFFFF);
        for (Quest q : this.visibleQuests) {
            double nx = ((double)q.getX() - this.questMinX) / gw;
            double ny = ((double)q.getY() - this.questMinY) / gh;
            int px = x + 4 + (int)Math.round(nx * (double)(w - 8));
            int py = y + headerH + 4 + (int)Math.round(ny * (double)(h - headerH - 8));
            int col = -5592406;
            if (ClientQuestManager.getInstance().isQuestCompleted(q.getId())) {
                col = -10040218;
            }
            g.method_25294(px - 1, py - 1, px + 1, py + 1, col);
        }
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        double vw = graphRight - graphLeft;
        double vh = graphBottom - graphTop;
        double vx0 = this.scrollX;
        double vy0 = this.scrollY;
        double totalW = Math.max(1.0, (this.questMaxX - this.questMinX) * (bs + bp));
        double totalH = Math.max(1.0, (this.questMaxY - this.questMinY) * (bs + bp));
        int innerX = x + 4;
        int innerY = y + headerH + 4;
        int innerW = Math.max(1, w - 8);
        int innerH = Math.max(1, h - headerH - 8);
        int rx0 = innerX + (int)Math.round(vx0 / totalW * (double)innerW);
        int ry0 = innerY + (int)Math.round(vy0 / totalH * (double)innerH);
        int rpw = (int)Math.round(Math.min(1.0, vw / totalW) * (double)innerW);
        int rph = (int)Math.round(Math.min(1.0, vh / totalH) * (double)innerH);
        rpw = Math.max(4, Math.min(innerW, rpw));
        rph = Math.max(4, Math.min(innerH, rph));
        int rx1 = rx0 + rpw;
        int ry1 = ry0 + rph;
        if (rx0 < innerX) {
            rx0 = innerX;
            rx1 = innerX + rpw;
        }
        if (ry0 < innerY) {
            ry0 = innerY;
            ry1 = innerY + rph;
        }
        if (rx1 > innerX + innerW) {
            rx1 = innerX + innerW;
            rx0 = rx1 - rpw;
        }
        if (ry1 > innerY + innerH) {
            ry1 = innerY + innerH;
            ry0 = ry1 - rph;
        }
        int rc = -2130706433;
        g.method_25294(rx0, ry0, rx1, ry0 + 1, rc);
        g.method_25294(rx0, ry1, rx1, ry1 + 1, rc);
        g.method_25294(rx0, ry0, rx0 + 1, ry1, rc);
        g.method_25294(rx1, ry0, rx1 + 1, ry1, rc);
        this.miniMapSizeOptionRects = null;
        this.miniMapOpacityOptionRects = null;
        if (this.miniMapSettingsOpen) {
            int menuW = 160;
            int menuH = 74;
            int mx = x + w - menuW - 4;
            int my = y + headerH + 4;
            g.method_25294(mx, my, mx + menuW, my + menuH, -535555052);
            g.method_25294(mx, my, mx + menuW, my + 1, -12566464);
            g.method_25294(mx, my + menuH - 1, mx + menuW, my + menuH, -12566464);
            g.method_25294(mx, my, mx + 1, my + menuH, -12566464);
            g.method_25294(mx + menuW - 1, my, mx + menuW, my + menuH, -12566464);
            g.method_25303(this.field_22793, "Size", mx + 6, my + 4, 0xFFFFFF);
            int y1 = my + 18;
            this.miniMapSizeOptionRects = new int[][]{{mx + 6, y1, 46, 12}, {mx + 58, y1, 60, 12}, {mx + 124, y1, 30, 12}};
            this.drawMenuButton(g, this.miniMapSizeOptionRects[0], "Small");
            this.drawMenuButton(g, this.miniMapSizeOptionRects[1], "Medium");
            this.drawMenuButton(g, this.miniMapSizeOptionRects[2], "Large");
            g.method_25303(this.field_22793, "Opacity", mx + 6, my + 36, 0xFFFFFF);
            int y2 = my + 50;
            this.miniMapOpacityOptionRects = new int[][]{{mx + 6, y2, 26, 12}, {mx + 38, y2, 26, 12}, {mx + 70, y2, 26, 12}, {mx + 102, y2, 26, 12}};
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[0], "0%");
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[1], "25%");
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[2], "50%");
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[3], "75%");
        }
    }

    private void drawMenuButton(class_332 g, int[] r, String label) {
        g.method_25294(r[0], r[1], r[0] + r[2], r[1] + r[3], -2144128205);
        int tx = r[0] + Math.max(2, (r[2] - this.field_22793.method_1727(label)) / 2);
        int ty = r[1] + 2;
        g.method_25303(this.field_22793, label, tx, ty, 0xFFFFFF);
    }

    private void renderHeatmapLegend(class_332 g, int x, int y, int w, int h) {
        int pct = ClientConfig.getHeatOpacityPct();
        int baseA = (int)Math.round(192.0 * ((double)pct / 100.0));
        int panel = (baseA & 0xFF) << 24 | 0x121212;
        g.method_25294(x, y, x + w, y + h, panel);
        g.method_25294(x, y, x + w, y + 1, -12566464);
        g.method_25294(x, y + h - 1, x + w, y + h, -12566464);
        g.method_25294(x, y, x + 1, y + h, -12566464);
        g.method_25294(x + w - 1, y, x + w, y + h, -12566464);
        g.method_25294(x, y, x + w, y + 14, -2145378272);
        g.method_25303(this.field_22793, "Heatmap: " + this.heatmapMode, x + 6, y + 3, 0xFFFFFF);
        int cy = y + 18;
        if ("difficulty".equals(this.heatmapMode)) {
            int cols = w >= 260 ? 2 : 1;
            int colGap = 16;
            int colW = Math.max(60, (w - 12 - (cols - 1) * colGap) / cols);
            String[] labels = new String[]{"Hard", "Medium", "Easy", "Tutorial"};
            int[] colors = new int[]{-3390396, -1660613, -10040218, -10050612};
            int itemsPerCol = (int)Math.ceil((double)labels.length / (double)cols);
            for (int i = 0; i < labels.length; ++i) {
                int col = i / itemsPerCol;
                int row = i % itemsPerCol;
                int lx = x + 6 + col * (colW + colGap);
                int ly = cy + row * 14;
                this.drawLegendRow(g, lx, ly, colors[i], labels[i]);
            }
        } else if ("progress".equals(this.heatmapMode)) {
            int bx = x + 6;
            int by = cy + 8;
            int bw = Math.max(20, w - 12);
            int bh = 8;
            for (int i = 0; i < bw; ++i) {
                double f = (double)i / (double)(bw - 1);
                g.method_25294(bx + i, by, bx + i + 1, by + bh, this.colorFromFraction(f));
            }
            g.method_25303(this.field_22793, "0%", bx, cy, 0xFFFFFF);
            g.method_25303(this.field_22793, "100%", Math.max(bx, x + w - 6 - this.field_22793.method_1727("100%")), cy, 0xFFFFFF);
        } else if ("tags".equals(this.heatmapMode)) {
            String[] labels = new String[]{"Combat", "Exploration", "Crafting", "Mining", "Magic"};
            int[] colors = new int[]{-3390396, -10050612, -1660613, -6390961, -6543440};
            int cols = w >= 300 ? 2 : 1;
            int colGap = 16;
            int colW = Math.max(80, (w - 12 - (cols - 1) * colGap) / cols);
            int itemsPerCol = (int)Math.ceil((double)labels.length / (double)cols);
            for (int i = 0; i < labels.length; ++i) {
                int col = i / itemsPerCol;
                int row = i % itemsPerCol;
                int lx = x + 6 + col * (colW + colGap);
                int ly = cy + row * 14;
                this.drawLegendRow(g, lx, ly, colors[i], labels[i]);
            }
        }
        g.method_25294(x + w - 12, y + h - 12, x + w, y + h, 0x60FFFFFF);
    }

    private void drawLegendRow(class_332 g, int x, int y, int color, String label) {
        g.method_25294(x, y, x + 10, y + 10, color);
        g.method_25303(this.field_22793, label, x + 14, y + 1, 0xFFFFFF);
    }

    private void drawShadowedString(class_332 g, String text, int x, int y, int color) {
        g.method_25303(this.field_22793, text, x + 1, y + 1, -1442840576);
        g.method_25303(this.field_22793, text, x, y, color);
    }

    private void drawShadowedStringCentered(class_332 g, String text, int cx, int y, int color) {
        int w = this.field_22793.method_1727(text);
        this.drawShadowedString(g, text, cx - w / 2, y, color);
    }

    private int computeQuestIconSize(Quest q, int buttonSize) {
        double base = (double)buttonSize * q.getSize() * q.getIconScale();
        double minSize = 20.0 + Math.sqrt(Math.max(1.0, (double)this.zoom)) * 4.0;
        double maxSize = 96.0 + Math.sqrt(Math.max(1.0, (double)this.zoom)) * 8.0;
        return (int)Math.round(class_3532.method_15350((double)base, (double)minSize, (double)maxSize));
    }

    private void drawNode(class_332 g, Quest q, int[] screenPos, int buttonSize, int mouseX, int mouseY) {
        int iy;
        int ix;
        int size = this.computeQuestIconSize(q, buttonSize);
        int padding = Math.max(2, size / 6);
        int x = screenPos[0] - size / 2;
        int y = screenPos[1] - size / 2;
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        boolean completed = cqm.isQuestCompleted(q.getId());
        boolean canComplete = cqm.canCompleteQuest(q.getId());
        boolean selected = q.equals(this.selectedQuest);
        QuestShape shape = QuestShape.get(q.getShape());
        boolean hovered = shape.contains(x, y, size, mouseX, mouseY);
        int bgColor = -15066598;
        int outlineColor = selected ? (this.enableAnimations ? AnimationHelper.QuestButtonAnimation.getOutlineColor(true, hovered) : (Integer)ThemeProperties.QUEST_SELECTED_COLOR.get(q)) : (completed ? (Integer)ThemeProperties.QUEST_COMPLETED_COLOR.get(q) : (canComplete ? ((Integer)ThemeProperties.QUEST_STARTED_COLOR.get(q)).intValue() : ((Integer)ThemeProperties.QUEST_LOCKED_COLOR.get(q)).intValue()));
        int baseBg = -14013910;
        if (!"off".equals(this.heatmapMode)) {
            baseBg = this.blendARGB(baseBg, (switch (this.heatmapMode) {
                case "progress" -> this.computeProgressHeatColor(q);
                case "tags" -> this.computeTagHeatColor(q);
                default -> this.computeDifficultyHeatColor(q);
            }) & 0xFFFFFF | 0x55000000);
        }
        shape.drawBackground(g, x, y, size, baseBg);
        if (hovered) {
            int hoverAlpha = this.enableAnimations ? AnimationHelper.getPulsingAlpha(40, 100, 0.005) : 64;
            shape.drawBackground(g, x, y, size, hoverAlpha << 24 | 0xFFFFFF);
        }
        int outlineThickness = Math.max(1, size / 20);
        shape.drawOutline(g, x, y, size, outlineColor, outlineThickness);
        if (!q.getIcon().isEmpty()) {
            int iconSize = (int)((double)size * 0.65);
            int iconX = x + (size - iconSize) / 2;
            int iconY = y + (size - iconSize) / 2;
            QuestIconRenderer.render(g, q.getIcon(), iconX, iconY, iconSize);
        }
        if (completed) {
            int indicatorSize = Math.max(10, size / 4);
            ix = x + size - indicatorSize - 2;
            iy = y + 2;
            ThemeIconRenderer.draw(g, ThemeProperties.CHECK_ICON, ix, iy, indicatorSize, indicatorSize);
        }
        if (!canComplete) {
            int s = Math.max(10, size / 4);
            ix = x + size - s - 2;
            iy = y + size - s - 2;
            ThemeIconRenderer.draw(g, ThemeProperties.LOCK_ICON, ix, iy, s, s);
        }
        if (q.isHidden()) {
            int s = Math.max(10, size / 4);
            ThemeIconRenderer.draw(g, ThemeProperties.HIDDEN_ICON, x + 2, y + 2, s, s);
        }
        Object title = q.getTitle();
        int maxTitleWidth = Math.max(size + 20, 80);
        if (this.field_22793.method_1727((String)title) > maxTitleWidth) {
            title = this.field_22793.method_27523((String)title, maxTitleWidth - 10) + "...";
        }
        int titleX = x + (size - this.field_22793.method_1727((String)title)) / 2;
        int titleColor = hovered ? (Integer)ThemeProperties.HOVER_TEXT_COLOR.get(q) : (Integer)ThemeProperties.TEXT_COLOR.get(q);
        g.method_25303(this.field_22793, (String)title, titleX, y + size + 2, titleColor);
    }

    private void renderDetailsPanel(class_332 g) {
        int cy;
        int x = this.field_22789 - 260 - 8;
        int y = 30;
        int w = 260;
        int h = this.field_22790 - 70;
        int bgCol = (Integer)ThemeProperties.WIDGET_BACKGROUND.get();
        int borderCol = (Integer)ThemeProperties.WIDGET_BORDER.get();
        g.method_25294(x, y, x + w, y + h, bgCol);
        g.method_25294(x - 1, y - 1, x + w + 1, y, borderCol);
        g.method_25294(x - 1, y + h, x + w + 1, y + h + 1, borderCol);
        g.method_25294(x - 1, y, x, y + h, borderCol);
        g.method_25294(x + w, y, x + w + 1, y + h, borderCol);
        g.method_44379(x, y, x + w, y + h);
        int contentStartY = cy = y + 6 - this.detailsPanelScroll;
        g.method_25303(this.field_22793, this.selectedQuest.getTitle(), x + 6, cy, 0xFFFFFF);
        QuestIconRenderer.render(g, this.selectedQuest.getIcon(), x + 6, cy += 14, 24);
        boolean tracked = ClientConfig.isQuestTracked(this.selectedQuest.getId());
        String trackLabel = tracked ? "Track: On" : "Track: Off";
        int tbx = x + 36;
        int tby = cy + 4;
        int tbw = Math.max(70, this.field_22793.method_1727(trackLabel) + 12);
        int tbh = 12;
        int bg = tracked ? -2142458032 : -2144128205;
        g.method_25294(tbx, tby, tbx + tbw, tby + tbh, bg);
        g.method_25303(this.field_22793, trackLabel, tbx + 6, tby + 2, 0xFFFFFF);
        this.lastDetailsTrackRect = new int[]{tbx, tby, tbw, tbh};
        cy += 28;
        String desc = this.selectedQuest.getDescription();
        for (String line : this.splitText(desc, w - 20)) {
            g.method_25303(this.field_22793, line, x + 6, cy, 0xCCCCCC);
            cy += 10;
        }
        int tasksColor = (Integer)ThemeProperties.TASKS_TEXT_COLOR.get();
        g.method_25303(this.field_22793, "Requirements:", x + 6, cy += 6, tasksColor);
        cy += 12;
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        for (Requirement requirement : this.selectedQuest.getRequirements()) {
            String txt = requirement.getProgressDisplay(progress, this.selectedQuest.getId());
            g.method_25303(this.field_22793, "  \u2022 " + txt, x + 6, cy, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
            cy += 10;
        }
        cy += 4;
        if (!this.selectedQuest.getRewards().isEmpty()) {
            int rewardsColor = (Integer)ThemeProperties.REWARDS_TEXT_COLOR.get();
            g.method_25303(this.field_22793, "Rewards:", x + 6, cy, rewardsColor);
            cy += 12;
            for (Reward reward : this.selectedQuest.getRewards()) {
                g.method_25303(this.field_22793, "  \u2022 " + reward.getDisplayString(), x + 6, cy, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
                cy += 10;
            }
        }
        this.detailsPanelContentHeight = cy - contentStartY + 10;
        g.method_44380();
        if (this.detailsPanelContentHeight > h) {
            int scrollbarX = x + w - 6;
            int n = Math.max(20, h * h / this.detailsPanelContentHeight);
            int maxScroll = this.detailsPanelContentHeight - h;
            int scrollbarY = y + (int)((double)this.detailsPanelScroll / (double)maxScroll * (double)(h - n));
            IconProperty trackIcon = ThemeProperties.SCROLL_BAR_BACKGROUND;
            if (trackIcon.getResourceLocation() != null) {
                ThemeIconRenderer.draw(g, trackIcon, scrollbarX, y, 4, h);
            } else {
                g.method_25294(scrollbarX, y, scrollbarX + 4, y + h, Integer.MIN_VALUE);
            }
            IconProperty thumbIcon = ThemeProperties.SCROLL_BAR;
            if (thumbIcon.getResourceLocation() != null) {
                ThemeIconRenderer.draw(g, thumbIcon, scrollbarX, scrollbarY, 4, n);
            } else {
                g.method_25294(scrollbarX, scrollbarY, scrollbarX + 4, scrollbarY + n, -5592406);
            }
        }
    }

    private List<String> splitText(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        text = text.replaceAll("&[0-9a-fk-or]", "");
        for (String paragraph : paragraphs = text.split("\\n")) {
            if (paragraph.trim().isEmpty()) {
                lines.add("");
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder current = new StringBuilder();
            for (String w : words) {
                String test;
                String string = test = current.length() == 0 ? w : String.valueOf(current) + " " + w;
                if (this.field_22793.method_1727(test) <= maxWidth) {
                    if (current.length() > 0) {
                        current.append(" ");
                    }
                    current.append(w);
                    continue;
                }
                if (current.length() > 0) {
                    lines.add(current.toString());
                }
                current = new StringBuilder(w);
            }
            if (current.length() <= 0) continue;
            lines.add(current.toString());
        }
        return lines;
    }

    private void drawLine(class_332 g, int x1, int y1, int x2, int y2, int argb, boolean dashed, float thickness, float offset, class_2960 texture) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        float len = (float)Math.hypot(dx, dy);
        if (len <= 0.5f) {
            g.method_25294(x1, y1, x1 + 1, y1 + 1, argb);
            return;
        }
        if (dashed) {
            float dash;
            float gap = dash = Math.max(6.0f, thickness * 3.0f);
            for (float dist = 0.0f; dist < len; dist += dash + gap) {
                float seg = Math.min(dash, len - dist);
                float t1 = dist / len;
                float t2 = (dist + seg) / len;
                int sx = Math.round((float)x1 + (float)dx * t1);
                int sy = Math.round((float)y1 + (float)dy * t1);
                int ex = Math.round((float)x1 + (float)dx * t2);
                int ey = Math.round((float)y1 + (float)dy * t2);
                this.drawLine(g, sx, sy, ex, ey, argb, false, thickness, offset, texture);
            }
            return;
        }
        float half = Math.max(1.0f, thickness / 2.0f);
        if (texture != null) {
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
            float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
            float gch = (float)(argb >>> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            float mu = (offset % 1.0f + 1.0f) % 1.0f;
            class_4587 pose = g.method_51448();
            pose.method_22903();
            pose.method_46416((float)x1, (float)y1, 0.0f);
            pose.method_22907(class_7833.field_40718.rotation((float)Math.atan2(dy, dx)));
            Matrix4f m = pose.method_23760().method_23761();
            class_289 tess = class_289.method_1348();
            class_287 buf = tess.method_1349();
            buf.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            int ai = Math.round(a * 255.0f);
            int ri = Math.round(r * 255.0f);
            int gi = Math.round(gch * 255.0f);
            int bi = Math.round(b * 255.0f);
            int ri2 = ri * 3 / 4;
            int gi2 = gi * 3 / 4;
            int bi2 = bi * 3 / 4;
            buf.method_22918(m, 0.0f, -half, 0.0f).method_1336(ri, gi, bi, ai).method_22913(len / half / 2.0f + mu, 0.0f).method_1344();
            buf.method_22918(m, 0.0f, half, 0.0f).method_1336(ri, gi, bi, ai).method_22913(len / half / 2.0f + mu, 1.0f).method_1344();
            buf.method_22918(m, len, half, 0.0f).method_1336(ri2, gi2, bi2, ai).method_22913(mu, 1.0f).method_1344();
            buf.method_22918(m, len, -half, 0.0f).method_1336(ri2, gi2, bi2, ai).method_22913(mu, 0.0f).method_1344();
            class_286.method_43433((class_287.class_7433)buf.method_1326());
            pose.method_22909();
        } else {
            int minx = Math.min(x1, x2);
            int maxx = Math.max(x1, x2);
            int miny = Math.min(y1, y2);
            int maxy = Math.max(y1, y2);
            int pad = Math.round(half);
            g.method_25294(minx - pad, miny - pad, maxx + pad, maxy + pad, argb);
        }
    }

    private void rebuildBackgroundFromTheme() {
        IconProperty bg = ThemeProperties.BACKGROUND;
        class_2960 loc = bg.getResourceLocation();
        Integer tile = bg.getTileSize();
        this.backgroundTintColor = bg.getColorModifier();
        this.backgroundRenderer = loc == null ? BackgroundRenderer.darkGradient() : (tile != null && tile > 0 ? new BackgroundRenderer().withTiledTexture(loc, tile) : new BackgroundRenderer().withTexture(loc));
        if (this.backgroundTintColor != null) {
            this.backgroundRenderer.withTint(this.backgroundTintColor);
        }
    }

    private void completeSelectedQuest() {
        if (this.selectedQuest != null && ClientQuestManager.getInstance().canCompleteQuest(this.selectedQuest.getId())) {
            NetworkManager.sendToServer(new QuestCompleteRequestPacket(this.selectedQuest.getId()));
        }
    }

    private void completeAllCompletableQuests() {
        List<Quest> list = ClientQuestManager.getInstance().getCompletableQuests();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Quest q : list) {
            NetworkManager.sendToServer(new QuestCompleteRequestPacket(q.getId()));
        }
    }

    private void openThemeEditor() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ThemeEditorScreen(this));
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.backgroundRenderer != null) {
            this.backgroundRenderer.tick();
        }
    }

    private void filterByGroup(String group) {
        if (this.selectedGroup.equals(group)) {
            return;
        }
        this.selectedGroup = group;
        if (this.sidebar != null) {
            this.sidebar.setSelectedGroup(group);
        }
        this.reloadVisibleQuests();
        if (!this.visibleQuests.isEmpty()) {
            this.fitToScreen();
        } else {
            this.alignQuestPositions();
            this.resetScroll();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.sidebar != null && this.sidebar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.showMiniMap && this.lastMiniMapRect != null && button == 0) {
            int nw;
            int x = this.lastMiniMapRect[0];
            int y = this.lastMiniMapRect[1];
            int w = this.lastMiniMapRect[2];
            int h = this.lastMiniMapRect[3];
            boolean insideMenu = false;
            if (this.miniMapSettingsOpen && (this.miniMapSizeOptionRects != null || this.miniMapOpacityOptionRects != null)) {
                if (this.miniMapSizeOptionRects != null) {
                    for (int[] r : this.miniMapSizeOptionRects) {
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        insideMenu = true;
                    }
                }
                if (this.miniMapOpacityOptionRects != null) {
                    for (int[] r : this.miniMapOpacityOptionRects) {
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        insideMenu = true;
                    }
                }
            }
            if (this.miniMapSettingsOpen && this.lastMiniMapGearRect != null && mouseX >= (double)this.lastMiniMapGearRect[0] && mouseX <= (double)(this.lastMiniMapGearRect[0] + this.lastMiniMapGearRect[2]) && mouseY >= (double)this.lastMiniMapGearRect[1] && mouseY <= (double)(this.lastMiniMapGearRect[1] + this.lastMiniMapGearRect[3])) {
                insideMenu = true;
            }
            if (this.miniMapSettingsOpen && !insideMenu) {
                this.miniMapSettingsOpen = false;
            }
            if (this.lastMiniMapGearRect != null && mouseX >= (double)this.lastMiniMapGearRect[0] && mouseX <= (double)(this.lastMiniMapGearRect[0] + this.lastMiniMapGearRect[2]) && mouseY >= (double)this.lastMiniMapGearRect[1] && mouseY <= (double)(this.lastMiniMapGearRect[1] + this.lastMiniMapGearRect[3])) {
                this.miniMapSettingsOpen = !this.miniMapSettingsOpen;
                return true;
            }
            if (this.miniMapSettingsOpen) {
                if (this.miniMapSizeOptionRects != null) {
                    for (int i = 0; i < this.miniMapSizeOptionRects.length; ++i) {
                        int[] r = this.miniMapSizeOptionRects[i];
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        int n = i == 0 ? 140 : (nw = i == 1 ? 180 : 240);
                        int nh = i == 0 ? 90 : (i == 1 ? 120 : 160);
                        int nx = Math.max(0, Math.min(this.field_22789 - nw - 8, x));
                        int ny = Math.max(0, Math.min(this.field_22790 - nh - 8, y));
                        ClientConfig.setMiniMapRect(nx, ny, nw, nh);
                        this.miniMapSettingsOpen = false;
                        return true;
                    }
                }
                if (this.miniMapOpacityOptionRects != null) {
                    for (int i = 0; i < this.miniMapOpacityOptionRects.length; ++i) {
                        int[] r = this.miniMapOpacityOptionRects[i];
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        int pct = switch (i) {
                            case 0 -> 0;
                            case 1 -> 25;
                            case 2 -> 50;
                            default -> 75;
                        };
                        ClientConfig.setMiniMapOpacityPct(pct);
                        this.miniMapSettingsOpen = false;
                        return true;
                    }
                }
            }
            if (this.lastMiniMapHeaderRect != null && mouseX >= (double)this.lastMiniMapHeaderRect[0] && mouseX <= (double)(this.lastMiniMapHeaderRect[0] + this.lastMiniMapHeaderRect[2]) && mouseY >= (double)this.lastMiniMapHeaderRect[1] && mouseY <= (double)(this.lastMiniMapHeaderRect[1] + this.lastMiniMapHeaderRect[3])) {
                long now = System.currentTimeMillis();
                if (now - this.lastHeaderClickMs < 300L) {
                    nw = w;
                    int nh = h;
                    int[][] corners = new int[][]{{8, 8}, {this.field_22789 - nw - 8, 8}, {8, this.field_22790 - nh - 48}, {this.field_22789 - nw - 8, this.field_22790 - nh - 48}};
                    int bx = (int)mouseX;
                    int by = (int)mouseY;
                    double best = Double.MAX_VALUE;
                    int sel = 0;
                    for (int i = 0; i < corners.length; ++i) {
                        double dx = bx - corners[i][0];
                        double dy = by - corners[i][1];
                        double d = dx * dx + dy * dy;
                        if (!(d < best)) continue;
                        best = d;
                        sel = i;
                    }
                    int nx = Math.max(0, Math.min(this.field_22789 - nw - 8, corners[sel][0]));
                    int ny = Math.max(0, Math.min(this.field_22790 - nh - 8, corners[sel][1]));
                    ClientConfig.setMiniMapRect(nx, ny, nw, nh);
                    this.lastHeaderClickMs = 0L;
                    return true;
                }
                this.lastHeaderClickMs = now;
                this.miniMapMoving = true;
                this.miniMapMoveOffsetX = (int)mouseX - x;
                this.miniMapMoveOffsetY = (int)mouseY - y;
                return true;
            }
            if (this.lastMiniMapResizeRect != null && mouseX >= (double)this.lastMiniMapResizeRect[0] && mouseX <= (double)(this.lastMiniMapResizeRect[0] + this.lastMiniMapResizeRect[2]) && mouseY >= (double)this.lastMiniMapResizeRect[1] && mouseY <= (double)(this.lastMiniMapResizeRect[1] + this.lastMiniMapResizeRect[3])) {
                this.miniMapResizing = true;
                return true;
            }
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
                double nx = (mouseX - (double)x - 4.0) / Math.max(1.0, (double)(w - 8));
                double ny = (mouseY - (double)y - 4.0) / Math.max(1.0, (double)(h - 8));
                nx = Math.max(0.0, Math.min(1.0, nx));
                ny = Math.max(0.0, Math.min(1.0, ny));
                double bs = this.getQuestButtonSize();
                double bp = this.getQuestButtonSpacing();
                double totalW = Math.max(1.0, (this.questMaxX - this.questMinX) * (bs + bp));
                double totalH = Math.max(1.0, (this.questMaxY - this.questMinY) * (bs + bp));
                int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getOccupiedWidth() : 0);
                int graphTop = 30;
                int graphRight = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
                int graphBottom = this.field_22790 - 40;
                double vw = graphRight - graphLeft;
                double vh = graphBottom - graphTop;
                double vx0 = nx * totalW - vw / 2.0;
                double vy0 = ny * totalH - vh / 2.0;
                this.scrollX = Math.max(0.0, Math.min(totalW - vw, vx0));
                this.scrollY = Math.max(0.0, Math.min(totalH - vh, vy0));
                this.miniMapDragging = true;
                return true;
            }
        }
        if (!"off".equals(this.heatmapMode) && this.lastHeatRect != null && button == 0) {
            int hx = this.lastHeatRect[0];
            int hy = this.lastHeatRect[1];
            if (this.lastHeatHeaderRect != null && mouseX >= (double)this.lastHeatHeaderRect[0] && mouseX <= (double)(this.lastHeatHeaderRect[0] + this.lastHeatHeaderRect[2]) && mouseY >= (double)this.lastHeatHeaderRect[1] && mouseY <= (double)(this.lastHeatHeaderRect[1] + this.lastHeatHeaderRect[3])) {
                this.heatMoving = true;
                this.heatMoveOffsetX = (int)mouseX - hx;
                this.heatMoveOffsetY = (int)mouseY - hy;
                return true;
            }
            if (this.lastHeatResizeRect != null && mouseX >= (double)this.lastHeatResizeRect[0] && mouseX <= (double)(this.lastHeatResizeRect[0] + this.lastHeatResizeRect[2]) && mouseY >= (double)this.lastHeatResizeRect[1] && mouseY <= (double)(this.lastHeatResizeRect[1] + this.lastHeatResizeRect[3])) {
                this.heatResizing = true;
                return true;
            }
        }
        if (button == 1) {
            this.dragging = true;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        if (this.selectedQuest != null && button == 0 && this.lastDetailsTrackRect != null) {
            int rx = this.lastDetailsTrackRect[0];
            int ry = this.lastDetailsTrackRect[1];
            int rw = this.lastDetailsTrackRect[2];
            int rh = this.lastDetailsTrackRect[3];
            int panelX = this.field_22789 - 260 - 8;
            int panelY = 30;
            int panelW = 260;
            int panelH = this.field_22790 - 70;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH) && mouseX >= (double)rx && mouseX <= (double)(rx + rw) && mouseY >= (double)ry && mouseY <= (double)(ry + rh)) {
                boolean wasTracked = ClientConfig.isQuestTracked(this.selectedQuest.getId());
                ClientConfig.setQuestTracked(this.selectedQuest.getId(), !wasTracked);
                try {
                    MapCompatManager.onClientDataChanged();
                }
                catch (Throwable bs) {
                    // empty catch block
                }
                return true;
            }
        }
        int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getOccupiedWidth() : 0);
        int graphTop = 30;
        double bs = this.getQuestButtonSize();
        boolean clickedQuest = false;
        for (Quest q : this.visibleQuests) {
            int[] p = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            int size = this.computeQuestIconSize(q, (int)Math.round(bs));
            int x = p[0] - size / 2;
            int y = p[1] - size / 2;
            QuestShape shape = QuestShape.get(q.getShape());
            if (!shape.contains(x, y, size, (int)mouseX, (int)mouseY)) continue;
            this.selectedQuest = q;
            this.detailsPanelScroll = 0;
            clickedQuest = true;
            return true;
        }
        if (!clickedQuest && button == 0) {
            this.selectedQuest = null;
            this.detailsPanelScroll = 0;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 1 && this.dragging) {
            this.dragging = false;
            return true;
        }
        if (button == 0 && this.miniMapDragging) {
            this.miniMapDragging = false;
            return true;
        }
        if (button == 0 && this.miniMapMoving) {
            this.miniMapMoving = false;
            return true;
        }
        if (button == 0 && this.miniMapResizing) {
            this.miniMapResizing = false;
            return true;
        }
        if (button == 0 && this.heatMoving) {
            this.heatMoving = false;
            return true;
        }
        if (button == 0 && this.heatResizing) {
            this.heatResizing = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.miniMapDragging && button == 0 && this.lastMiniMapRect != null) {
            int x = this.lastMiniMapRect[0];
            int y = this.lastMiniMapRect[1];
            int w = this.lastMiniMapRect[2];
            int h = this.lastMiniMapRect[3];
            double nx = (mouseX - (double)x - 4.0) / Math.max(1.0, (double)(w - 8));
            double ny = (mouseY - (double)y - 4.0) / Math.max(1.0, (double)(h - 8));
            nx = Math.max(0.0, Math.min(1.0, nx));
            ny = Math.max(0.0, Math.min(1.0, ny));
            double bs = this.getQuestButtonSize();
            double bp = this.getQuestButtonSpacing();
            double totalW = Math.max(1.0, (this.questMaxX - this.questMinX) * (bs + bp));
            double totalH = Math.max(1.0, (this.questMaxY - this.questMinY) * (bs + bp));
            int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getOccupiedWidth() : 0);
            int graphTop = 30;
            int graphRight = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
            int graphBottom = this.field_22790 - 40;
            double vw = graphRight - graphLeft;
            double vh = graphBottom - graphTop;
            double vx0 = nx * totalW - vw / 2.0;
            double vy0 = ny * totalH - vh / 2.0;
            this.scrollX = Math.max(0.0, Math.min(totalW - vw, vx0));
            this.scrollY = Math.max(0.0, Math.min(totalH - vh, vy0));
            return true;
        }
        if (this.miniMapMoving && button == 0 && this.lastMiniMapRect != null) {
            int w = this.lastMiniMapRect[2];
            int h = this.lastMiniMapRect[3];
            int nx = (int)mouseX - this.miniMapMoveOffsetX;
            int ny = (int)mouseY - this.miniMapMoveOffsetY;
            nx = Math.max(0, Math.min(this.field_22789 - w - 8, nx));
            ny = Math.max(0, Math.min(this.field_22790 - h - 8, ny));
            ClientConfig.setMiniMapRect(nx, ny, w, h);
            return true;
        }
        if (this.miniMapResizing && button == 0 && this.lastMiniMapRect != null) {
            int x = this.lastMiniMapRect[0];
            int y = this.lastMiniMapRect[1];
            int nw = Math.max(120, (int)mouseX - x);
            int nh = Math.max(80, (int)mouseY - y);
            nw = Math.min(nw, this.field_22789 - x - 8);
            nh = Math.min(nh, this.field_22790 - y - 8);
            ClientConfig.setMiniMapRect(x, y, nw, nh);
            return true;
        }
        if (this.heatMoving && button == 0 && this.lastHeatRect != null) {
            int w = this.lastHeatRect[2];
            int h = this.lastHeatRect[3];
            int nx = (int)mouseX - this.heatMoveOffsetX;
            int ny = (int)mouseY - this.heatMoveOffsetY;
            nx = Math.max(0, Math.min(this.field_22789 - w - 8, nx));
            ny = Math.max(0, Math.min(this.field_22790 - h - 8, ny));
            ClientConfig.setHeatRect(nx, ny, w, h);
            return true;
        }
        if (this.heatResizing && button == 0 && this.lastHeatRect != null) {
            int x = this.lastHeatRect[0];
            int y = this.lastHeatRect[1];
            int nw = Math.max(140, (int)mouseX - x);
            int nh = Math.max(50, (int)mouseY - y);
            nw = Math.min(nw, this.field_22789 - x - 8);
            nh = Math.min(nh, this.field_22790 - y - 8);
            ClientConfig.setHeatRect(x, y, nw, nh);
            return true;
        }
        if (this.dragging && button == 1) {
            int graphWidth = this.selectedQuest == null ? this.field_22789 - 16 : this.field_22789 - 260 - 16;
            int graphHeight = this.field_22790 - 70;
            int mx = (int)mouseX;
            int my = (int)mouseY;
            this.scrollX = this.scrollWidth > (double)graphWidth ? Math.max(0.0, Math.min(this.scrollWidth - (double)graphWidth, this.scrollX + (double)(this.prevMouseX - mx))) : (this.scrollWidth - (double)graphWidth) / 2.0;
            this.scrollY = this.scrollHeight > (double)graphHeight ? Math.max(0.0, Math.min(this.scrollHeight - (double)graphHeight, this.scrollY + (double)(this.prevMouseY - my))) : (this.scrollHeight - (double)graphHeight) / 2.0;
            this.prevMouseX = mx;
            this.prevMouseY = my;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.sidebar != null && this.sidebar.mouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.selectedQuest != null) {
            int panelX = this.field_22789 - 260 - 8;
            int panelY = 30;
            int panelW = 260;
            int panelH = this.field_22790 - 70;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                int maxScroll = Math.max(0, this.detailsPanelContentHeight - panelH);
                this.detailsPanelScroll = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.detailsPanelScroll - delta * 15.0));
                return true;
            }
        }
        this.addZoom(delta, mouseX, mouseY);
        return true;
    }

    public boolean method_25421() {
        return false;
    }
}

