/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;

public class QuestEvents {
    public static void onItemObtained(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            System.out.println("[Questory Debug] onItemObtained called with empty stack");
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        System.out.println("[Questory Debug] onItemObtained: Player=" + player.method_5477().getString() + ", Item=" + String.valueOf(itemId) + ", Count=" + stack.method_7947());
        QuestManager.getInstance().trackItemProgress(player.method_5667(), itemId.toString(), stack.method_7947(), player);
    }

    public static void onItemCrafted(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        QuestManager.getInstance().trackCraftingProgress(player.method_5667(), itemId.toString(), stack.method_7947(), player);
        QuestEvents.onItemObtained(player, stack);
    }

    public static void onEntityKilled(class_3222 player, class_1309 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        QuestManager.getInstance().trackEntityKillProgress(player.method_5667(), entityId.toString(), 1, player);
    }

    public static void onAdvancementEarned(class_3222 player, class_2960 advancementId) {
        QuestManager.getInstance().trackAdvancementProgress(player.method_5667(), advancementId.toString(), player);
    }

    public static void onPlayerDisconnect(class_3222 player) {
        QuestManager.getInstance().onPlayerDisconnect(player.method_5667());
    }

    public static void onPlayerJoin(class_3222 player) {
        QuestManager.getInstance().onPlayerJoin(player);
    }

    public static void onInventoryChanged(class_3222 player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                int existing;
                int before;
                int cap;
                int invCount;
                if (req instanceof ItemRequirement) {
                    ItemRequirement itemReq = (ItemRequirement)req;
                    invCount = QuestEvents.countItemInInventory(player, itemReq.getItem());
                    cap = Math.min(invCount, itemReq.getCount());
                    if (!itemReq.shouldConsume()) {
                        before = progress.getRequirementProgress(quest.getId(), req);
                        if (before == cap) continue;
                        progress.setRequirementProgress(quest.getId(), req, cap);
                        changed = true;
                        continue;
                    }
                    existing = progress.getRequirementProgress(quest.getId(), req);
                    if (cap <= existing) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                if (!(req instanceof ItemTagRequirement)) continue;
                ItemTagRequirement tagReq = (ItemTagRequirement)req;
                invCount = QuestEvents.countItemTagInInventory(player, tagReq.getTag());
                cap = Math.min(invCount, tagReq.getCount());
                if (!tagReq.shouldConsume()) {
                    before = progress.getRequirementProgress(quest.getId(), req);
                    if (before == cap) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                existing = progress.getRequirementProgress(quest.getId(), req);
                if (cap <= existing) continue;
                progress.setRequirementProgress(quest.getId(), req, cap);
                changed = true;
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static int countItemInInventory(class_3222 player, String itemIdString) {
        class_2960 itemId = new class_2960(itemIdString);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item == null) {
            return 0;
        }
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || stack.method_7909() != item) continue;
            total += stack.method_7947();
        }
        return total;
    }

    private static int countItemTagInInventory(class_3222 player, String tagId) {
        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tagId));
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !stack.method_31573(key)) continue;
            total += stack.method_7947();
        }
        return total;
    }

    public static void onStatisticChanged(class_3222 player, String statistic, int value) {
        QuestManager.getInstance().trackStatisticProgress(player.method_5667(), statistic, value, player);
    }

    public static void onEnvironmentTick(class_3222 player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        boolean changed = false;
        class_3218 level = player.method_51469();
        class_2338 pos = player.method_24515();
        class_2378 biomeRegistry = level.method_30349().method_30530(class_7924.field_41236);
        class_2960 biomeId = biomeRegistry.method_10221((Object)((class_1959)level.method_23753(pos).comp_349()));
        String dimId = level.method_27983().method_29177().toString();
        long dayTime = level.method_8532() % 24000L;
        boolean isRaining = level.method_8419();
        boolean isThundering = level.method_8546();
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                boolean dimOk;
                boolean anyBefore;
                boolean ok;
                if (req instanceof BiomeRequirement) {
                    BiomeRequirement biomeReq = (BiomeRequirement)req;
                    if (biomeReq.isTag()) {
                        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(biomeReq.getBiomeId().substring(1)));
                        ok = level.method_23753(pos).method_40220(key);
                    } else {
                        ok = biomeId != null && biomeId.toString().equals(biomeReq.getBiomeId());
                    }
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof DimensionRequirement) {
                    DimensionRequirement dimReq = (DimensionRequirement)req;
                    ok = dimId.equals(dimReq.getDimensionId());
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof LocationRequirement) {
                    int r;
                    int dz;
                    int dy;
                    LocationRequirement locReq = (LocationRequirement)req;
                    dimOk = locReq.getDimension().equals(dimId);
                    if (!dimOk) continue;
                    int dx = pos.method_10263() - locReq.getX();
                    boolean ok2 = dx * dx + (dy = pos.method_10264() - locReq.getY()) * dy + (dz = pos.method_10260() - locReq.getZ()) * dz <= (r = locReq.getRange()) * r;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore2 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok2 ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore2 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof RegionRequirement) {
                    RegionRequirement regReq = (RegionRequirement)req;
                    dimOk = regReq.getDimension().equals(dimId);
                    boolean in = dimOk && pos.method_10263() >= regReq.getMinX() && pos.method_10263() <= regReq.getMaxX() && pos.method_10264() >= regReq.getMinY() && pos.method_10264() <= regReq.getMaxY() && pos.method_10260() >= regReq.getMinZ() && pos.method_10260() <= regReq.getMaxZ();
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore3 = QuestEvents.hasAnyProgress(progress, quest);
                    int now2 = in ? 1 : 0;
                    if (before == now2) continue;
                    progress.setRequirementProgress(quest.getId(), req, now2);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now2));
                        if (anyBefore3 || now2 <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable ok2) {}
                    continue;
                }
                if (req instanceof TimeRequirement) {
                    long end;
                    TimeRequirement timeReq = (TimeRequirement)req;
                    long start = timeReq.getStart();
                    boolean inWindow = start <= (end = timeReq.getEnd()) ? dayTime >= start && dayTime <= end : dayTime >= start || dayTime <= end;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore4 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = inWindow ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore4 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof WeatherRequirement) {
                    WeatherRequirement weatherReq = (WeatherRequirement)req;
                    ok = switch (weatherReq.getMode()) {
                        default -> throw new IncompatibleClassChangeError();
                        case WeatherRequirement.Mode.CLEAR -> {
                            if (!isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.RAIN -> {
                            if (isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.THUNDER -> isThundering;
                    };
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable now2) {}
                    continue;
                }
                if (!(req instanceof StructureRequirement)) continue;
                StructureRequirement structReq = (StructureRequirement)req;
                ok = false;
                try {
                    class_5138 mgr = level.method_27056();
                    if (structReq.getStructureId().startsWith("#")) {
                        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960(structReq.getStructureId().substring(1)));
                        ok = mgr.method_41413(pos, tag).method_16657();
                    } else {
                        class_5321 key;
                        class_2378 structReg = level.method_30349().method_30530(class_7924.field_41246);
                        class_3195 structure = (class_3195)structReg.method_29107(key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)new class_2960(structReq.getStructureId())));
                        ok = structure != null && mgr.method_38854(pos, structure).method_16657();
                    }
                }
                catch (Throwable mgr) {
                    // empty catch block
                }
                int before = progress.getRequirementProgress(quest.getId(), req);
                anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                int now = ok ? 1 : 0;
                if (before == now) continue;
                progress.setRequirementProgress(quest.getId(), req, now);
                changed = true;
                try {
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                    if (anyBefore || now <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                }
                catch (Throwable throwable) {}
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static boolean hasAnyProgress(QuestProgress progress, Quest quest) {
        for (Requirement r : quest.getRequirements()) {
            if (progress.getRequirementProgress(quest.getId(), r) <= 0) continue;
            return true;
        }
        return false;
    }
}

