/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.fabric;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.commands.QuestCommands;
import org.texboobcat.questory.events.QuestEvents;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.manager.QuestManager;

public final class QuestoryFabric
implements ModInitializer {
    public void onInitialize() {
        System.out.println("[Questory Debug] QuestoryFabric.onInitialize starting...");
        Questory.init();
        Questory.initQuestSystem(FabricLoader.getInstance().getGameDir());
        System.out.println("[Questory Debug] Quest system initialized");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            System.out.println("[Questory Debug] Server starting, reinitializing progress storage for world: " + String.valueOf(server.method_27050(class_5218.field_24188)));
            QuestManager.getInstance().reinitializeProgressStorage(server.method_27050(class_5218.field_24188).resolve("data").resolve("questory"));
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> QuestCommands.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (damageSource.method_5529() instanceof class_3222 && entity instanceof class_1309) {
                class_3222 player = (class_3222)damageSource.method_5529();
                class_1309 living = entity;
                QuestEvents.onEntityKilled(player, living);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> QuestEvents.onInventoryChanged(newPlayer));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> QuestEvents.onPlayerJoin(handler.method_32311()));
        System.out.println("[Questory Debug] All event handlers registered");
        System.out.println("[Questory Debug] QuestoryFabric initialization complete!");
        int[] invScanTicker = new int[]{0};
        int[] envScanTicker = new int[]{0};
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            DailyQuestManager.getInstance().onServerTick(server);
            invScanTicker[0] = invScanTicker[0] + 1;
            if (invScanTicker[0] >= 5) {
                invScanTicker[0] = 0;
                for (class_3222 player : server.method_3760().method_14571()) {
                    QuestEvents.onInventoryChanged(player);
                }
            }
            if ((envScanTicker[0] = envScanTicker[0] + 1) >= 10) {
                envScanTicker[0] = 0;
                for (class_3222 player : server.method_3760().method_14571()) {
                    QuestEvents.onEnvironmentTick(player);
                }
            }
        });
    }
}

