/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StatisticRequirement;

public class QuestProgress {
    private UUID playerId;
    private Set<String> completedQuests;
    private Map<String, Map<String, Integer>> questRequirementProgress;
    private Map<String, Long> questCompletionTimes;
    private Set<String> claimedRewards;
    private String lastCompletedDailyId = "";
    private Map<String, Long> dailyHistory = new HashMap<String, Long>();

    public QuestProgress(UUID playerId) {
        this.playerId = playerId;
        this.completedQuests = new HashSet<String>();
        this.questRequirementProgress = new HashMap<String, Map<String, Integer>>();
        this.questCompletionTimes = new HashMap<String, Long>();
        this.claimedRewards = new HashSet<String>();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isQuestCompleted(String questId) {
        return this.completedQuests.contains(questId);
    }

    public void completeQuest(String questId) {
        if (!this.completedQuests.contains(questId)) {
            this.completedQuests.add(questId);
            this.questCompletionTimes.put(questId, System.currentTimeMillis());
        }
    }

    public void resetQuest(String questId) {
        this.completedQuests.remove(questId);
        this.questRequirementProgress.remove(questId);
        this.questCompletionTimes.remove(questId);
        this.claimedRewards.remove(questId);
    }

    public Set<String> getCompletedQuests() {
        return new HashSet<String>(this.completedQuests);
    }

    public long getCompletionTime(String questId) {
        return this.questCompletionTimes.getOrDefault(questId, 0L);
    }

    public int getRequirementProgress(String questId, Requirement requirement) {
        Map<String, Integer> questProgress = this.questRequirementProgress.get(questId);
        if (questProgress == null) {
            return 0;
        }
        return questProgress.getOrDefault(this.getRequirementKey(requirement), 0);
    }

    public void setRequirementProgress(String questId, Requirement requirement, int progress) {
        Map questProgress = this.questRequirementProgress.computeIfAbsent(questId, k -> new HashMap());
        questProgress.put(this.getRequirementKey(requirement), progress);
    }

    public void addRequirementProgress(String questId, Requirement requirement, int amount) {
        int current = this.getRequirementProgress(questId, requirement);
        this.setRequirementProgress(questId, requirement, current + amount);
    }

    private String getRequirementKey(Requirement requirement) {
        if (requirement instanceof ItemRequirement) {
            ItemRequirement item = (ItemRequirement)requirement;
            return "item_" + item.getItem();
        }
        if (requirement instanceof CraftingRequirement) {
            CraftingRequirement craft = (CraftingRequirement)requirement;
            return "craft_" + craft.getItem();
        }
        if (requirement instanceof EntityKillRequirement) {
            EntityKillRequirement kill = (EntityKillRequirement)requirement;
            return "kill_" + kill.getEntity();
        }
        if (requirement instanceof AdvancementRequirement) {
            AdvancementRequirement adv = (AdvancementRequirement)requirement;
            return "adv_" + adv.getAdvancement();
        }
        if (requirement instanceof CommandRequirement) {
            CommandRequirement cmd = (CommandRequirement)requirement;
            return "cmd_" + cmd.getRequirementId();
        }
        if (requirement instanceof StatisticRequirement) {
            StatisticRequirement stat = (StatisticRequirement)requirement;
            return "stat_" + stat.getStatistic();
        }
        return requirement.getType() + "_" + requirement.hashCode();
    }

    public boolean hasClaimedReward(String questId) {
        return this.claimedRewards.contains(questId);
    }

    public void claimReward(String questId) {
        this.claimedRewards.add(questId);
    }

    public boolean hasCompletedDaily(String dailyId) {
        if (dailyId == null || dailyId.isBlank()) {
            return false;
        }
        return dailyId.equals(this.lastCompletedDailyId) || this.dailyHistory.containsKey(dailyId);
    }

    public void markDailyCompleted(String dailyId) {
        if (dailyId == null || dailyId.isBlank()) {
            return;
        }
        this.lastCompletedDailyId = dailyId;
        this.dailyHistory.putIfAbsent(dailyId, System.currentTimeMillis());
    }

    public String getLastCompletedDailyId() {
        return this.lastCompletedDailyId;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("playerId", this.playerId.toString());
        JsonArray completedArray = new JsonArray();
        for (String string : this.completedQuests) {
            completedArray.add(string);
        }
        json.add("completed", (JsonElement)completedArray);
        JsonObject timesObj = new JsonObject();
        for (Map.Entry<String, Long> entry : this.questCompletionTimes.entrySet()) {
            timesObj.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        json.add("completionTimes", (JsonElement)timesObj);
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, Map<String, Integer>> entry : this.questRequirementProgress.entrySet()) {
            JsonObject questProgressObj = new JsonObject();
            for (Map.Entry<String, Integer> reqEntry : entry.getValue().entrySet()) {
                questProgressObj.addProperty(reqEntry.getKey(), (Number)reqEntry.getValue());
            }
            jsonObject.add(entry.getKey(), (JsonElement)questProgressObj);
        }
        json.add("progress", (JsonElement)jsonObject);
        JsonArray jsonArray = new JsonArray();
        for (String questId : this.claimedRewards) {
            jsonArray.add(questId);
        }
        json.add("claimedRewards", (JsonElement)jsonArray);
        if (this.lastCompletedDailyId != null && !this.lastCompletedDailyId.isBlank()) {
            json.addProperty("lastCompletedDailyId", this.lastCompletedDailyId);
        }
        if (this.dailyHistory != null && !this.dailyHistory.isEmpty()) {
            JsonObject jsonObject2 = new JsonObject();
            for (Map.Entry<String, Long> e : this.dailyHistory.entrySet()) {
                jsonObject2.addProperty(e.getKey(), (Number)e.getValue());
            }
            json.add("dailyHistory", (JsonElement)jsonObject2);
        }
        return json;
    }

    public static QuestProgress fromJson(JsonObject json) {
        UUID playerId = UUID.fromString(json.get("playerId").getAsString());
        QuestProgress progress = new QuestProgress(playerId);
        if (json.has("completed")) {
            JsonArray completedArray = json.getAsJsonArray("completed");
            for (JsonElement element : completedArray) {
                progress.completedQuests.add(element.getAsString());
            }
        }
        if (json.has("completionTimes")) {
            JsonObject timesObj = json.getAsJsonObject("completionTimes");
            for (Map.Entry entry : timesObj.entrySet()) {
                progress.questCompletionTimes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
            }
        }
        if (json.has("progress")) {
            JsonObject progressObj = json.getAsJsonObject("progress");
            for (Map.Entry questEntry : progressObj.entrySet()) {
                String questId = (String)questEntry.getKey();
                JsonObject questProgressObj = ((JsonElement)questEntry.getValue()).getAsJsonObject();
                HashMap<String, Integer> questProgress = new HashMap<String, Integer>();
                for (Map.Entry reqEntry : questProgressObj.entrySet()) {
                    questProgress.put((String)reqEntry.getKey(), ((JsonElement)reqEntry.getValue()).getAsInt());
                }
                progress.questRequirementProgress.put(questId, questProgress);
            }
        }
        if (json.has("claimedRewards")) {
            JsonArray claimedArray = json.getAsJsonArray("claimedRewards");
            for (JsonElement element : claimedArray) {
                progress.claimedRewards.add(element.getAsString());
            }
        }
        if (json.has("lastCompletedDailyId")) {
            progress.lastCompletedDailyId = json.get("lastCompletedDailyId").getAsString();
        }
        if (json.has("dailyHistory")) {
            JsonObject hist = json.getAsJsonObject("dailyHistory");
            for (Map.Entry entry : hist.entrySet()) {
                progress.dailyHistory.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
            }
        }
        return progress;
    }
}

