/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.ColorPickerScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.SelectorEditorScreen;
import org.texboobcat.questory.client.gui.ThemePreviewPanel;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;
import org.texboobcat.questory.client.gui.editor.CloseConfirmationDialog;
import org.texboobcat.questory.client.gui.editor.EditorSettingsScreen;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.theme.PropertyDescriptions;
import org.texboobcat.questory.theme.PropertyMetadata;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;
import org.texboobcat.questory.theme.ThemeValidator;
import org.texboobcat.questory.theme.property.ColorProperty;
import org.texboobcat.questory.theme.property.DoubleProperty;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.IntProperty;
import org.texboobcat.questory.theme.property.StringProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class NewThemeEditorScreen
extends class_437 {
    private static final int LEFT_W = 260;
    private static final int TOP_BAR_H = 26;
    private static final int FOOTER_H = 48;
    private static final int PAD = 6;
    private final class_437 parent;
    private String themeName = "custom_theme";
    private final AutoSaveManager autoSaveManager;
    private boolean hasUnsavedChanges = false;
    private class_342 themeNameBox;
    private class_342 searchBox;
    private final Map<String, EditorState> editors = new LinkedHashMap<String, EditorState>();
    private final Map<String, String> labels = new HashMap<String, String>();
    private final Map<String, String> categories = new HashMap<String, String>();
    private String selectedKey = null;
    private String activeCategory = "Colors";
    private int listScroll = 0;
    private int presetIndex = 0;
    private int colorBoxX = -1;
    private int colorBoxY = -1;
    private int colorBoxW = 0;
    private int colorBoxH = 0;
    private int iconBtnX = -1;
    private int iconBtnY = -1;
    private int iconBtnW = 0;
    private int iconBtnH = 0;
    private int iconFieldX = -1;
    private int iconFieldY = -1;
    private int iconFieldW = 0;
    private int iconFieldH = 0;
    private int minusX = -1;
    private int minusY = -1;
    private int minusW = 0;
    private int minusH = 0;
    private int plusX = -1;
    private int plusY = -1;
    private int plusW = 0;
    private int plusH = 0;
    private int resetBtnX = -1;
    private int resetBtnY = -1;
    private int resetBtnW = 0;
    private int resetBtnH = 0;
    private int pinBtnX = -1;
    private int pinBtnY = -1;
    private int pinBtnW = 0;
    private int pinBtnH = 0;
    private long lastClickMs = 0L;
    private final Set<String> modifiedProperties = new HashSet<String>();
    private String hoveredPropertyKey = null;
    private final Map<String, ThemeValidator.ValidationResult> validationResults = new HashMap<String, ThemeValidator.ValidationResult>();
    private final Map<String, Boolean> collapsedSubcategories = new HashMap<String, Boolean>();
    private ThemePreviewPanel previewPanel;
    private final Set<String> pinnedProperties = new HashSet<String>();
    private final Deque<String> recentlyEdited = new ArrayDeque<String>();
    private static final int MAX_RECENT = 10;
    private String lastAppliedTheme = "";
    private final Map<String, ThemeProperty<?>> propertiesByKey = new HashMap();
    private final List<SelectorEntry> selectorEntries = new ArrayList<SelectorEntry>();
    private final ArrayDeque<String> undoStack = new ArrayDeque();
    private final ArrayDeque<String> redoStack = new ArrayDeque();
    private String lastSnapshot = "";
    private long lastCommitMs = 0L;
    private static final ArrayDeque<String> RECENT_ICONS = new ArrayDeque();
    private static final String[] PRESETS = new String[]{"dark", "light", "ftb_like", "minimal"};

    private static void addRecentIcon(String s) {
        if (s == null || s.isBlank()) {
            return;
        }
        RECENT_ICONS.remove(s);
        RECENT_ICONS.addFirst(s);
        while (RECENT_ICONS.size() > 12) {
            RECENT_ICONS.removeLast();
        }
    }

    public static List<String> getRecentIconsSnapshot() {
        return new ArrayList<String>(RECENT_ICONS);
    }

    public NewThemeEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Theme Editor"));
        this.parent = parent;
        this.autoSaveManager = AutoSaveManager.getInstance();
        this.buildEditorsFromRegistry();
        if (!this.editors.isEmpty()) {
            this.selectedKey = this.editors.keySet().iterator().next();
        }
    }

    protected void method_25426() {
        int footerTop;
        super.method_25426();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "theme_editor");
        this.autoSaveManager.register("ThemeEditor", this::autoSaveTheme);
        this.themeNameBox = new class_342(this.field_22793, 6, 6, this.field_22789 - 12, 18, (class_2561)class_2561.method_43470((String)"Theme Name"));
        this.themeNameBox.method_1852(this.themeName);
        this.themeNameBox.method_47404((class_2561)class_2561.method_43470((String)"Enter theme name..."));
        this.themeNameBox.method_1863(s -> {
            this.hasUnsavedChanges = true;
        });
        this.method_37063((class_364)this.themeNameBox);
        int x = 6;
        int y = 32;
        for (String tab : this.getAllCategories()) {
            class_4185 b2 = class_4185.method_46430((class_2561)class_2561.method_43470((String)tab), bt -> {
                this.activeCategory = tab;
                this.listScroll = 0;
            }).method_46434(x, y, 110, 20).method_46431();
            this.method_37063((class_364)b2);
            if ((x += 112) + 112 <= this.field_22789 - 6) continue;
            x = 6;
            y += 22;
        }
        int listX = 6;
        int afterTabsY = y + 22;
        this.searchBox = new class_342(this.field_22793, listX, afterTabsY, 254, 18, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1880(100);
        this.searchBox.method_1852("");
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search properties..."));
        this.method_37063((class_364)this.searchBox);
        int row1Y = footerTop = this.field_22790 - 48 + 2;
        int row2Y = footerTop + 22;
        int bx = 6;
        int btnGap = 4;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preset"), b -> this.cyclePreset()).method_46434(bx, row1Y, 60, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export"), b -> this.exportJson()).method_46434(bx += 60 + btnGap, row1Y, 52, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import"), b -> this.importJson()).method_46434(bx += 52 + btnGap, row1Y, 52, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Selectors"), b -> this.openSelectors()).method_46434(bx += 52 + btnGap + 12, row1Y, 68, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Undo"), b -> this.undo()).method_46434(bx += 68 + btnGap, row1Y, 45, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Redo"), b -> this.redo()).method_46434(bx += 45 + btnGap, row1Y, 45, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save Theme"), b -> this.saveTheme()).method_46434(bx += 45 + btnGap + 12, row1Y, 90, 18).method_46431());
        int row2Center = this.field_22789 / 2 - 100;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply & Back"), b -> {
            this.saveTheme();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(row2Center, row2Y, 88, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), b -> this.openSettings()).method_46434(row2Center + 92, row2Y, 20, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(row2Center + 116, row2Y, 84, 18).method_46431());
    }

    private void openSettings() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new EditorSettingsScreen(this));
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partial) {
        EditorState es;
        this.method_25420(g);
        super.method_25394(g, mouseX, mouseY, partial);
        int listX = 6;
        int listY = 32 + this.calcTabsHeight() + 22;
        int listW = 260;
        int listH = this.field_22790 - 48 - listY - 6;
        int editorX = listX + listW + 6;
        int editorY = listY;
        int editorW = this.field_22789 - editorX - 6;
        int editorH = listH;
        int splitY = editorY + (int)((double)editorH * 0.6);
        int editorPanelH = splitY - editorY;
        int previewPanelY = splitY + 6;
        int previewPanelH = editorY + editorH - previewPanelY;
        g.method_25294(listX, listY, listX + listW, listY + listH, -803200992);
        g.method_25294(editorX, editorY, editorX + editorW, editorY + editorPanelH, -804122094);
        g.method_25294(editorX, previewPanelY, editorX + editorW, previewPanelY + previewPanelH, -803727336);
        this.renderPropertyList(g, listX, listY, listW, listH, mouseX, mouseY);
        this.renderSelectedEditor(g, editorX, editorY, editorW, editorPanelH, mouseX, mouseY);
        if (this.previewPanel == null) {
            this.previewPanel = new ThemePreviewPanel(editorX, previewPanelY, editorW, previewPanelH, this.field_22793);
        }
        this.previewPanel.render(g, mouseX, mouseY);
        Object titleText = this.field_22785.getString();
        if (this.hasUnsavedChanges || !this.modifiedProperties.isEmpty()) {
            titleText = "* " + (String)titleText + " (Unsaved)";
            g.method_25300(this.field_22793, (String)titleText, this.field_22789 / 2, 8, -22016);
        } else {
            g.method_25300(this.field_22793, (String)titleText, this.field_22789 / 2, 8, -1);
        }
        if (this.autoSaveManager.isEnabled()) {
            String status = this.autoSaveManager.getStatusString();
            g.method_25303(this.field_22793, status, this.field_22789 - this.field_22793.method_1727(status) - 6, 8, -7829368);
        }
        this.renderTooltip(g, mouseX, mouseY);
        if (this.selectedKey != null && (es = this.editors.get(this.selectedKey)) != null && es.editor instanceof class_342) {
            es.editor.method_1865();
        }
        if (this.searchBox != null) {
            this.searchBox.method_1865();
        }
    }

    private void renderTooltip(class_332 g, int mouseX, int mouseY) {
        if (this.hoveredPropertyKey == null) {
            return;
        }
        PropertyMetadata meta = PropertyDescriptions.get(this.hoveredPropertyKey);
        String tooltip = meta.getDescription();
        int tooltipW = this.field_22793.method_1727(tooltip) + 8;
        int tooltipH = 20;
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 8;
        if (tooltipX + tooltipW > this.field_22789) {
            tooltipX = this.field_22789 - tooltipW - 4;
        }
        if (tooltipY + tooltipH > this.field_22790) {
            tooltipY = mouseY - tooltipH - 8;
        }
        g.method_25294(tooltipX, tooltipY, tooltipX + tooltipW, tooltipY + tooltipH, -268435456);
        g.method_25294(tooltipX, tooltipY, tooltipX + tooltipW, tooltipY + 1, -11890462);
        g.method_25303(this.field_22793, "\u00a7f" + tooltip, tooltipX + 4, tooltipY + 6, -1);
    }

    private void renderPropertyList(class_332 g, int x, int y, int w, int h, int mouseX, int mouseY) {
        int cy;
        List<String> keys = this.filteredKeys();
        g.method_25303(this.field_22793, "Properties (" + this.activeCategory + ")", x + 4, y + 4, -86);
        this.hoveredPropertyKey = null;
        LinkedHashMap<String, List> grouped = new LinkedHashMap<String, List>();
        for (String key : keys) {
            PropertyMetadata meta = PropertyDescriptions.get(key);
            String subcat = meta.hasSubcategory() ? meta.getSubcategory() : "General";
            grouped.computeIfAbsent(subcat, k -> new ArrayList()).add(key);
        }
        int lineH = 16;
        int subcatH = 18;
        int contentStart = cy = y + 20;
        g.method_44379(x, contentStart, x + w, y + h);
        cy -= this.listScroll;
        for (Map.Entry entry : grouped.entrySet()) {
            String arrow;
            String subcat = (String)entry.getKey();
            List subcatKeys = (List)entry.getValue();
            boolean collapsed = this.collapsedSubcategories.getOrDefault(subcat, false);
            String string = arrow = collapsed ? "\u25b6" : "\u25bc";
            if (cy >= contentStart - subcatH && cy < y + h) {
                boolean subcatHovered = mouseX >= x + 2 && mouseX <= x + w - 2 && mouseY >= cy && mouseY < cy + subcatH;
                int subcatBg = subcatHovered ? 0x40FFFFFF : 0x30000000;
                g.method_25294(x + 2, cy, x + w - 2, cy + subcatH, subcatBg);
                g.method_25294(x + 2, cy + subcatH - 1, x + w - 2, cy + subcatH, 0x60FFFFFF);
                g.method_25303(this.field_22793, arrow + " \u00a7l" + subcat + "\u00a7r \u00a77(" + subcatKeys.size() + ")", x + 6, cy + 5, -8824);
            }
            cy += subcatH;
            if (collapsed) continue;
            for (String key : subcatKeys) {
                if (cy >= contentStart - lineH && cy < y + h) {
                    int bg;
                    boolean hovered;
                    String label = this.labels.getOrDefault(key, key);
                    boolean selected = key.equals(this.selectedKey);
                    boolean bl = hovered = mouseX >= x + 2 && mouseX <= x + w - 2 && mouseY >= cy && mouseY < cy + lineH;
                    if (hovered) {
                        this.hoveredPropertyKey = key;
                    }
                    int n = selected ? -2143659366 : (bg = hovered ? 0x40FFFFFF : 0);
                    if (bg != 0) {
                        g.method_25294(x + 2, cy, x + w - 2, cy + lineH, bg);
                    }
                    if (this.modifiedProperties.contains(key)) {
                        g.method_25294(x + 2, cy, x + 4, cy + lineH, -11890462);
                    }
                    PropertyMetadata meta = PropertyDescriptions.get(key);
                    String pinIndicator = this.pinnedProperties.contains(key) ? "\u2b50 " : "";
                    String displayText = "  " + pinIndicator + meta.getIcon() + " " + label;
                    g.method_25303(this.field_22793, displayText, x + 8, cy + 4, -1);
                }
                cy += lineH;
            }
        }
        g.method_44380();
    }

    public boolean method_25402(double mx, double my, int button) {
        EditorState es;
        for (EditorState es2 : this.editors.values()) {
            if (!(es2.editor instanceof class_342)) continue;
            es2.editor.method_25365(false);
        }
        if (super.method_25402(mx, my, button)) {
            return true;
        }
        int listX = 6;
        int listY = 32 + this.calcTabsHeight() + 22;
        int listW = 260;
        int listH = this.field_22790 - 48 - listY - 6;
        if (mx >= (double)listX && mx <= (double)(listX + listW) && my >= (double)listY && my <= (double)(listY + listH)) {
            int cy;
            List<String> keys = this.filteredKeys();
            LinkedHashMap<String, List> grouped = new LinkedHashMap<String, List>();
            for (String key : keys) {
                PropertyMetadata meta = PropertyDescriptions.get(key);
                String subcat = meta.hasSubcategory() ? meta.getSubcategory() : "General";
                grouped.computeIfAbsent(subcat, k -> new ArrayList()).add(key);
            }
            int lineH = 16;
            int subcatH = 18;
            int contentStart = cy = listY + 20;
            cy -= this.listScroll;
            for (Map.Entry entry : grouped.entrySet()) {
                String subcat = (String)entry.getKey();
                List subcatKeys = (List)entry.getValue();
                if (my >= (double)cy && my < (double)(cy + subcatH) && cy >= contentStart && cy < listY + listH) {
                    this.collapsedSubcategories.put(subcat, this.collapsedSubcategories.getOrDefault(subcat, false) == false);
                    return true;
                }
                cy += subcatH;
                boolean collapsed = this.collapsedSubcategories.getOrDefault(subcat, false);
                if (collapsed) continue;
                for (String key : subcatKeys) {
                    if (my >= (double)cy && my < (double)(cy + lineH) && cy >= contentStart && cy < listY + listH) {
                        this.selectedKey = key;
                        return true;
                    }
                    cy += lineH;
                }
            }
        }
        if (this.selectedKey != null && (es = this.editors.get(this.selectedKey)) != null) {
            if (mx >= (double)this.pinBtnX && mx <= (double)(this.pinBtnX + this.pinBtnW) && my >= (double)this.pinBtnY && my <= (double)(this.pinBtnY + this.pinBtnH)) {
                this.togglePin(this.selectedKey);
                return true;
            }
            if (mx >= (double)this.resetBtnX && mx <= (double)(this.resetBtnX + this.resetBtnW) && my >= (double)this.resetBtnY && my <= (double)(this.resetBtnY + this.resetBtnH)) {
                this.resetToDefault(this.selectedKey);
                return true;
            }
            if (es.type == EditorType.COLOR && mx >= (double)this.colorBoxX && mx <= (double)(this.colorBoxX + this.colorBoxW) && my >= (double)this.colorBoxY && my <= (double)(this.colorBoxY + this.colorBoxH)) {
                this.openColorPicker(es);
                return true;
            }
            if (es.type == EditorType.ICON && mx >= (double)this.iconBtnX && mx <= (double)(this.iconBtnX + this.iconBtnW) && my >= (double)this.iconBtnY && my <= (double)(this.iconBtnY + this.iconBtnH)) {
                this.openIconPicker(es);
                return true;
            }
            if (es.editor instanceof class_342) {
                class_342 editBox = es.editor;
                int ex = editBox.method_46426();
                int ey = editBox.method_46427();
                int ew = editBox.method_25368();
                int eh = editBox.method_25364();
                if (mx >= (double)ex && mx <= (double)(ex + ew) && my >= (double)ey && my <= (double)(ey + eh)) {
                    if (this.searchBox != null) {
                        this.searchBox.method_25365(false);
                    }
                    editBox.method_25365(true);
                    editBox.method_25402(mx, my, button);
                    this.method_25395((class_364)editBox);
                    return true;
                }
            }
            if ((es.type == EditorType.INT || es.type == EditorType.DOUBLE) && mx >= (double)this.minusX && mx <= (double)(this.minusX + this.minusW) && my >= (double)this.minusY && my <= (double)(this.minusY + this.minusH)) {
                this.stepNumber(es, -1);
                return true;
            }
            if ((es.type == EditorType.INT || es.type == EditorType.DOUBLE) && mx >= (double)this.plusX && mx <= (double)(this.plusX + this.plusW) && my >= (double)this.plusY && my <= (double)(this.plusY + this.plusH)) {
                this.stepNumber(es, 1);
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mx, double my, double delta) {
        int listX = 6;
        int listY = 32 + this.calcTabsHeight() + 22;
        int listW = 260;
        int listH = this.field_22790 - 48 - listY - 6;
        if (mx >= (double)listX && mx <= (double)(listX + listW) && my >= (double)listY && my <= (double)(listY + listH)) {
            List<String> keys = this.filteredKeys();
            int lineH = 16;
            int maxLines = Math.max(1, (listH - 4) / lineH);
            int maxStart = Math.max(0, keys.size() - maxLines);
            this.listScroll = (int)Math.max(0.0, Math.min((double)maxStart, (double)this.listScroll - Math.signum(delta)));
            return true;
        }
        return super.method_25401(mx, my, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_342 editBox;
        EditorState es;
        if (this.searchBox != null && this.searchBox.method_25370() && this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.selectedKey != null && (es = this.editors.get(this.selectedKey)) != null && es.editor instanceof class_342 && (editBox = es.editor).method_25370() && editBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        class_342 editBox;
        EditorState es;
        if (this.searchBox != null && this.searchBox.method_25370() && this.searchBox.method_25400(codePoint, modifiers)) {
            return true;
        }
        if (this.selectedKey != null && (es = this.editors.get(this.selectedKey)) != null && es.editor instanceof class_342 && (editBox = es.editor).method_25370() && editBox.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    private void renderSelectedEditor(class_332 g, int x, int y, int w, int h, int mouseX, int mouseY) {
        boolean isPinned;
        if (this.selectedKey == null) {
            return;
        }
        EditorState es = this.editors.get(this.selectedKey);
        if (es == null) {
            return;
        }
        PropertyMetadata meta = PropertyDescriptions.get(this.selectedKey);
        String label = meta.getDisplayName();
        String titleText = label + " (" + String.valueOf((Object)es.type) + ")";
        if (this.modifiedProperties.contains(this.selectedKey)) {
            titleText = "\ud83d\udd35 " + titleText;
        }
        g.method_25303(this.field_22793, titleText, x + 8, y + 8, -1);
        g.method_25303(this.field_22793, "\u00a77" + meta.getDescription(), x + 8, y + 20, -3355444);
        if (meta.hasRelatedProperties()) {
            String related = "\u00a78Related: " + String.join((CharSequence)", ", meta.getRelatedProperties());
            if (this.field_22793.method_1727(related) > w - 20) {
                related = this.field_22793.method_27523(related, w - 30) + "...";
            }
            g.method_25303(this.field_22793, related, x + 8, y + 30, -7829368);
        }
        String pinIcon = (isPinned = this.pinnedProperties.contains(this.selectedKey)) ? "\u2b50" : "\u2606";
        this.pinBtnX = x + w - 140;
        this.pinBtnY = y + 6;
        this.pinBtnW = 60;
        this.pinBtnH = 16;
        g.method_25294(this.pinBtnX, this.pinBtnY, this.pinBtnX + this.pinBtnW, this.pinBtnY + this.pinBtnH, isPinned ? -10855936 : -12303292);
        g.method_25303(this.field_22793, pinIcon + " Pin", this.pinBtnX + 8, this.pinBtnY + 4, -1);
        this.resetBtnX = x + w - 70;
        this.resetBtnY = y + 6;
        this.resetBtnW = 60;
        this.resetBtnH = 16;
        g.method_25294(this.resetBtnX, this.resetBtnY, this.resetBtnX + this.resetBtnW, this.resetBtnY + this.resetBtnH, -12303292);
        g.method_25303(this.field_22793, "Reset", this.resetBtnX + 16, this.resetBtnY + 4, -1);
        int ey = y + 40;
        int fieldW = Math.min(340, w - 16);
        this.plusY = -1;
        this.plusX = -1;
        this.minusY = -1;
        this.minusX = -1;
        this.iconBtnY = -1;
        this.iconBtnX = -1;
        this.colorBoxY = -1;
        this.colorBoxX = -1;
        switch (es.type.ordinal()) {
            case 0: {
                class_342 hex;
                this.colorBoxX = x + 8;
                this.colorBoxY = ey;
                this.colorBoxW = 24;
                this.colorBoxH = 24;
                g.method_25294(this.colorBoxX, this.colorBoxY, this.colorBoxX + this.colorBoxW, this.colorBoxY + this.colorBoxH, es.color);
                if (es.editor == null) {
                    es.editor = new class_342(this.field_22793, x + 40, ey, fieldW, 18, (class_2561)class_2561.method_43470((String)"#AARRGGBB"));
                    es.editor.method_1880(50);
                    es.editor.method_47404((class_2561)class_2561.method_43470((String)"#AARRGGBB or click color box"));
                }
                if (!(hex = es.editor).method_25370()) {
                    hex.method_1852(NewThemeEditorScreen.toHex(es.color));
                }
                hex.method_25394(g, mouseX, mouseY, class_310.method_1551().method_1534());
                break;
            }
            case 1: 
            case 2: {
                class_342 ed;
                if (es.editor == null) {
                    es.editor = new class_342(this.field_22793, x + 8, ey, fieldW, 18, (class_2561)class_2561.method_43470((String)"value"));
                    es.editor.method_1880(500);
                    if (es.type == EditorType.ICON) {
                        es.editor.method_47404((class_2561)class_2561.method_43470((String)"Click to browse textures..."));
                    } else {
                        es.editor.method_47404((class_2561)class_2561.method_43470((String)"Enter value..."));
                    }
                }
                if (!(ed = es.editor).method_25370()) {
                    ed.method_1852(es.string);
                }
                ed.method_25394(g, mouseX, mouseY, class_310.method_1551().method_1534());
                this.iconFieldX = x + 8;
                this.iconFieldY = ey;
                this.iconFieldW = fieldW;
                this.iconFieldH = 18;
                if (es.type != EditorType.ICON) break;
                String txt = " Icon... ";
                this.iconBtnX = x + 8 + fieldW + 8;
                this.iconBtnY = ey;
                this.iconBtnW = this.field_22793.method_1727(txt) + 8;
                this.iconBtnH = 18;
                g.method_25294(this.iconBtnX, this.iconBtnY, this.iconBtnX + this.iconBtnW, this.iconBtnY + this.iconBtnH, -12961222);
                g.method_25303(this.field_22793, txt, this.iconBtnX + 4, this.iconBtnY + 5, -1);
                break;
            }
            case 3: 
            case 4: {
                class_342 ed;
                if (es.editor == null) {
                    es.editor = new class_342(this.field_22793, x + 8, ey, 160, 18, (class_2561)class_2561.method_43470((String)"number"));
                    es.editor.method_1880(50);
                    es.editor.method_47404((class_2561)class_2561.method_43470((String)"Enter number or use +/- buttons"));
                }
                if (!(ed = es.editor).method_25370()) {
                    ed.method_1852(es.string);
                }
                ed.method_25394(g, mouseX, mouseY, class_310.method_1551().method_1534());
                this.minusX = x + 172;
                this.minusY = ey;
                this.minusW = 20;
                this.minusH = 18;
                this.plusX = x + 196;
                this.plusY = ey;
                this.plusW = 20;
                this.plusH = 18;
                g.method_25294(this.minusX, this.minusY, this.minusX + this.minusW, this.minusY + this.minusH, -12961222);
                g.method_25303(this.field_22793, "-", this.minusX + 8, this.minusY + 5, -1);
                g.method_25294(this.plusX, this.plusY, this.plusX + this.plusW, this.plusY + this.plusH, -12961222);
                g.method_25303(this.field_22793, "+", this.plusX + 7, this.plusY + 5, -1);
            }
        }
        ThemeValidator.ValidationResult validation = this.validationResults.get(this.selectedKey);
        if (validation != null && validation.hasIssue()) {
            int valY = ey + 24;
            int color = validation.getLevel() == ThemeValidator.ValidationLevel.ERROR ? -48060 : -22016;
            String icon = validation.getLevel() == ThemeValidator.ValidationLevel.ERROR ? "\u274c" : "\u26a0\ufe0f";
            g.method_25303(this.field_22793, icon + " " + validation.getMessage(), x + 8, valY, color);
        }
        this.applyLiveIfNeeded();
    }

    private void stepNumber(EditorState es, int dir) {
        try {
            if (es.type == EditorType.INT) {
                int v = Integer.parseInt(es.string.trim());
                es.string = String.valueOf(v += dir);
            } else {
                double v = Double.parseDouble(es.string.trim());
                es.string = NewThemeEditorScreen.trimDouble(v += (double)dir * 0.1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void applyLiveIfNeeded() {
        for (Map.Entry<String, EditorState> e : this.editors.entrySet()) {
            String key = e.getKey();
            EditorState es = e.getValue();
            if (!(es.editor instanceof class_342)) continue;
            class_342 ed = es.editor;
            String newValue = ed.method_1882();
            Object currentValue = es.type == EditorType.COLOR ? Integer.valueOf(es.color) : es.string;
            ThemeValidator.ValidationResult validation = ThemeValidator.validate(key, newValue, currentValue);
            this.validationResults.put(key, validation);
            if (!validation.isValid()) continue;
            if (es.type == EditorType.COLOR) {
                int newColor = NewThemeEditorScreen.parseColor(newValue, es.color);
                if (newColor == es.color) continue;
                es.color = newColor;
                this.trackModified(key, newColor);
                continue;
            }
            if (newValue.equals(es.string)) continue;
            es.string = newValue;
            this.trackModified(key, newValue);
        }
        try {
            List<String> lines = this.serializeThemeLines();
            String themeString = String.join((CharSequence)"\n", lines);
            if (!themeString.equals(this.lastAppliedTheme)) {
                QuestTheme t;
                this.lastAppliedTheme = themeString;
                QuestTheme.instance = t = ThemeLoader.parseTheme(lines);
                QuestTheme.instance.clearCache();
                this.commitChangeIfNeeded(lines);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void trackModified(String key, Object newValue) {
        Object defaultValue = PropertyDescriptions.getDefaultValue(key);
        if (defaultValue != null && !defaultValue.equals(newValue)) {
            this.modifiedProperties.add(key);
        } else {
            this.modifiedProperties.remove(key);
        }
        this.hasUnsavedChanges = true;
        this.recentlyEdited.remove(key);
        this.recentlyEdited.addFirst(key);
        while (this.recentlyEdited.size() > 10) {
            this.recentlyEdited.removeLast();
        }
    }

    private void togglePin(String key) {
        if (this.pinnedProperties.contains(key)) {
            this.pinnedProperties.remove(key);
        } else {
            this.pinnedProperties.add(key);
        }
    }

    private void resetToDefault(String key) {
        EditorState es = this.editors.get(key);
        if (es == null) {
            return;
        }
        Object defaultValue = PropertyDescriptions.getDefaultValue(key);
        if (defaultValue == null) {
            return;
        }
        switch (es.type.ordinal()) {
            case 0: {
                if (!(defaultValue instanceof Integer)) break;
                es.color = (Integer)defaultValue;
                if (!(es.editor instanceof class_342)) break;
                es.editor.method_1852(NewThemeEditorScreen.toHex(es.color));
                break;
            }
            case 1: 
            case 2: {
                es.string = String.valueOf(defaultValue);
                if (!(es.editor instanceof class_342)) break;
                es.editor.method_1852(es.string);
                break;
            }
            case 3: {
                if (!(defaultValue instanceof Integer)) break;
                es.string = String.valueOf(defaultValue);
                if (!(es.editor instanceof class_342)) break;
                es.editor.method_1852(es.string);
                break;
            }
            case 4: {
                if (!(defaultValue instanceof Double)) break;
                es.string = NewThemeEditorScreen.trimDouble((Double)defaultValue);
                if (!(es.editor instanceof class_342)) break;
                es.editor.method_1852(es.string);
            }
        }
        this.modifiedProperties.remove(key);
        this.validationResults.remove(key);
    }

    private void saveTheme() {
        block3: {
            try {
                String name = this.themeNameBox.method_1882().isBlank() ? "custom_theme" : this.themeNameBox.method_1882().trim();
                Path dir = Paths.get("config", "questory", "themes");
                Files.createDirectories(dir, new FileAttribute[0]);
                Path out = dir.resolve(name + ".txt");
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("// Generated by Theme Editor");
                lines.addAll(this.serializeThemeLines());
                Files.write(out, lines, new OpenOption[0]);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Saved theme: " + String.valueOf(out.getFileName()))));
                }
                ThemeLoader.loadTheme(out);
                QuestoryConfig config = QuestoryConfig.getInstance();
                config.customThemeName = name;
                QuestoryConfig.save(Paths.get("config", new String[0]));
                this.hasUnsavedChanges = false;
                this.modifiedProperties.clear();
            }
            catch (Exception e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block3;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Save failed: " + e.getMessage())));
            }
        }
    }

    private void autoSaveTheme() {
        if (!this.hasUnsavedChanges) {
            return;
        }
        this.applyLiveIfNeeded();
    }

    private void exportJson() {
        block4: {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonObject root = new JsonObject();
                root.addProperty("name", this.themeNameBox.method_1882());
                JsonObject props = new JsonObject();
                for (String key : this.editors.keySet()) {
                    props.add(key, NewThemeEditorScreen.toJsonPrimitive(this.editors.get(key)));
                }
                root.add("properties", (JsonElement)props);
                Path dir = Paths.get("config", "questory", "themes");
                Files.createDirectories(dir, new FileAttribute[0]);
                Path out = dir.resolve((this.themeNameBox.method_1882().isBlank() ? "custom_theme" : this.themeNameBox.method_1882()) + ".json");
                Files.writeString(out, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Exported JSON: " + String.valueOf(out.getFileName()))));
                }
            }
            catch (Exception e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block4;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Export failed: " + e.getMessage())));
            }
        }
    }

    private void importJson() {
        try {
            Path dir = Paths.get("config", "questory", "themes");
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            Path chosen = null;
            try (Stream<Path> s = Files.list(dir);){
                Iterator<Path> iterator = s.filter(p -> p.toString().endsWith(".json")).toList().iterator();
                if (iterator.hasNext()) {
                    Path p2;
                    chosen = p2 = iterator.next();
                }
            }
            if (chosen == null) {
                return;
            }
            String content = Files.readString(chosen);
            JsonObject root = (JsonObject)new Gson().fromJson(content, JsonObject.class);
            if (root.has("name")) {
                this.themeNameBox.method_1852(root.get("name").getAsString());
            }
            if (root.has("properties")) {
                for (Map.Entry e : root.getAsJsonObject("properties").entrySet()) {
                    EditorState es = this.editors.get(e.getKey());
                    if (es == null) continue;
                    NewThemeEditorScreen.fromJsonPrimitive(es, (JsonElement)e.getValue());
                }
            }
            this.applyLiveIfNeeded();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<String> serializeThemeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("[*]");
        for (String key : this.editors.keySet()) {
            String v = NewThemeEditorScreen.valueToString(this.editors.get(key));
            if (v == null) continue;
            lines.add(key + ": " + v);
        }
        for (SelectorEntry se : this.selectorEntries) {
            if (se == null || se.selector == null || se.selector.isBlank()) continue;
            lines.add("[" + se.selector.trim() + "]");
            for (Map.Entry<String, String> kv : se.values.entrySet()) {
                if (kv.getValue() == null || kv.getValue().isBlank()) continue;
                lines.add(kv.getKey() + ": " + kv.getValue());
            }
        }
        return lines;
    }

    private void commitChangeIfNeeded(List<String> lines) {
        try {
            String s = String.join((CharSequence)"\n", lines);
            long now = System.currentTimeMillis();
            if (!s.equals(this.lastSnapshot) && now - this.lastCommitMs > 120L) {
                this.undoStack.push(this.lastSnapshot);
                this.redoStack.clear();
                this.lastSnapshot = s;
                this.lastCommitMs = now;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void undo() {
        if (this.undoStack.isEmpty()) {
            return;
        }
        String prev = this.undoStack.pop();
        this.redoStack.push(this.lastSnapshot);
        this.restoreSnapshot(prev);
    }

    private void redo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        String next = this.redoStack.pop();
        this.undoStack.push(this.lastSnapshot);
        this.restoreSnapshot(next);
    }

    private void restoreSnapshot(String snap) {
        if (snap == null) {
            snap = "";
        }
        this.lastSnapshot = snap;
        List<String> lines = Arrays.asList(snap.split("\n"));
        HashMap<String, String> def = new HashMap<String, String>();
        this.selectorEntries.clear();
        Map<String, String> current = def;
        String currentSel = "*";
        for (String string : lines) {
            String string2 = string.trim();
            if (string2.isEmpty() || string2.startsWith("//")) continue;
            if (string2.startsWith("[") && string2.endsWith("]")) {
                currentSel = string2.substring(1, string2.length() - 1);
                if (!"*".equals(currentSel)) {
                    SelectorEntry se = new SelectorEntry();
                    se.selector = currentSel;
                    se.values = new HashMap<String, String>();
                    this.selectorEntries.add(se);
                    current = se.values;
                    continue;
                }
                current = def;
                continue;
            }
            String[] parts = string2.split(":", 2);
            if (parts.length != 2) continue;
            current.put(parts[0].trim(), parts[1].trim());
        }
        for (Map.Entry entry : this.editors.entrySet()) {
            String v = (String)def.get(entry.getKey());
            if (v == null) continue;
            if (((EditorState)entry.getValue()).type == EditorType.COLOR) {
                ((EditorState)entry.getValue()).color = NewThemeEditorScreen.parseColor(v, ((EditorState)entry.getValue()).color);
            } else {
                ((EditorState)entry.getValue()).string = v;
            }
            ((EditorState)entry.getValue()).editor = null;
        }
        this.applyLiveIfNeeded();
    }

    private void openSelectors() {
        this.field_22787.method_1507((class_437)new SelectorEditorScreen(this, this.selectorEntries, new ArrayList<String>(this.editors.keySet()), k -> this.labels.getOrDefault(k, (String)k)));
    }

    private void buildEditorsFromRegistry() {
        try {
            for (Field f : ThemeProperties.class.getFields()) {
                EditorState es;
                Object o = f.get(null);
                if (!(o instanceof ThemeProperty)) continue;
                ThemeProperty tp = (ThemeProperty)o;
                String key = tp.getName();
                String label = this.toLabel(key);
                this.propertiesByKey.put(key, tp);
                if (o instanceof ColorProperty) {
                    ColorProperty cp = (ColorProperty)o;
                    es = EditorState.color(key, (Integer)cp.get());
                } else if (o instanceof IntProperty) {
                    IntProperty ip = (IntProperty)o;
                    es = EditorState.number(key, String.valueOf(ip.get()), EditorType.INT);
                } else if (o instanceof DoubleProperty) {
                    DoubleProperty dp = (DoubleProperty)o;
                    es = EditorState.number(key, NewThemeEditorScreen.trimDouble((Double)dp.get()), EditorType.DOUBLE);
                } else if (o instanceof IconProperty) {
                    IconProperty ic = (IconProperty)o;
                    IconProperty.IconData d = (IconProperty.IconData)ic.get();
                    es = EditorState.text(key, d == null ? "" : d.toString(), EditorType.ICON);
                } else {
                    if (!(o instanceof StringProperty)) continue;
                    StringProperty sp = (StringProperty)o;
                    es = EditorState.text(key, (String)sp.get(), EditorType.STRING);
                }
                this.editors.put(key, es);
                this.labels.put(key, label);
                this.categories.put(key, this.categorize(key, o));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<String> getAllCategories() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.pinnedProperties.isEmpty()) {
            result.add("\u2b50 Favorites");
        }
        if (!this.recentlyEdited.isEmpty()) {
            result.add("\ud83d\udd52 Recent");
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String k : this.editors.keySet()) {
            set.add(this.categories.getOrDefault(k, "Other"));
        }
        result.addAll(set);
        return result;
    }

    private List<String> filteredKeys() {
        String q = this.searchBox == null ? "" : this.searchBox.method_1882().trim().toLowerCase();
        ArrayList<String> all = new ArrayList<String>();
        if (this.activeCategory.equals("\u2b50 Favorites")) {
            all.addAll(this.pinnedProperties);
        } else if (this.activeCategory.equals("\ud83d\udd52 Recent")) {
            all.addAll(this.recentlyEdited);
        } else {
            for (String k : this.editors.keySet()) {
                if (!this.categories.getOrDefault(k, "").equals(this.activeCategory)) continue;
                all.add(k);
            }
        }
        if (q.isEmpty()) {
            return all;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (String k : all) {
            if (!this.labels.get(k).toLowerCase().contains(q) && !k.toLowerCase().contains(q)) continue;
            out.add(k);
        }
        return out;
    }

    private int calcTabsHeight() {
        int perRow = Math.max(1, (this.field_22789 - 12) / 112);
        int rows = (this.getAllCategories().size() + perRow - 1) / perRow;
        return rows * 22;
    }

    private String toLabel(String key) {
        PropertyMetadata meta;
        if (PropertyDescriptions.has(key) && (meta = PropertyDescriptions.get(key)).getDisplayName() != null && !meta.getDisplayName().isEmpty()) {
            return meta.getDisplayName();
        }
        String[] parts = key.split("_");
        StringBuilder b = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            b.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(" ");
        }
        return b.toString().trim();
    }

    private String categorize(String key, Object prop) {
        PropertyMetadata meta;
        if (PropertyDescriptions.has(key) && (meta = PropertyDescriptions.get(key)).getCategory() != null && !meta.getCategory().isEmpty()) {
            return meta.getCategory();
        }
        if (key.contains("dependency_line")) {
            return "Dependency Lines";
        }
        if (key.contains("background")) {
            return "Background";
        }
        if (prop instanceof IconProperty) {
            return "Icons";
        }
        if (prop instanceof ColorProperty) {
            return "Colors";
        }
        if (key.contains("quest") || key.contains("widget") || key.contains("spacing") || key.contains("pinned")) {
            return "Quest Appearance";
        }
        if (key.contains("animation") || key.contains("pulse")) {
            return "Animation";
        }
        return "Other";
    }

    private static String trimDouble(double d) {
        String s = String.format(Locale.ROOT, "%.4f", d);
        while (s.contains(".") && (s.endsWith("0") || s.endsWith("."))) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? "0" : s;
    }

    private static int parseColor(String s, int def) {
        try {
            if (s == null) {
                return def;
            }
            String t = s.trim();
            if (t.startsWith("#")) {
                t = t.substring(1);
            }
            if (t.startsWith("0x") || t.startsWith("0X")) {
                t = t.substring(2);
            }
            long v = Long.parseUnsignedLong(t, 16);
            if (t.length() <= 6) {
                v |= 0xFF000000L;
            }
            return (int)v;
        }
        catch (Exception e) {
            return def;
        }
    }

    private static String toHex(int argb) {
        return String.format("#%08X", argb);
    }

    private static String valueToString(EditorState es) {
        return switch (es.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> NewThemeEditorScreen.toHex(es.color);
            case 1, 2, 3, 4 -> es.string == null ? null : es.string;
        };
    }

    private static JsonElement toJsonPrimitive(EditorState es) {
        Gson g = new Gson();
        return g.toJsonTree((Object)NewThemeEditorScreen.valueToString(es));
    }

    private static void fromJsonPrimitive(EditorState es, JsonElement el) {
        if (el == null || el.isJsonNull()) {
            return;
        }
        if (es.type == EditorType.COLOR) {
            es.color = NewThemeEditorScreen.parseColor(el.getAsString(), es.color);
        } else {
            es.string = el.getAsString();
        }
    }

    public void method_25419() {
        if (this.hasUnsavedChanges || !this.modifiedProperties.isEmpty()) {
            this.showCloseConfirmationDialog();
        } else {
            this.autoSaveManager.unregister("ThemeEditor");
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }
    }

    private void showCloseConfirmationDialog() {
        ArrayList<CloseConfirmationDialog.UnsavedEntity> unsavedEntities = new ArrayList<CloseConfirmationDialog.UnsavedEntity>();
        String themeName = this.themeNameBox.method_1882().isBlank() ? "custom_theme" : this.themeNameBox.method_1882().trim();
        unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(themeName, "Theme (" + this.modifiedProperties.size() + " properties changed)", System.currentTimeMillis()));
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new CloseConfirmationDialog(this, this.parent, unsavedEntities, this::saveTheme, () -> {
                this.hasUnsavedChanges = false;
                this.modifiedProperties.clear();
            }, () -> {}));
        }
    }

    private void cyclePreset() {
        block11: {
            try {
                String name = PRESETS[this.presetIndex];
                this.presetIndex = (this.presetIndex + 1) % PRESETS.length;
                class_2960 rl = new class_2960("questory", "presets/" + name + ".txt");
                class_3300 rm = class_310.method_1551().method_1478();
                Optional res = rm.method_14486(rl);
                if (res.isPresent()) {
                    List<String> lines;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)res.get()).method_14482(), StandardCharsets.UTF_8));){
                        lines = reader.lines().toList();
                    }
                    QuestTheme t = ThemeLoader.parseTheme(lines);
                    this.applyThemeToEditors(t);
                    this.themeNameBox.method_1852(name);
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Loaded preset: " + name)));
                    }
                    break block11;
                }
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Preset not found: " + name)));
                }
            }
            catch (Exception e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block11;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Preset load failed: " + e.getMessage())));
            }
        }
    }

    private void applyThemeToEditors(QuestTheme t) {
        QuestTheme.instance = t;
        QuestTheme.instance.clearCache();
        for (Map.Entry<String, EditorState> e : this.editors.entrySet()) {
            String key = e.getKey();
            EditorState es = e.getValue();
            ThemeProperty<?> prop = this.propertiesByKey.get(key);
            if (prop instanceof ColorProperty) {
                ColorProperty cp = (ColorProperty)prop;
                es.color = (Integer)cp.get();
            } else if (prop instanceof IntProperty) {
                IntProperty ip = (IntProperty)prop;
                es.string = String.valueOf(ip.get());
            } else if (prop instanceof DoubleProperty) {
                DoubleProperty dp = (DoubleProperty)prop;
                es.string = NewThemeEditorScreen.trimDouble((Double)dp.get());
            } else if (prop instanceof IconProperty) {
                IconProperty ic = (IconProperty)prop;
                IconProperty.IconData d = (IconProperty.IconData)ic.get();
                es.string = d == null ? "" : d.toString();
            } else if (prop instanceof StringProperty) {
                StringProperty sp = (StringProperty)prop;
                es.string = (String)sp.get();
            }
            es.editor = null;
        }
        this.applyLiveIfNeeded();
    }

    private void openColorPicker(EditorState es) {
        this.field_22787.method_1507((class_437)new ColorPickerScreen(this, es.color, c -> {
            es.color = c;
            es.editor = null;
            this.applyLiveIfNeeded();
        }));
    }

    private void openIconPicker(EditorState es) {
        this.field_22787.method_1507((class_437)new IconPickerScreen(this, es.string, result -> {
            es.string = result;
            es.editor = null;
            NewThemeEditorScreen.addRecentIcon(result);
            this.applyLiveIfNeeded();
        }));
    }

    private static class EditorState {
        final String key;
        final EditorType type;
        class_342 editor;
        int color;
        String string;

        static EditorState color(String key, int argb) {
            EditorState e = new EditorState(key, EditorType.COLOR);
            e.color = argb;
            return e;
        }

        static EditorState text(String key, String s, EditorType t) {
            EditorState e = new EditorState(key, t);
            e.string = s == null ? "" : s;
            return e;
        }

        static EditorState number(String key, String s, EditorType t) {
            return EditorState.text(key, s, t);
        }

        EditorState(String key, EditorType type) {
            this.key = key;
            this.type = type;
        }
    }

    private static enum EditorType {
        COLOR,
        STRING,
        ICON,
        INT,
        DOUBLE;

    }

    public static class SelectorEntry {
        public String selector;
        public Map<String, String> values;
    }
}

