/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.AdvancedTabPanel;
import org.texboobcat.questory.client.gui.DependenciesTabPanel;
import org.texboobcat.questory.client.gui.GeneralTabPanel;
import org.texboobcat.questory.client.gui.PreviewTabPanel;
import org.texboobcat.questory.client.gui.RequirementsTabPanel;
import org.texboobcat.questory.client.gui.RewardsTabPanel;
import org.texboobcat.questory.client.gui.TeamTabPanel;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;
import org.texboobcat.questory.client.gui.editor.CloseConfirmationDialog;
import org.texboobcat.questory.client.gui.editor.EditorSettingsScreen;
import org.texboobcat.questory.client.gui.editor.EditorStateManager;
import org.texboobcat.questory.client.gui.editor.ManagedEditor;
import org.texboobcat.questory.client.gui.editor.UnsavedChangesCache;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCreateRequestPacket;
import org.texboobcat.questory.network.QuestDeleteRequestPacket;
import org.texboobcat.questory.network.QuestUpdateRequestPacket;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.validation.QuestValidator;

public class QuestEditorScreen
extends class_437
implements ManagedEditor<Quest> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\"([^\"]*)\"|(\\S+)");
    private final class_437 parent;
    private Quest workingQuest;
    private String originalId;
    private final EditorStateManager<Quest> stateManager;
    private final UnsavedChangesCache<Quest> unsavedCache;
    private final AutoSaveManager autoSaveManager;
    private Tab activeTab = Tab.GENERAL;
    private class_342 searchBox;
    private List<Quest> filtered = new ArrayList<Quest>();
    private int listScroll = 0;
    private String lastSearchQueryCache = null;
    private List<Term> cachedTerms = Collections.emptyList();
    private GeneralTabPanel generalTab;
    private DependenciesTabPanel dependenciesTab;
    private RequirementsTabPanel requirementsTab;
    private RewardsTabPanel rewardsTab;
    private TeamTabPanel teamTab;
    private AdvancedTabPanel advancedTab;
    private PreviewTabPanel previewTab;
    private class_4185 tabGeneralBtn;
    private class_4185 tabDepsBtn;
    private class_4185 tabReqsBtn;
    private class_4185 tabRwdsBtn;
    private class_4185 tabTeamBtn;
    private class_4185 tabAdvBtn;
    private class_4185 tabPreviewBtn;
    private class_4185 newBtn;
    private class_4185 saveBtn;
    private class_4185 deleteBtn;
    private class_4185 closeBtn;
    private class_4185 settingsBtn;
    private class_4185 saveAllBtn;
    private boolean deleteConfirmPending = false;
    private long deleteConfirmTime = 0L;

    public QuestEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Quest Editor"));
        this.parent = parent;
        this.stateManager = new EditorStateManager<Quest>(this::cloneQuest, Quest::getId);
        this.unsavedCache = new UnsavedChangesCache(50);
        this.autoSaveManager = AutoSaveManager.getInstance();
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public Quest getWorkingQuest() {
        return this.workingQuest;
    }

    @Override
    public EditorStateManager<Quest> getStateManager() {
        return this.stateManager;
    }

    @Override
    public void saveEntity(Quest quest) {
        block9: {
            if (quest == null) {
                return;
            }
            HashMap<String, Quest> allQuests = new HashMap<String, Quest>();
            for (Quest q : ClientQuestManager.getInstance().getAllQuests()) {
                allQuests.put(q.getId(), q);
            }
            allQuests.put(quest.getId(), quest);
            QuestValidator.ValidationResult validation = QuestValidator.validate(quest, allQuests);
            if (!validation.isValid()) {
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7cValidation errors: " + String.join((CharSequence)", ", validation.getErrors()))));
                }
                return;
            }
            try {
                JsonObject json = quest.toJson();
                String payload = GSON.toJson((JsonElement)json);
                if (this.originalId == null || this.originalId.isEmpty()) {
                    NetworkManager.sendToServer(new QuestCreateRequestPacket(payload));
                } else {
                    NetworkManager.sendToServer(new QuestUpdateRequestPacket(this.originalId, payload));
                }
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7aQuest saved successfully"));
                }
                this.originalId = quest.getId();
                this.stateManager.markClean();
                this.unsavedCache.remove(quest.getId());
            }
            catch (Exception e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block9;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7cSave failed: " + e.getMessage())));
            }
        }
    }

    @Override
    public void autoSaveEntity(Quest quest) {
        if (quest == null || !this.stateManager.hasUnsavedChanges()) {
            return;
        }
        this.unsavedCache.put(quest.getId(), quest, this.getEntityDisplayName(quest));
    }

    @Override
    public String getEntityDisplayName(Quest quest) {
        if (quest == null) {
            return "Unknown Quest";
        }
        String title = quest.getTitle();
        return title == null || title.isEmpty() ? quest.getId() : title;
    }

    @Override
    public void onAutoSaveSuccess() {
    }

    @Override
    public void onAutoSaveFailure(Exception e) {
        System.err.println("[QuestEditor] Auto-save failed: " + e.getMessage());
    }

    private Quest cloneQuest(Quest quest) {
        if (quest == null) {
            return null;
        }
        try {
            JsonObject json = quest.toJson();
            String jsonStr = GSON.toJson((JsonElement)json);
            JsonObject clonedJson = (JsonObject)GSON.fromJson(jsonStr, JsonObject.class);
            return Quest.fromJson(clonedJson);
        }
        catch (Exception e) {
            System.err.println("[QuestEditor] Failed to clone quest: " + e.getMessage());
            return quest;
        }
    }

    protected void method_25426() {
        super.method_25426();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "quest_editor");
        this.autoSaveManager.register(this.getEditorId(), () -> {
            if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
                this.autoSaveEntity(this.stateManager.getWorkingCopy());
            }
        });
        this.searchBox = new class_342(this.field_22793, 8, 8, 224, 18, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search quests (id,title,group,chapter,tags). Use tag: or #tag"));
        this.searchBox.method_1863(s -> {
            this.listScroll = 0;
            this.lastSearchQueryCache = null;
        });
        this.method_37063((class_364)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 90;
        this.tabGeneralBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"General"), b -> this.switchTab(Tab.GENERAL)).method_46434(tabX, tabY, tabW, 22).method_46431());
        this.tabDepsBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Dependencies"), b -> this.switchTab(Tab.DEPENDENCIES)).method_46434(tabX += tabW + 2, tabY, tabW + 20, 22).method_46431());
        this.tabReqsBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Requirements"), b -> this.switchTab(Tab.REQUIREMENTS)).method_46434(tabX += tabW + 22, tabY, tabW + 20, 22).method_46431());
        this.tabRwdsBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Rewards"), b -> this.switchTab(Tab.REWARDS)).method_46434(tabX += tabW + 22, tabY, tabW, 22).method_46431());
        this.tabTeamBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Team"), b -> this.switchTab(Tab.TEAM)).method_46434(tabX += tabW + 2, tabY, 60, 22).method_46431());
        this.tabAdvBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Advanced"), b -> this.switchTab(Tab.ADVANCED)).method_46434(tabX += 62, tabY, tabW, 22).method_46431());
        this.tabPreviewBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).method_46434(tabX += tabW + 2, tabY, tabW - 10, 22).method_46431());
        int footerY = this.field_22790 - 36 + 8;
        int btnX = 248;
        this.newBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"New"), b -> this.createNew()).method_46434(btnX, footerY, 60, 20).method_46431());
        this.saveBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.save()).method_46434(btnX += 64, footerY, 60, 20).method_46431());
        this.saveAllBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save All"), b -> this.saveAll()).method_46434(btnX += 64, footerY, 70, 20).method_46431());
        this.deleteBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> this.onDeleteClick()).method_46434(btnX += 74, footerY, 60, 20).method_46431());
        this.settingsBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), b -> this.openSettings()).method_46434(btnX += 64, footerY, 20, 20).method_46431());
        int closeX = this.field_22789 - 8 - 60;
        this.closeBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(closeX, footerY, 60, 20).method_46431());
        this.method_25395(null);
        this.updateSaveAllButton();
        System.out.println("[QuestEditor] About to initialize tab panels. Current workingQuest rewards: " + String.valueOf(this.workingQuest != null ? Integer.valueOf(this.workingQuest.getRewards().size()) : "null"));
        this.initTabPanels();
        this.reloadQuestList();
        if (this.workingQuest != null && this.stateManager.isLoaded()) {
            this.loadTabFromQuest();
        } else if (this.workingQuest != null) {
            this.stateManager.load(this.workingQuest);
            this.originalId = this.workingQuest.getId();
            this.loadTabFromQuest();
        } else if (!this.filtered.isEmpty()) {
            this.selectQuest(this.filtered.get(0));
        } else {
            this.createNew();
        }
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.field_22789 - contentX - 8;
        int contentH = this.field_22790 - contentY - 36 - 8;
        System.out.println("[QuestEditor] initTabPanels() - Creating NEW tab panel instances!");
        this.generalTab = new GeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.dependenciesTab = new DependenciesTabPanel(this, contentX, contentY, contentW, contentH);
        this.requirementsTab = new RequirementsTabPanel(this, contentX, contentY, contentW, contentH);
        this.rewardsTab = new RewardsTabPanel(this, contentX, contentY, contentW, contentH);
        this.teamTab = new TeamTabPanel(this, contentX, contentY, contentW, contentH);
        this.advancedTab = new AdvancedTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new PreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        System.out.println("[QuestEditor] switchTab() from " + String.valueOf((Object)this.activeTab) + " to " + String.valueOf((Object)tab));
        this.saveCurrentTabToQuest();
        this.activeTab = tab;
        this.loadTabFromQuest();
    }

    public void saveCurrentTabToQuest() {
        if (this.workingQuest == null || !this.stateManager.isLoaded()) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.saveToQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.saveToQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.saveToQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.saveToQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.teamTab.saveToQuest(this.workingQuest);
                break;
            }
            case 5: {
                this.advancedTab.saveToQuest(this.workingQuest);
            }
        }
        this.stateManager.markDirty();
        this.stateManager.setWorkingCopy(this.workingQuest);
    }

    private void copyQuestData(Quest from, Quest to) {
        to.setTitle(from.getTitle());
        to.setDescription(from.getDescription());
        to.setIcon(from.getIcon());
        to.setHidden(from.isHidden());
        to.setGroup(from.getGroup());
        to.setChapterId(from.getChapterId());
        to.setX(from.getX());
        to.setY(from.getY());
        to.setHideDependencyLines(from.isHideDependencyLines());
        to.setHideDependentLines(from.isHideDependentLines());
        to.setIconScale(from.getIconScale());
        to.setLineStyle(from.getLineStyle());
        to.getDependencies().clear();
        to.getDependencies().addAll(from.getDependencies());
        to.getRequirements().clear();
        to.getRequirements().addAll(from.getRequirements());
        to.getRewards().clear();
        to.getRewards().addAll(from.getRewards());
        to.getTags().clear();
        to.getTags().addAll(from.getTags());
        to.setShape(from.getShape());
        to.setSize(from.getSize());
        to.setOptional(from.isOptional());
        to.setMinWidth(from.getMinWidth());
        to.setCanRepeat(from.getCanRepeat());
        to.setDependencyRequirement(from.getDependencyRequirement());
        to.setMinRequiredDependencies(from.getMinRequiredDependencies());
        to.setMaxCompletableDeps(from.getMaxCompletableDeps());
        to.setProgressionMode(from.getProgressionMode());
        to.setRequireSequentialTasks(from.getRequireSequentialTasks());
        to.setInvisibleUntilCompleted(from.isInvisibleUntilCompleted());
        to.setInvisibleUntilTasks(from.getInvisibleUntilTasks());
        to.setHideTextUntilComplete(from.getHideTextUntilComplete());
        to.setHideDetailsUntilStartable(from.getHideDetailsUntilStartable());
        to.setHideUntilDepsVisible(from.getHideUntilDepsVisible());
        to.setHideUntilDepsComplete(from.getHideUntilDepsComplete());
        to.setDisableJEI(from.getDisableJEI());
        to.setHideLockIcon(from.isHideLockIcon());
        to.setGuidePage(from.getGuidePage());
        to.setIgnoreRewardBlocking(from.isIgnoreRewardBlocking());
    }

    private void loadTabFromQuest() {
        if (this.workingQuest == null) {
            System.out.println("[QuestEditor] loadTabFromQuest() - workingQuest is NULL!");
            return;
        }
        System.out.println("[QuestEditor] loadTabFromQuest() called for tab: " + String.valueOf((Object)this.activeTab) + ", Quest: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle() + ", Rewards: " + this.workingQuest.getRewards().size());
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.teamTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 5: {
                this.advancedTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 6: {
                this.previewTab.loadFromQuest(this.workingQuest);
            }
        }
    }

    private void reloadQuestList() {
        String raw = this.searchBox.method_1882();
        String query = raw == null ? "" : raw.trim().toLowerCase();
        ArrayList<Quest> all = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        if (query.isEmpty()) {
            this.filtered = all;
            return;
        }
        HashMap<String, String> chapterIdToTitle = new HashMap<String, String>();
        for (ChapterData cd : ClientQuestManager.getInstance().getAllChapters()) {
            if (cd == null || cd.getId() == null) continue;
            chapterIdToTitle.put(cd.getId().toLowerCase(), cd.getTitle() == null ? "" : cd.getTitle());
        }
        if (!query.equals(this.lastSearchQueryCache)) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher m = TOKEN_PATTERN.matcher(query);
            while (m.find()) {
                String t = m.group(1) != null ? m.group(1) : m.group(2);
                if (t == null || t.isBlank()) continue;
                tokens.add(t.trim());
            }
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String t : tokens) {
                if (t.startsWith("#")) {
                    String v = t.substring(1);
                    if (v.isBlank()) continue;
                    terms.add(new Term("tag", v));
                    continue;
                }
                int idx = t.indexOf(58);
                if (idx > 0) {
                    String key = t.substring(0, idx);
                    String val = t.substring(idx + 1);
                    if (key.equals("g")) {
                        key = "group";
                    } else if (key.equals("t")) {
                        key = "tag";
                    } else if (key.equals("c") || key.equals("chap") || key.equals("chapterid")) {
                        key = "chapter";
                    } else if (key.equals("name")) {
                        key = "title";
                    }
                    terms.add(new Term(key, val));
                    continue;
                }
                terms.add(new Term("any", t));
            }
            this.cachedTerms = terms;
            this.lastSearchQueryCache = query;
        }
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        this.filtered = all.stream().filter(q -> {
            String ct;
            String id = q.getId() == null ? "" : q.getId().toLowerCase();
            String title = q.getTitle() == null ? "" : q.getTitle().toLowerCase();
            String group = q.getGroup() == null ? "" : q.getGroup().toLowerCase();
            String cid = q.getChapterId();
            String chapterTitle = "";
            if (cid != null && (ct = (String)chapterIdToTitle.get(cid.toLowerCase())) != null) {
                chapterTitle = ct.toLowerCase();
            }
            List<String> tagsLower = q.getTags() == null ? Collections.emptyList() : q.getTags().stream().map(s -> s.toLowerCase()).collect(Collectors.toList());
            boolean isCompleted = progress != null && progress.isQuestCompleted(q.getId());
            boolean isVisible = progress == null || q.isVisible(progress);
            boolean isOptional = q.isOptional();
            block43: for (Term term : this.cachedTerms) {
                String key = term.key;
                String v = term.value;
                switch (key) {
                    case "id": {
                        if (id.contains(v)) continue block43;
                        return false;
                    }
                    case "title": {
                        if (title.contains(v)) continue block43;
                        return false;
                    }
                    case "group": {
                        if (group.contains(v)) continue block43;
                        return false;
                    }
                    case "chapter": {
                        boolean ok = !chapterTitle.isEmpty() && chapterTitle.contains(v) || cid != null && cid.toLowerCase().contains(v);
                        if (ok) continue block43;
                        return false;
                    }
                    case "tag": {
                        boolean ok = false;
                        for (String t2 : tagsLower) {
                            if (!t2.contains(v)) continue;
                            ok = true;
                            break;
                        }
                        if (ok) continue block43;
                        return false;
                    }
                    case "is": {
                        switch (v) {
                            case "completed": 
                            case "complete": 
                            case "done": {
                                if (isCompleted) break;
                                return false;
                            }
                            case "incomplete": 
                            case "uncompleted": 
                            case "pending": 
                            case "todo": {
                                if (!isCompleted) break;
                                return false;
                            }
                            case "visible": 
                            case "shown": {
                                if (isVisible) break;
                                return false;
                            }
                            case "hidden": 
                            case "invisible": {
                                if (!isVisible) break;
                                return false;
                            }
                            case "optional": 
                            case "opt": {
                                if (isOptional) break;
                                return false;
                            }
                            case "required": 
                            case "mandatory": {
                                if (!isOptional) break;
                                return false;
                            }
                        }
                        break;
                    }
                    case "any": {
                        boolean ok;
                        boolean bl = ok = id.contains(v) || title.contains(v) || group.contains(v) || !chapterTitle.isEmpty() && chapterTitle.contains(v);
                        if (!ok) {
                            for (String t2 : tagsLower) {
                                if (!t2.contains(v)) continue;
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue block43;
                        return false;
                    }
                    default: {
                        boolean ok;
                        boolean bl = ok = id.contains(v) || title.contains(v) || group.contains(v) || !chapterTitle.isEmpty() && chapterTitle.contains(v);
                        if (!ok) {
                            for (String t2 : tagsLower) {
                                if (!t2.contains(v)) continue;
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue block43;
                        return false;
                    }
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    private void selectQuest(Quest quest) {
        Optional<UnsavedChangesCache.CacheEntry<Quest>> cachedEntry;
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.method_25355((class_2561)class_2561.method_43470((String)"Delete"));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToQuest();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        if ((cachedEntry = this.unsavedCache.get(quest.getId())).isPresent()) {
            this.workingQuest = cachedEntry.get().getEntity();
            this.stateManager.load(this.workingQuest);
            this.stateManager.markDirty();
        } else {
            this.workingQuest = this.cloneQuest(quest);
            this.stateManager.load(this.workingQuest);
        }
        this.originalId = quest.getId();
        this.loadTabFromQuest();
        this.updateSaveAllButton();
    }

    private void createNew() {
        Quest newQuest;
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.method_25355((class_2561)class_2561.method_43470((String)"Delete"));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToQuest();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        this.workingQuest = newQuest = new Quest("new_quest_" + System.currentTimeMillis(), "New Quest", "");
        this.stateManager.load(newQuest);
        this.stateManager.markDirty();
        this.originalId = null;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromQuest();
        this.updateSaveAllButton();
    }

    private void updateSaveAllButton() {
        if (this.saveAllBtn != null) {
            int unsavedCount = this.unsavedCache.size();
            if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
                ++unsavedCount;
            }
            boolean bl = this.saveAllBtn.field_22763 = unsavedCount > 0;
            if (unsavedCount > 0) {
                this.saveAllBtn.method_25355((class_2561)class_2561.method_43470((String)("Save All (" + unsavedCount + ")")));
            } else {
                this.saveAllBtn.method_25355((class_2561)class_2561.method_43470((String)"Save All"));
            }
        }
    }

    private void saveAll() {
        if (this.unsavedCache.isEmpty() && !this.stateManager.hasUnsavedChanges()) {
            return;
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToQuest();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        int successCount = 0;
        int failCount = 0;
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<Quest>> entry : this.unsavedCache.getAllEntries()) {
            String questId = entry.getKey();
            Quest quest = entry.getValue().getEntity();
            try {
                this.saveEntity(quest);
                this.unsavedCache.remove(questId);
                ++successCount;
            }
            catch (Exception e) {
                ++failCount;
                System.err.println("[QuestEditor] Failed to save quest " + questId + ": " + e.getMessage());
            }
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (failCount == 0) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7aSuccessfully saved " + successCount + " quest(s)")));
            } else {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eSaved " + successCount + " quest(s), " + failCount + " failed")));
            }
        }
        this.updateSaveAllButton();
    }

    private void save() {
        if (this.workingQuest == null || !this.stateManager.isLoaded()) {
            return;
        }
        this.saveCurrentTabToQuest();
        this.saveEntity(this.stateManager.getWorkingCopy());
        this.updateSaveAllButton();
    }

    public void method_25419() {
        if (this.stateManager.hasUnsavedChanges() || !this.unsavedCache.isEmpty()) {
            this.showCloseConfirmationDialog();
        } else {
            this.autoSaveManager.unregister(this.getEditorId());
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }
    }

    private void showCloseConfirmationDialog() {
        ArrayList<CloseConfirmationDialog.UnsavedEntity> unsavedEntities = new ArrayList<CloseConfirmationDialog.UnsavedEntity>();
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<Quest>> entry : this.unsavedCache.getAllEntries()) {
            unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(entry.getValue().getDisplayName(), "Quest", entry.getValue().getTimestamp()));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
            unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(this.getEntityDisplayName(this.stateManager.getWorkingCopy()), "Quest", this.stateManager.getLastModifiedTime()));
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new CloseConfirmationDialog(this, this.parent, unsavedEntities, this::saveAll, () -> {
                this.unsavedCache.clear();
                this.stateManager.clear();
            }, () -> {}));
        }
    }

    private void onDeleteClick() {
        if (this.originalId == null || this.originalId.isEmpty()) {
            return;
        }
        if (!this.deleteConfirmPending) {
            this.deleteConfirmPending = true;
            this.deleteConfirmTime = System.currentTimeMillis();
            this.deleteBtn.method_25355((class_2561)class_2561.method_43470((String)"\u00a7cConfirm?"));
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7eClick Delete again to confirm"));
            }
        } else {
            this.delete();
        }
    }

    private void delete() {
        NetworkManager.sendToServer(new QuestDeleteRequestPacket(this.originalId));
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7aQuest deletion requested"));
        }
        this.deleteConfirmPending = false;
        this.deleteBtn.method_25355((class_2561)class_2561.method_43470((String)"Delete"));
        this.createNew();
    }

    private void openSettings() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new EditorSettingsScreen(this));
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        if (this.deleteConfirmPending && System.currentTimeMillis() - this.deleteConfirmTime > 3000L) {
            this.deleteConfirmPending = false;
            this.deleteBtn.method_25355((class_2561)class_2561.method_43470((String)"Delete"));
        }
        g.method_25294(0, 0, 240, this.field_22790, -804253680);
        int unsavedCount = this.unsavedCache.size();
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
            ++unsavedCount;
        }
        if (unsavedCount > 0) {
            String unsavedText = "(" + unsavedCount + " unsaved)";
            int textX = 10;
            int textY = 36;
            g.method_25303(this.field_22793, unsavedText, textX, textY, -22016);
        }
        if (this.autoSaveManager.isEnabled()) {
            String status = this.autoSaveManager.getStatusString();
            int statusW = this.field_22793.method_1727(status);
            int statusX = 232 - statusW;
            int statusY = 50;
            g.method_25303(this.field_22793, status, statusX, statusY, -7829368);
        }
        int listTop = 32;
        int listBottom = this.field_22790 - 8;
        g.method_25294(8, listTop, 232, listBottom, -534765536);
        this.renderQuestList(g, mouseX, mouseY);
        this.updateSaveAllButton();
        int contentX = 248;
        int contentY = 40;
        int contentW = this.field_22789 - contentX - 8;
        int contentH = this.field_22790 - contentY - 36 - 8;
        g.method_25294(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.method_25394(g, mouseX, mouseY, partialTick);
        g.method_27535(this.field_22793, this.field_22785, 248, -4, -1);
        int sbX = 8;
        int sbY = 8;
        int sbW = 224;
        int sbH = 18;
        if (mouseX >= sbX && mouseX <= sbX + sbW && mouseY >= sbY && mouseY <= sbY + sbH) {
            String[] lines = new String[]{"Search tips:", "id:, title:, group:, chapter:", "tag:<t> or #<t>", "is:completed|incomplete|visible|hidden|optional|required", "use \"phrases\""};
            int tw = 0;
            for (String s : lines) {
                tw = Math.max(tw, this.field_22793.method_1727(s));
            }
            int th = 6 + lines.length * 10 + 4;
            int tx = sbX + sbW + 8;
            int ty = sbY;
            if (tx + tw + 10 > this.field_22789) {
                tx = Math.max(8, this.field_22789 - tw - 12);
            }
            if (ty + th > this.field_22790) {
                ty = Math.max(8, this.field_22790 - th - 4);
            }
            g.method_51448().method_22903();
            g.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            g.method_25294(tx - 2, ty - 2, tx + tw + 8, ty + th, -268435456);
            g.method_25294(tx - 2, ty - 2, tx + tw + 8, ty - 1, -11890462);
            int yy = ty + 2;
            for (String s : lines) {
                g.method_25303(this.field_22793, s, tx + 2, yy, -1);
                yy += 10;
            }
            g.method_51448().method_22909();
        }
    }

    private void renderQuestList(class_332 g, int mouseX, int mouseY) {
        this.reloadQuestList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.field_22790 - 8;
        int lineH = 16;
        g.method_44379(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hasUnsavedChanges;
            Quest q = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingQuest != null && this.workingQuest.getId().equals(q.getId());
            boolean hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            boolean bl = hasUnsavedChanges = this.unsavedCache.contains(q.getId()) || selected && this.stateManager.hasUnsavedChanges();
            if (selected) {
                g.method_25294(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.method_25294(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            String title = q.getTitle();
            class_2561 formattedTitle = TextFormatter.parse(title);
            Object label = hasUnsavedChanges ? class_2561.method_43470((String)"* ").method_27694(style -> style.method_36139(-22016)).method_10852(formattedTitle) : formattedTitle;
            int maxWidth = listW - 4;
            if (this.field_22793.method_27525((class_5348)label) > maxWidth) {
                String plainText = label.getString();
                String truncated = this.field_22793.method_27523(plainText, listW - 16) + "...";
                label = class_2561.method_43470((String)truncated);
                if (hasUnsavedChanges) {
                    label = label.method_27661().method_27694(style -> style.method_36139(-22016));
                }
            }
            g.method_27535(this.field_22793, label, listX + 2, y, -1);
        }
        g.method_44380();
    }

    private void renderActiveTab(class_332 g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.dependenciesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.requirementsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.rewardsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.teamTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 5: {
                this.advancedTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 6: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int relY;
        int index;
        boolean tabHandled;
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = this.teamTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 5: {
                boolean bl = this.advancedTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 6: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            this.searchBox.method_25365(false);
            return true;
        }
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.field_22790 - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectQuest(this.filtered.get(index));
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.field_22790 - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = this.teamTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 5: {
                boolean bl = this.advancedTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 6: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean tabHandled;
        if (keyCode == 257) {
            boolean anyFieldFocused = false;
            if (this.searchBox != null && this.searchBox.method_25370()) {
                anyFieldFocused = true;
            }
            if (!anyFieldFocused) {
                switch (this.activeTab.ordinal()) {
                    case 0: {
                        boolean bl = this.generalTab.getFields().stream().anyMatch(f -> f.method_25370());
                        break;
                    }
                    case 1: {
                        boolean bl = this.dependenciesTab.getFields().stream().anyMatch(f -> f.method_25370());
                        break;
                    }
                    case 2: {
                        boolean bl = this.requirementsTab.getFields().stream().anyMatch(f -> f.method_25370());
                        break;
                    }
                    case 3: {
                        boolean bl = this.rewardsTab.getFields().stream().anyMatch(f -> f.method_25370());
                        break;
                    }
                    case 4: {
                        boolean bl = this.teamTab.getFields().stream().anyMatch(f -> f.method_25370());
                        break;
                    }
                    case 5: {
                        boolean bl = this.advancedTab.getFields().stream().anyMatch(f -> f.method_25370());
                        break;
                    }
                    default: {
                        boolean bl = anyFieldFocused = false;
                    }
                }
            }
            if (anyFieldFocused) {
                return true;
            }
        }
        block8 : switch (this.activeTab.ordinal()) {
            case 0: {
                boolean bl;
                for (class_342 field : this.generalTab.getFields()) {
                    if (!field.method_25404(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (class_342 field : this.dependenciesTab.getFields()) {
                    if (!field.method_25404(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (class_342 field : this.requirementsTab.getFields()) {
                    if (!field.method_25404(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (class_342 field : this.rewardsTab.getFields()) {
                    if (!field.method_25404(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                for (class_342 field : this.advancedTab.getFields()) {
                    if (!field.method_25404(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        boolean tabHandled;
        block0 : switch (this.activeTab.ordinal()) {
            case 0: {
                boolean bl;
                for (class_342 field : this.generalTab.getFields()) {
                    if (!field.method_25400(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (class_342 field : this.dependenciesTab.getFields()) {
                    if (!field.method_25400(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (class_342 field : this.requirementsTab.getFields()) {
                    if (!field.method_25400(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (class_342 field : this.rewardsTab.getFields()) {
                    if (!field.method_25400(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                for (class_342 field : this.advancedTab.getFields()) {
                    if (!field.method_25400(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEPENDENCIES,
        REQUIREMENTS,
        REWARDS,
        TEAM,
        ADVANCED,
        PREVIEW;

    }

    private static class Term {
        final String key;
        final String value;

        Term(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

