/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChangeTracker {
    private final Map<String, Object> originalValues = new HashMap<String, Object>();
    private final Map<String, Object> currentValues = new HashMap<String, Object>();
    private final Set<String> modifiedFields = new HashSet<String>();

    public void track(String field, Object value) {
        if (field == null) {
            return;
        }
        this.originalValues.put(field, this.cloneValue(value));
        this.currentValues.put(field, this.cloneValue(value));
    }

    public void updateCurrent(String field, Object newValue) {
        if (field == null) {
            return;
        }
        Object clonedValue = this.cloneValue(newValue);
        this.currentValues.put(field, clonedValue);
        Object original = this.originalValues.get(field);
        if (!this.valuesEqual(original, clonedValue)) {
            this.modifiedFields.add(field);
        } else {
            this.modifiedFields.remove(field);
        }
    }

    public boolean isFieldModified(String field) {
        return this.modifiedFields.contains(field);
    }

    public Set<String> getModifiedFields() {
        return Collections.unmodifiableSet(this.modifiedFields);
    }

    public Map<String, Object> getChangedValues() {
        HashMap<String, Object> changed = new HashMap<String, Object>();
        for (String field : this.modifiedFields) {
            changed.put(field, this.currentValues.get(field));
        }
        return changed;
    }

    public Object getOriginalValue(String field) {
        return this.originalValues.get(field);
    }

    public Object getCurrentValue(String field) {
        return this.currentValues.get(field);
    }

    public void reset() {
        this.originalValues.clear();
        this.currentValues.clear();
        this.modifiedFields.clear();
    }

    public void commitChanges() {
        this.originalValues.clear();
        for (Map.Entry<String, Object> entry : this.currentValues.entrySet()) {
            this.originalValues.put(entry.getKey(), this.cloneValue(entry.getValue()));
        }
        this.modifiedFields.clear();
    }

    public void revertChanges() {
        this.currentValues.clear();
        for (Map.Entry<String, Object> entry : this.originalValues.entrySet()) {
            this.currentValues.put(entry.getKey(), this.cloneValue(entry.getValue()));
        }
        this.modifiedFields.clear();
    }

    public boolean hasChanges() {
        return !this.modifiedFields.isEmpty();
    }

    public int getChangeCount() {
        return this.modifiedFields.size();
    }

    private Object cloneValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return value;
        }
        if (value instanceof List) {
            return new ArrayList((List)value);
        }
        if (value instanceof Set) {
            return new HashSet((Set)value);
        }
        if (value instanceof Map) {
            return new HashMap((Map)value);
        }
        return value;
    }

    private boolean valuesEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof List && b instanceof List) {
            List la = (List)a;
            List lb = (List)b;
            return la.equals(lb);
        }
        if (a instanceof Set && b instanceof Set) {
            Set sa = (Set)a;
            Set sb = (Set)b;
            return sa.equals(sb);
        }
        if (a instanceof Map && b instanceof Map) {
            Map ma = (Map)a;
            Map mb = (Map)b;
            return ma.equals(mb);
        }
        return false;
    }
}

