/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.editor.UnsavedChangesCache;

public class UnsavedChangesRecoveryScreen
extends class_437 {
    private final class_437 parent;
    private final UnsavedChangesCache<?> cache;
    private final String editorType;
    private final RecoveryCallback callback;
    private List<CacheEntryDisplay> entries;
    private int selectedIndex = -1;
    private int scroll = 0;
    private class_4185 recoverBtn;
    private class_4185 discardBtn;
    private class_4185 closeBtn;
    private static final int ENTRY_HEIGHT = 50;
    private static final int PADDING = 10;

    public UnsavedChangesRecoveryScreen(class_437 parent, UnsavedChangesCache<?> cache, String editorType, RecoveryCallback callback) {
        super((class_2561)class_2561.method_43470((String)("Recover Unsaved Changes - " + editorType)));
        this.parent = parent;
        this.cache = cache;
        this.editorType = editorType;
        this.callback = callback;
        this.loadEntries();
    }

    private void loadEntries() {
        this.entries = new ArrayList<CacheEntryDisplay>();
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<?>> entry : this.cache.getAllEntries()) {
            this.entries.add(new CacheEntryDisplay(entry.getKey(), entry.getValue().getDisplayName(), entry.getValue().getTimestamp(), entry.getValue().getChangedFields().keySet()));
        }
        this.entries.sort((a, b) -> Long.compare(b.timestamp, a.timestamp));
    }

    protected void method_25426() {
        super.method_25426();
        int btnY = this.field_22790 - 35;
        int btnWidth = 90;
        int btnSpacing = 10;
        int centerX = this.field_22789 / 2;
        this.recoverBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7aRecover"), b -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
                CacheEntryDisplay entry = this.entries.get(this.selectedIndex);
                if (this.callback != null) {
                    this.callback.onRecover(entry.entityId);
                }
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7aRecovered: " + entry.displayName)));
                }
                this.loadEntries();
                this.selectedIndex = -1;
                this.updateButtons();
            }
        }).method_46434(centerX - btnWidth - btnSpacing - btnWidth / 2, btnY, btnWidth, 20).method_46431());
        this.discardBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7cDiscard"), b -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
                CacheEntryDisplay entry = this.entries.get(this.selectedIndex);
                if (this.callback != null) {
                    this.callback.onDiscard(entry.entityId);
                }
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7cDiscarded: " + entry.displayName)));
                }
                this.cache.remove(entry.entityId);
                this.loadEntries();
                this.selectedIndex = -1;
                this.updateButtons();
            }
        }).method_46434(centerX - btnWidth / 2, btnY, btnWidth, 20).method_46431());
        this.closeBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(centerX + btnWidth / 2 + btnSpacing, btnY, btnWidth, 20).method_46431());
        this.updateButtons();
    }

    private void updateButtons() {
        boolean hasSelection;
        boolean bl = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.entries.size();
        if (this.recoverBtn != null) {
            this.recoverBtn.field_22763 = hasSelection;
        }
        if (this.discardBtn != null) {
            this.discardBtn.field_22763 = hasSelection;
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        String info = this.entries.isEmpty() ? "\u00a77No unsaved changes to recover" : String.format("\u00a77%d %s(s) with unsaved changes", this.entries.size(), this.editorType);
        g.method_25300(this.field_22793, info, this.field_22789 / 2, 30, -1);
        if (!this.entries.isEmpty()) {
            g.method_25300(this.field_22793, "\u00a77Click an entry to select it, then use Recover or Discard", this.field_22789 / 2, 42, -5592406);
        }
        int listTop = 60;
        int listBottom = this.field_22790 - 50;
        int listHeight = listBottom - listTop;
        int listWidth = Math.min(750, this.field_22789 - 40);
        int listX = this.field_22789 / 2 - listWidth / 2;
        g.method_25294(listX, listTop, listX + listWidth, listBottom, -587202560);
        g.method_44379(listX, listTop, listX + listWidth, listBottom);
        int maxVisibleEntries = listHeight / 50;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.entries.size() - maxVisibleEntries)));
        if (this.entries.isEmpty()) {
            g.method_25300(this.field_22793, "\u00a77All changes are saved!", this.field_22789 / 2, listTop + listHeight / 2, -1);
        } else {
            int y = listTop + 10;
            for (int i = this.scroll; i < Math.min(this.scroll + maxVisibleEntries + 1, this.entries.size()); ++i) {
                CacheEntryDisplay entry = this.entries.get(i);
                boolean selected = i == this.selectedIndex;
                boolean hover = mouseX >= listX + 10 && mouseX <= listX + listWidth - 10 && mouseY >= y && mouseY <= y + 50 - 5;
                this.renderEntry(g, entry, listX + 10, y, listWidth - 20, selected, hover);
                y += 50;
            }
        }
        g.method_44380();
        if (this.entries.size() > maxVisibleEntries) {
            String scrollInfo = String.format("\u00a77(%d-%d of %d)", this.scroll + 1, Math.min(this.scroll + maxVisibleEntries, this.entries.size()), this.entries.size());
            g.method_25303(this.field_22793, scrollInfo, listX + listWidth - this.field_22793.method_1727(scrollInfo) - 5, listTop - 15, -5592406);
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private void renderEntry(class_332 g, CacheEntryDisplay entry, int x, int y, int width, boolean selected, boolean hover) {
        Object name;
        int bgColor = selected ? 1716162786 : (hover ? 0x33FFFFFF : 0x22FFFFFF);
        g.method_25294(x, y, x + width, y + 50 - 5, bgColor);
        if (selected) {
            g.method_25294(x, y, x + 2, y + 50 - 5, -11890462);
        }
        if (this.field_22793.method_1727((String)(name = entry.displayName)) > width - 100) {
            name = this.field_22793.method_27523((String)name, width - 120) + "...";
        }
        g.method_25303(this.field_22793, "\u00a7f" + (String)name, x + 10, y + 5, -1);
        String id = "\u00a77ID: " + entry.entityId;
        if (this.field_22793.method_1727(id) > width - 100) {
            id = this.field_22793.method_27523(id, width - 120) + "...";
        }
        g.method_25303(this.field_22793, id, x + 10, y + 17, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, HH:mm");
        String timestamp = sdf.format(new Date(entry.timestamp));
        String meta = String.format("\u00a7e%d field(s) changed \u00a77| %s (%s)", entry.changedFields.size(), timestamp, entry.getAgeString());
        g.method_25303(this.field_22793, meta, x + 10, y + 30, -1);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int relativeY;
        int clickedIndex;
        int listTop = 60;
        int listBottom = this.field_22790 - 50;
        int listWidth = Math.min(750, this.field_22789 - 40);
        int listX = this.field_22789 / 2 - listWidth / 2;
        if (mouseX >= (double)(listX + 10) && mouseX <= (double)(listX + listWidth - 10) && mouseY >= (double)listTop && mouseY <= (double)listBottom && (clickedIndex = this.scroll + (relativeY = (int)mouseY - listTop - 10) / 50) >= 0 && clickedIndex < this.entries.size()) {
            this.selectedIndex = clickedIndex;
            this.updateButtons();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int listTop = 60;
        int listBottom = this.field_22790 - 50;
        if (mouseY >= (double)listTop && mouseY <= (double)listBottom) {
            int maxVisibleEntries = (listBottom - listTop) / 50;
            int maxScroll = Math.max(0, this.entries.size() - maxVisibleEntries);
            this.scroll = delta > 0.0 ? Math.max(0, this.scroll - 1) : Math.min(maxScroll, this.scroll + 1);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return true;
    }

    public static interface RecoveryCallback {
        public void onRecover(String var1);

        public void onDiscard(String var1);
    }

    private static class CacheEntryDisplay {
        final String entityId;
        final String displayName;
        final long timestamp;
        final Set<String> changedFields;

        CacheEntryDisplay(String entityId, String displayName, long timestamp, Set<String> changedFields) {
            this.entityId = entityId;
            this.displayName = displayName;
            this.timestamp = timestamp;
            this.changedFields = changedFields;
        }

        String getAgeString() {
            long ageMs = System.currentTimeMillis() - this.timestamp;
            long seconds = ageMs / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            if (days > 0L) {
                return days + "d ago";
            }
            if (hours > 0L) {
                return hours + "h ago";
            }
            if (minutes > 0L) {
                return minutes + "m ago";
            }
            return seconds + "s ago";
        }
    }
}

