/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterDataUpdateRequestPacket {
    private static final Gson GSON = new Gson();
    private final String chapterJson;

    public ChapterDataUpdateRequestPacket(String chapterJson) {
        this.chapterJson = chapterJson;
    }

    public static void encode(ChapterDataUpdateRequestPacket pkt, class_2540 buf) {
        buf.method_10814(pkt.chapterJson);
    }

    public static ChapterDataUpdateRequestPacket decode(class_2540 buf) {
        return new ChapterDataUpdateRequestPacket(buf.method_19772());
    }

    public void handle(class_3222 player) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.enableAdvancedEditor) {
            return;
        }
        if (cfg.advancedEditorRequiresOp && !player.method_5687(cfg.adminPermissionLevel)) {
            return;
        }
        try {
            JsonObject json = (JsonObject)GSON.fromJson(this.chapterJson, JsonObject.class);
            ChapterData cd = ChapterData.fromJson(json);
            QuestManager qm = QuestManager.getInstance();
            qm.updateChapterData(cd);
            List allPlayers = player.field_13995.method_3760().method_14571();
            ArrayList<ChapterData> chapters = new ArrayList<ChapterData>(qm.getAllChapters());
            for (class_3222 p : allPlayers) {
                NetworkManager.sendToClient(p, new ChapterDataSyncPacket(chapters));
            }
            player.method_43496((class_2561)class_2561.method_43470((String)("Saved chapter: " + cd.getTitle())));
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Failed to save chapter: " + e.getMessage())));
        }
    }
}

