/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.quest.Quest;

public class QuestCreateRequestPacket {
    private static final Gson GSON = new Gson();
    private final String questJson;

    public QuestCreateRequestPacket(String questJson) {
        this.questJson = questJson;
    }

    public static void encode(QuestCreateRequestPacket pkt, class_2540 buf) {
        buf.method_10814(pkt.questJson);
    }

    public static QuestCreateRequestPacket decode(class_2540 buf) {
        return new QuestCreateRequestPacket(buf.method_19772());
    }

    public void handle(class_3222 player) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.enableAdvancedEditor) {
            return;
        }
        if (cfg.advancedEditorRequiresOp && !player.method_5687(cfg.adminPermissionLevel)) {
            return;
        }
        try {
            JsonObject json = (JsonObject)GSON.fromJson(this.questJson, JsonObject.class);
            Quest quest = Quest.fromJson(json);
            QuestManager qm = QuestManager.getInstance();
            qm.registerQuest(quest);
            List list = player.field_13995.method_3760().method_14571();
            ArrayList<Quest> all = new ArrayList<Quest>(qm.getAllQuests());
            for (class_3222 p : list) {
                NetworkManager.sendToClient(p, new QuestSyncPacket(all));
            }
            player.method_43496((class_2561)class_2561.method_43470((String)("Created quest: " + quest.getId())));
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Failed to create quest: " + e.getMessage())));
        }
    }
}

