/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class RequirementCompletePacket {
    private final String questId;
    private final int requirementIndex;

    public RequirementCompletePacket(String questId, int requirementIndex) {
        this.questId = questId;
        this.requirementIndex = requirementIndex;
    }

    public static void encode(RequirementCompletePacket packet, class_2540 buf) {
        buf.method_10814(packet.questId);
        buf.writeInt(packet.requirementIndex);
    }

    public static RequirementCompletePacket decode(class_2540 buf) {
        String questId = buf.method_19772();
        int requirementIndex = buf.readInt();
        return new RequirementCompletePacket(questId, requirementIndex);
    }

    public void handle(class_3222 player) {
        Quest quest = QuestManager.getInstance().getQuest(this.questId);
        if (quest == null) {
            System.err.println("[Questory] Invalid quest ID for requirement completion: " + this.questId);
            return;
        }
        if (this.requirementIndex < 0 || this.requirementIndex >= quest.getRequirements().size()) {
            System.err.println("[Questory] Invalid requirement index: " + this.requirementIndex + " for quest: " + this.questId);
            return;
        }
        Requirement requirement = quest.getRequirements().get(this.requirementIndex);
        if (!(requirement instanceof CheckmarkRequirement)) {
            System.err.println("[Questory] Attempted to manually complete non-checkmark requirement: " + requirement.getType());
            return;
        }
        QuestProgress progress = QuestManager.getInstance().getProgress(player.method_5667());
        if (progress.getRequirementProgress(this.questId, requirement) > 0) {
            System.out.println("[Questory] Requirement already completed for quest: " + this.questId);
            return;
        }
        progress.setRequirementProgress(this.questId, requirement, 1);
        System.out.println("[Questory] Player " + player.method_5477().getString() + " manually completed requirement " + this.requirementIndex + " for quest: " + this.questId);
        QuestManager questManager = QuestManager.getInstance();
        if (quest.canComplete(progress)) {
            questManager.completeQuest(player, this.questId);
        } else {
            questManager.savePlayerProgress(progress);
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    public String getQuestId() {
        return this.questId;
    }

    public int getRequirementIndex() {
        return this.requirementIndex;
    }
}

