/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;

public class TeamSyncPacket {
    private static final Gson GSON = new Gson();
    private final QuestTeam team;
    private final UUID playerId;
    private final List<TeamInviteInfo> pendingInvites;
    private final int pendingRewardCount;

    public TeamSyncPacket(QuestTeam team, UUID playerId, List<TeamInviteInfo> pendingInvites, int pendingRewardCount) {
        this.team = team;
        this.playerId = playerId;
        this.pendingInvites = pendingInvites != null ? pendingInvites : new ArrayList();
        this.pendingRewardCount = pendingRewardCount;
    }

    public static void encode(TeamSyncPacket packet, class_2540 buf) {
        buf.writeBoolean(packet.team != null);
        if (packet.team != null) {
            JsonObject json = packet.team.toJson();
            String jsonString = GSON.toJson((JsonElement)json);
            buf.method_10814(jsonString);
        }
        buf.method_10797(packet.playerId);
        buf.writeInt(packet.pendingInvites.size());
        for (TeamInviteInfo invite : packet.pendingInvites) {
            JsonObject inviteJson = invite.toJson();
            buf.method_10814(GSON.toJson((JsonElement)inviteJson));
        }
        buf.writeInt(packet.pendingRewardCount);
    }

    public static TeamSyncPacket decode(class_2540 buf) {
        QuestTeam team = null;
        if (buf.readBoolean()) {
            String jsonString = buf.method_19772();
            JsonObject json = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
            team = QuestTeam.fromJson(json);
        }
        UUID playerId = buf.method_10790();
        int inviteCount = buf.readInt();
        ArrayList<TeamInviteInfo> pendingInvites = new ArrayList<TeamInviteInfo>();
        for (int i = 0; i < inviteCount; ++i) {
            String inviteJsonStr = buf.method_19772();
            JsonObject inviteJson = (JsonObject)GSON.fromJson(inviteJsonStr, JsonObject.class);
            pendingInvites.add(TeamInviteInfo.fromJson(inviteJson));
        }
        int pendingRewardCount = buf.readInt();
        return new TeamSyncPacket(team, playerId, pendingInvites, pendingRewardCount);
    }

    public void handle() {
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        clientMgr.setCurrentTeam(this.team);
        clientMgr.setCurrentPlayerId(this.playerId);
        clientMgr.setPendingInvites(this.pendingInvites);
        clientMgr.setPendingRewardCount(this.pendingRewardCount);
        System.out.println("[Questory Client] Team data synced: " + (this.team != null ? this.team.getTeamName() : "no team"));
    }

    public QuestTeam getTeam() {
        return this.team;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public List<TeamInviteInfo> getPendingInvites() {
        return this.pendingInvites;
    }

    public int getPendingRewardCount() {
        return this.pendingRewardCount;
    }
}

