/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.simpleavatars.network;

import net.mcreator.simpleavatars.SimpleAvatarsMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record PlayPlayerAnimationMessage(int player, String animation, boolean override) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayPlayerAnimationMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"simple_avatars", (String)"play_player_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayPlayerAnimationMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.player);
        buffer.writeUtf(message.animation);
        buffer.writeBoolean(message.override);
    }, buffer -> new PlayPlayerAnimationMessage(buffer.readInt(), buffer.readUtf(), buffer.readBoolean()));

    public CustomPacketPayload.Type<PlayPlayerAnimationMessage> type() {
        return TYPE;
    }

    public static void handleData(PlayPlayerAnimationMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                Player player = (Player)context.player().level().getEntity(message.player);
                if (player == null) {
                    return;
                }
                CompoundTag data = player.getPersistentData();
                if (message.animation.isEmpty()) {
                    data.putBoolean("ResetPlayerAnimation", true);
                    data.remove("PlayerCurrentAnimation");
                    data.remove("PlayerAnimationProgress");
                } else {
                    data.putString("PlayerCurrentAnimation", message.animation);
                    data.putBoolean("OverrideCurrentAnimation", message.override);
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SimpleAvatarsMod.addNetworkMessage(TYPE, STREAM_CODEC, PlayPlayerAnimationMessage::handleData);
    }
}

