/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.simpleavatars.mixin;

import java.util.Map;
import net.mcreator.simpleavatars.SimpleAvatarsModPlayerAnimationAPI;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerAnimationMixin {
    private String master = null;

    @Inject(method={"Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="HEAD")})
    public void setupPivot(PlayerRenderState renderState, CallbackInfo ci) {
        Player player;
        if (this.master == null) {
            this.master = "simple_avatars";
        }
        if ((player = (Player)renderState.getRenderData(SimpleAvatarsModPlayerAnimationAPI.ClientAttachments.PLAYER)) == null) {
            return;
        }
        PlayerModel model = (PlayerModel)this;
        SimpleAvatarsModPlayerAnimationAPI.PlayerAnimation animation = SimpleAvatarsModPlayerAnimationAPI.active_animations.get(player);
        if (animation == null) {
            return;
        }
        if (animation.bones.get("left_arm") != null || animation.bones.get("torso") != null || animation.bones.get("right_arm") != null) {
            renderState.attackTime = 0.0f;
        }
        renderState.isCrouching = false;
    }

    @Inject(method={"Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="TAIL")})
    public void setupAnim(PlayerRenderState renderState, CallbackInfo ci) {
        float animationProgress;
        SimpleAvatarsModPlayerAnimationAPI.PlayerAnimation animation;
        Player player = (Player)renderState.getRenderData(SimpleAvatarsModPlayerAnimationAPI.ClientAttachments.PLAYER);
        if (player == null) {
            return;
        }
        if (!this.master.equals("simple_avatars")) {
            if (!SimpleAvatarsModPlayerAnimationAPI.animations.isEmpty()) {
                SimpleAvatarsModPlayerAnimationAPI.animations.clear();
            }
            return;
        }
        PlayerModel model = (PlayerModel)this;
        CompoundTag data = player.getPersistentData();
        String playingAnimation = data.getString("PlayerCurrentAnimation");
        boolean overrideAnimation = data.getBoolean("OverrideCurrentAnimation");
        if (data.getBoolean("ResetPlayerAnimation")) {
            data.remove("ResetPlayerAnimation");
            data.remove("LastTickTime");
            SimpleAvatarsModPlayerAnimationAPI.active_animations.put(player, null);
        }
        if (playingAnimation.isEmpty()) {
            return;
        }
        if (overrideAnimation) {
            SimpleAvatarsModPlayerAnimationAPI.active_animations.put(player, null);
            data.remove("PlayerAnimationProgress");
            data.putBoolean("OverrideCurrentAnimation", false);
        }
        if ((animation = SimpleAvatarsModPlayerAnimationAPI.active_animations.get(player)) == null) {
            animation = SimpleAvatarsModPlayerAnimationAPI.animations.get(playingAnimation);
            SimpleAvatarsModPlayerAnimationAPI.active_animations.put(player, animation);
        }
        if (!data.contains("PlayerAnimationProgress")) {
            animationProgress = 0.0f;
            data.putFloat("PlayerAnimationProgress", animationProgress);
            data.putFloat("LastTickTime", renderState.ageInTicks);
        } else {
            animationProgress = data.getFloat("PlayerAnimationProgress");
            float lastTickTime = data.getFloat("LastTickTime");
            float deltaTime = (renderState.ageInTicks - lastTickTime) / 20.0f;
            data.putFloat("PlayerAnimationProgress", animationProgress += deltaTime);
            data.putFloat("LastTickTime", renderState.ageInTicks);
            if (animationProgress >= animation.length) {
                if (!animation.hold_on_last_frame && !animation.loop) {
                    data.remove("PlayerCurrentAnimation");
                    data.remove("PlayerAnimationProgress");
                    SimpleAvatarsModPlayerAnimationAPI.active_animations.put(player, null);
                    animationProgress = animation.length;
                } else if (animation.hold_on_last_frame) {
                    data.putFloat("PlayerAnimationProgress", animation.length);
                } else if (animation.loop) {
                    data.remove("PlayerAnimationProgress");
                }
            }
        }
        for (Map.Entry<String, SimpleAvatarsModPlayerAnimationAPI.PlayerBone> entry : animation.bones.entrySet()) {
            Vec3 scale;
            Vec3 position;
            String boneName = entry.getKey();
            SimpleAvatarsModPlayerAnimationAPI.PlayerBone bone = entry.getValue();
            ModelPart modelPart = this.getModelPart(model, boneName);
            if (modelPart == null) continue;
            Vec3 rotation = SimpleAvatarsModPlayerAnimationAPI.PlayerBone.interpolate(bone.rotations, animationProgress);
            if (rotation != null) {
                modelPart.xRot = (float)Math.toRadians(rotation.x);
                modelPart.yRot = (float)Math.toRadians(rotation.y);
                modelPart.zRot = (float)Math.toRadians(rotation.z);
            }
            if ((position = SimpleAvatarsModPlayerAnimationAPI.PlayerBone.interpolate(bone.positions, animationProgress)) != null) {
                modelPart.x += (float)position.x;
                modelPart.y -= (float)position.y;
                modelPart.z += (float)position.z;
            }
            if ((scale = SimpleAvatarsModPlayerAnimationAPI.PlayerBone.interpolate(bone.scales, animationProgress)) == null) continue;
            modelPart.xScale = (float)scale.x;
            modelPart.yScale = (float)scale.y;
            modelPart.zScale = (float)scale.z;
        }
    }

    private ModelPart getModelPart(PlayerModel model, String boneName) {
        switch (boneName) {
            case "torso": {
                return model.body;
            }
            case "head": {
                return model.head;
            }
            case "right_arm": {
                return model.rightArm;
            }
            case "left_arm": {
                return model.leftArm;
            }
            case "right_leg": {
                return model.rightLeg;
            }
            case "left_leg": {
                return model.leftLeg;
            }
        }
        return null;
    }
}

