/*
 * Decompiled with CFR 0.152.
 */
package mcauth.common;

import com.mojang.authlib.Agent;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.util.UUIDTypeAdapter;
import java.nio.charset.Charset;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import mcauth.common.AuthMeLoggerKt;
import mcauth.common.Status;
import mcauth.common.accessors.SessionAccessor;
import net.minecraft.class_310;
import net.minecraft.class_320;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0013\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J!\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lmcauth/common/SessionManager;", "", "sessionAccessor", "Lmcauth/common/accessors/SessionAccessor;", "(Lmcauth/common/accessors/SessionAccessor;)V", "authenticationService", "Lcom/mojang/authlib/AuthenticationService;", "currentSession", "Lnet/minecraft/client/User;", "getCurrentSession", "()Lnet/minecraft/client/User;", "lastStatus", "Lmcauth/common/Status;", "lastStatusCheck", "", "sessionService", "Lcom/mojang/authlib/minecraft/MinecraftSessionService;", "userAuthentication", "Lcom/mojang/authlib/UserAuthentication;", "getStatus", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "login", "username", "", "password", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setSession", "", "session", "Companion", "mcauth"})
public final class SessionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionAccessor sessionAccessor;
    @NotNull
    private Status lastStatus;
    private long lastStatusCheck;
    @NotNull
    private final AuthenticationService authenticationService;
    @NotNull
    private final UserAuthentication userAuthentication;
    @NotNull
    private final MinecraftSessionService sessionService;
    public static final long STATUS_TTL = 60000L;

    public SessionManager(@NotNull SessionAccessor sessionAccessor) {
        Intrinsics.checkNotNullParameter((Object)sessionAccessor, (String)"sessionAccessor");
        this.sessionAccessor = sessionAccessor;
        this.lastStatus = Status.UNKNOWN;
        this.authenticationService = (AuthenticationService)new YggdrasilAuthenticationService(class_310.method_1551().method_1487(), UUID.randomUUID().toString());
        UserAuthentication userAuthentication = this.authenticationService.createUserAuthentication(Agent.MINECRAFT);
        Intrinsics.checkNotNullExpressionValue((Object)userAuthentication, (String)"authenticationService.createUserAuthentication(Agent.MINECRAFT)");
        this.userAuthentication = userAuthentication;
        userAuthentication = this.authenticationService.createMinecraftSessionService();
        Intrinsics.checkNotNullExpressionValue((Object)userAuthentication, (String)"authenticationService.createMinecraftSessionService()");
        this.sessionService = userAuthentication;
    }

    @NotNull
    public final class_320 getCurrentSession() {
        class_320 class_3202 = class_310.method_1551().method_1548();
        Intrinsics.checkNotNullExpressionValue((Object)class_3202, (String)"getInstance().user");
        return class_3202;
    }

    @Nullable
    public final Object getStatus(@NotNull Continuation<? super Status> $completion) {
        if (System.currentTimeMillis() - this.lastStatusCheck < 60000L) {
            return this.lastStatus;
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Status>, Object>(this, null){
            int label;
            final /* synthetic */ SessionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        SessionManager sessionManager;
                        ResultKt.throwOnFailure((Object)object);
                        class_320 session = this.this$0.getCurrentSession();
                        GameProfile profile = session.method_1677();
                        String token = session.method_1674();
                        Object object3 = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"randomUUID().toString()");
                        String id = object3;
                        SessionManager sessionManager2 = this.this$0;
                        try {
                            Status status;
                            sessionManager = sessionManager2;
                            SessionManager.access$getSessionService$p(this.this$0).joinServer(profile, token, id);
                            if (SessionManager.access$getSessionService$p(this.this$0).hasJoinedServer(profile, id, null).isComplete()) {
                                AuthMeLoggerKt.getLogger().debug("Session is valid!");
                                status = Status.VALID;
                            } else {
                                AuthMeLoggerKt.getLogger().debug("Session is invalid!");
                                status = Status.INVALID;
                            }
                            object3 = status;
                        }
                        catch (AuthenticationException authenticationException) {
                            void e;
                            sessionManager = sessionManager2;
                            AuthMeLoggerKt.getLogger().warn("Unable to validate the session:", (Throwable)e);
                            object3 = Status.INVALID;
                        }
                        SessionManager.access$setLastStatus$p(sessionManager, (Status)((Object)object3));
                        SessionManager.access$setLastStatusCheck$p(this.this$0, System.currentTimeMillis());
                        return SessionManager.access$getLastStatus$p(this.this$0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Status> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object login(@NotNull String username, @NotNull String password, @NotNull Continuation<? super class_320> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super class_320>, Object>(this, username, password, null){
            int label;
            final /* synthetic */ SessionManager this$0;
            final /* synthetic */ String $username;
            final /* synthetic */ String $password;
            {
                this.this$0 = $receiver;
                this.$username = $username;
                this.$password = $password;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SessionManager.access$getUserAuthentication$p(this.this$0).setUsername(this.$username);
                        SessionManager.access$getUserAuthentication$p(this.this$0).setPassword(this.$password);
                        SessionManager.access$getUserAuthentication$p(this.this$0).logIn();
                        String name = SessionManager.access$getUserAuthentication$p(this.this$0).getSelectedProfile().getName();
                        String uuid = UUIDTypeAdapter.fromUUID((UUID)SessionManager.access$getUserAuthentication$p(this.this$0).getSelectedProfile().getId());
                        String token = SessionManager.access$getUserAuthentication$p(this.this$0).getAuthenticatedToken();
                        String type = SessionManager.access$getUserAuthentication$p(this.this$0).getUserType().name();
                        SessionManager.access$getUserAuthentication$p(this.this$0).logOut();
                        class_320 newSession = new class_320(name, uuid, token, type);
                        SessionManager.access$setSession(this.this$0, newSession);
                        AuthMeLoggerKt.getLogger().info("New session login successful! Logged in as " + uuid + " (" + name + ")");
                        return newSession;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super class_320> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final class_320 login(@NotNull String username) {
        class_320 class_3202;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        try {
            String string = "offline:" + username;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            UUID uuid = UUID.nameUUIDFromBytes(byArray);
            class_320 newSession = new class_320(username, uuid.toString(), "invalidtoken", class_320.class_321.field_1990.name());
            this.setSession(newSession);
            AuthMeLoggerKt.getLogger().info("Offline session login successful!");
            class_3202 = newSession;
        }
        catch (Throwable e) {
            AuthMeLoggerKt.getLogger().error("Offline session login failed:", e);
            class_3202 = this.getCurrentSession();
        }
        return class_3202;
    }

    private final void setSession(class_320 session) {
        this.sessionAccessor.setSession(session);
        this.lastStatus = Status.UNKNOWN;
        this.lastStatusCheck = 0L;
    }

    public static final /* synthetic */ void access$setLastStatus$p(SessionManager $this, Status status) {
        $this.lastStatus = status;
    }

    public static final /* synthetic */ MinecraftSessionService access$getSessionService$p(SessionManager $this) {
        return $this.sessionService;
    }

    public static final /* synthetic */ void access$setLastStatusCheck$p(SessionManager $this, long l) {
        $this.lastStatusCheck = l;
    }

    public static final /* synthetic */ Status access$getLastStatus$p(SessionManager $this) {
        return $this.lastStatus;
    }

    public static final /* synthetic */ UserAuthentication access$getUserAuthentication$p(SessionManager $this) {
        return $this.userAuthentication;
    }

    public static final /* synthetic */ void access$setSession(SessionManager $this, class_320 session) {
        $this.setSession(session);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmcauth/common/SessionManager$Companion;", "", "()V", "STATUS_TTL", "", "mcauth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

