/*
    Appearance
    Contributor(s): dannytaylor
    Github: https://github.com/MCLegoMan/Appearance
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.appearance;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.events.PerspectiveEvents;
import com.mclegoman.perspective.client.util.IdentifierHelper;
import com.mclegoman.perspective.common.util.Identifiers;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import net.minecraft.class_8685;
import net.minecraft.resource.*;
import java.io.Reader;
import java.util.*;

public class Appearance {
	public static void init() {
		PerspectiveEvents.ClientResourceReloaders.register(Identifiers.APPEARANCE, new DataLoader());
	}
	public static class DataLoader extends class_4080<Map<class_2960, JsonElement>> {
		public static final Map<String, Data> registry = new HashMap<>();
		private final Gson gson;
		private final String dataType;

		public DataLoader() {
			this.gson = new Gson();
			this.dataType = "appearance";
		}

		private void add(String uuid, boolean slim, boolean enabled, class_2960 skinTexture) {
			try {
				if (!enabled) registry.remove(uuid);
				else {
					Data data = new Data(UUID.fromString(uuid), slim ? class_8685.class_7920.field_41122 : class_8685.class_7920.field_41123, skinTexture);
					registry.put(uuid, data);
				}
			} catch (Exception error) {
				com.mclegoman.perspective.common.data.Data.getVersion().sendToLog(LogType.ERROR, "Failed to add '" + uuid + "' to appearance registry: " + error);
			}
		}

		public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
			try {
				registry.clear();
				prepared.forEach(this::layout$perspective);
			} catch (Exception error) {
				com.mclegoman.perspective.common.data.Data.getVersion().sendToLog(LogType.ERROR, "Failed to apply appearance dataloader: " + error);
			}
		}
		private void layout$perspective(class_2960 identifier, JsonElement jsonElement) {
			JsonObject reader = jsonElement.getAsJsonObject();
			String skin = class_3518.method_15253(reader, "texture", identifier.method_12836() + ":textures/appearance/" + identifier.method_12832());
			boolean enabled = class_3518.method_15258(reader, "enabled", !skin.isEmpty());
			add(class_3518.method_15253(reader, "uuid", identifier.method_12832()), class_3518.method_15258(reader, "slim", false), enabled, IdentifierHelper.identifierFromString(skin, com.mclegoman.perspective.common.data.Data.getVersion().getID()));
		}
		protected Map<class_2960, JsonElement> method_18789(class_3300 resourceManager, class_3695 profiler) {
			Map<class_2960, JsonElement> map = new HashMap<>();
			load(resourceManager, this.dataType, this.gson, map);
			return map;
		}
		public static void load(class_3300 manager, String dataType, Gson gson, Map<class_2960, JsonElement> results) {
			class_7654 resourceFinder = class_7654.method_45114(dataType);
			for (Map.Entry<class_2960, class_3298> resourceEntry : resourceFinder.method_45113(manager).entrySet()) {
				class_2960 resourceEntryKey = resourceEntry.getKey();
				class_2960 resourceId = resourceFinder.method_45115(resourceEntryKey);
				try {
					Reader reader = resourceEntry.getValue().method_43039();
					try {
						JsonElement jsonElement = class_3518.method_15276(gson, reader, JsonElement.class);
						JsonElement jsonElement2 = results.put(resourceId, jsonElement);
						if (jsonElement2 != null) {
							throw new IllegalStateException("Duplicate data file ignored with ID " + resourceId);
						}
					} catch (Throwable throwable) {
						if (reader != null) {
							try {
								reader.close();
							} catch (Throwable var12) {
								throwable.addSuppressed(var12);
							}
						}
						throw throwable;
					}
					reader.close();
				} catch (Exception error) {
					com.mclegoman.perspective.common.data.Data.getVersion().sendToLog(LogType.ERROR, "Couldn't parse data file '" + resourceId + "' from '" + resourceEntryKey + "': " + error);
				}
			}
		}
	}
	public record Data(UUID uuid, class_8685.class_7920 model, class_2960 texture) {
	}
}
