/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.config.value;

import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_2960;
import org.quiltmc.config.api.values.ConfigSerializableObject;

@SuppressWarnings("unused")
public record ConfigIdentifier(class_2960 identifier) implements ConfigSerializableObject<String> {
	public class_2960 getIdentifier() {
		return this.identifier;
	}
	public static ConfigIdentifier of(class_2960 identifier) {
		return new ConfigIdentifier(identifier);
	}
	public static ConfigIdentifier of(String identifier) {
		return of(class_2960.method_60654(identifier));
	}
	public ConfigIdentifier convertFrom(String representation) {
		// We assume perspective as the namespace if none is provided - this is to make sure zoom_type is updated properly.
		return new ConfigIdentifier(class_2960.method_60654((!representation.contains(":") ? Data.getVersion().getID() + ":" : "") + representation));
	}
	public String getRepresentation() {
		return this.identifier.toString();
	}
	public ConfigIdentifier copy() {
		return this;
	}
}