/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.contributor;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.util.JsonResourceReloader;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class ContributorDataLoader extends JsonResourceReloader {
	public static final Map<String, ContributorData> registry = new HashMap<>();
	public static final String id = "contributors";
	public ContributorDataLoader() {
		super(new Gson(), id);
	}
	private void add(List<JsonElement> inputIds, String uuid, boolean shouldFlipUpsideDown, boolean shouldReplaceCape, String capeTexture, boolean shouldRenderOverlay, String overlayTexture, boolean isOverlayEmissive, boolean shouldBlink, String blinkTexture) {
		try {
			ContributorLockData lockData = Contributor.getUuid(uuid);
			if (lockData != null) {
				List<String> outputIds = new ArrayList<>();
				for (JsonElement id : inputIds) outputIds.add(id.getAsString());
				registry.put(uuid, ContributorData.builder(uuid).id(outputIds).type(lockData.getType().getName()).shouldFlipUpsideDown(shouldFlipUpsideDown).shouldReplaceCape(shouldReplaceCape).capeTexture(IdentifierHelper.identifierFromString(capeTexture)).shouldRenderOverlay(shouldRenderOverlay).overlayTexture(IdentifierHelper.identifierFromString(overlayTexture), isOverlayEmissive).shouldBlink(shouldBlink).blinkTexture(IdentifierHelper.identifierFromString(blinkTexture)).build());
			} else {
				Data.getVersion().sendToLog(LogType.WARN, Translation.getString("{} is not permitted to use contributor dataloader!", uuid));
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.WARN, Translation.getString("Failed to add contributor to contributor registry: {}", error));
		}
	}
	private void reset() {
		try {
			registry.clear();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.WARN, Translation.getString("Failed to reset contributor registry: {}", error));
		}
	}
	@Override
	public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
		try {
			reset();
			prepared.forEach(this::layout$perspective);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.WARN, Translation.getString("Failed to apply contributor dataloader: {}", error));
		}
	}
	private void layout$perspective(class_2960 identifier, JsonElement jsonElement) {
		try {
			JsonObject reader = jsonElement.getAsJsonObject();
			JsonArray defaultIds = new JsonArray();
			defaultIds.add(identifier.method_12832());
			JsonArray ids = class_3518.method_15292(reader, "ids", defaultIds);
			List<JsonElement> id = ids.asList();
			JsonArray uuids = class_3518.method_15261(reader, "uuids");
			boolean shouldFlipUpsideDown = class_3518.method_15258(reader, "shouldFlipUpsideDown", false);
			boolean shouldReplaceCape = class_3518.method_15258(reader, "shouldReplaceCape", false);
			String capeTexture = class_3518.method_15253(reader, "capeTexture", "perspective:textures/contributors/cape/dev_oneyear");
			boolean shouldRenderOverlay = class_3518.method_15258(reader, "shouldRenderOverlay", false);
			String overlayTexture = class_3518.method_15253(reader, "overlayTexture", "none");
			boolean isOverlayEmissive = class_3518.method_15258(reader, "isOverlayEmissive", false);
			boolean shouldBlink = class_3518.method_15258(reader, "shouldBlink", false);
			String blinkTexture = class_3518.method_15253(reader, "blinkTexture", "none");
			for (JsonElement uuid : uuids) add(id, uuid.getAsString(), shouldFlipUpsideDown, shouldReplaceCape, capeTexture, shouldRenderOverlay, overlayTexture, isOverlayEmissive, shouldBlink, blinkTexture);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.WARN, Translation.getString("Failed to load contributor from dataloader: {}", error));
		}
	}
}