/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity;

import com.mclegoman.perspective.client.entity.model.*;
import com.mclegoman.perspective.common.util.Identifiers;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.minecraft.class_4495;
import net.minecraft.class_551;
import net.minecraft.class_560;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_587;
import net.minecraft.class_591;
import net.minecraft.class_623;
import net.minecraft.client.model.*;
import net.minecraft.client.render.entity.model.*;

public class EntityModels {
	public static double entityCapeY = 0.0F;
	public static final class_5601 contributorOverlaySlim = new class_5601(Identifiers.CONTRIBUTOR, "slim");
	public static final class_5601 contributorOverlayWide = new class_5601(Identifiers.CONTRIBUTOR, "wide");
	public static final class_5601 entityCape = new class_5601(Identifiers.ENTITY, "cape");
	public static final class_5601 babyPigOverlay = new class_5601(Identifiers.PIG, "baby_outer");
	public static final class_5601 pigOverlay = new class_5601(Identifiers.PIG, "outer");
	public static final class_5601 pigMuddyFlower = new class_5601(Identifiers.PIG, "muddy_flower");
	public static final class_5601 beeOverlay = new class_5601(Identifiers.BEE, "outer");
	public static final class_5601 babyBeeOverlay = new class_5601(Identifiers.BEE, "outer_baby");
	public static final class_5601 mooshroomOverlay = new class_5601(Identifiers.MOOSHROOM, "outer");
	public static final class_5601 babyMooshroomOverlay = new class_5601(Identifiers.MOOSHROOM, "outer_baby");
	public static final class_5601 cowOverlay = new class_5601(Identifiers.COW, "outer");
	public static final class_5601 babyCowOverlay = new class_5601(Identifiers.COW, "outer_baby");
	public static final class_5601 skeletonOverlay = new class_5601(Identifiers.SKELETON, "outer");
	public static final class_5601 witherSkeletonOverlay = new class_5601(Identifiers.WITHER_SKELETON, "outer");
	public static final class_5601 zombieOverlay = new class_5601(Identifiers.ZOMBIE, "outer");
	public static final class_5601 giantOverlay = new class_5601(Identifiers.GIANT, "outer");
	public static final class_5601 babyZombieOverlay = new class_5601(Identifiers.ZOMBIE, "outer_baby");
	public static final class_5601 armorStandOverlay = new class_5601(Identifiers.ARMOR_STAND, "outer");
	public static final class_5601 babyArmorStandOverlay = new class_5601(Identifiers.ARMOR_STAND, "outer_baby");
	public static final class_5601 halloweenHat = new class_5601(Identifiers.PLAYER, "halloween_hat");
	public static final class_5601 playerFace = new class_5601(Identifiers.PLAYER, "face");
	public static void init() {
		EntityModelLayerRegistry.registerModelLayer(contributorOverlaySlim, () -> class_5607.method_32110(class_591.method_32028(new class_5605(0.001F), true), 64, 64));
		EntityModelLayerRegistry.registerModelLayer(contributorOverlayWide, () -> class_5607.method_32110(class_591.method_32028(new class_5605(0.001F), false), 64, 64));
		EntityModelLayerRegistry.registerModelLayer(entityCape, () -> class_5607.method_32110(LivingEntityCapeModel.getModelData(new class_5605(0.0F)), 64, 64));
		EntityModelLayerRegistry.registerModelLayer(babyPigOverlay, () -> class_587.method_32025(new class_5605(0.499F)).method_62137(class_587.field_52925));
		EntityModelLayerRegistry.registerModelLayer(pigOverlay, () -> class_587.method_32025(new class_5605(0.499F)));
		EntityModelLayerRegistry.registerModelLayer(pigMuddyFlower, MuddyFlowerModel::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(beeOverlay, () -> getBeeEntityModelData(new class_5605(0.5F)));
		EntityModelLayerRegistry.registerModelLayer(babyBeeOverlay, () -> getBeeEntityModelData(new class_5605(0.5F)).method_62137(class_4495.field_52871));
		EntityModelLayerRegistry.registerModelLayer(mooshroomOverlay, CowOverlayEntityModel::getTexturedOverlayModelData);
		EntityModelLayerRegistry.registerModelLayer(babyMooshroomOverlay, () -> CowOverlayEntityModel.getTexturedOverlayModelData().method_62137(class_560.field_52893));
		EntityModelLayerRegistry.registerModelLayer(cowOverlay, CowOverlayEntityModel::getTexturedOverlayModelData);
		EntityModelLayerRegistry.registerModelLayer(babyCowOverlay, () -> CowOverlayEntityModel.getTexturedOverlayModelData().method_62137(class_560.field_52893));
		EntityModelLayerRegistry.registerModelLayer(skeletonOverlay, () -> getBipedEntityModelData(new class_5605(0.5F), 64, 32));
		EntityModelLayerRegistry.registerModelLayer(witherSkeletonOverlay, () -> getBipedEntityModelData(new class_5605(0.5F), 64, 32));
		EntityModelLayerRegistry.registerModelLayer(zombieOverlay, () -> getBipedEntityModelData(new class_5605(0.5F), 64, 64));
		EntityModelLayerRegistry.registerModelLayer(giantOverlay, () -> getBipedEntityModelData(new class_5605(0.5F), 64, 64).method_62137(new PerspectiveModelTransformer(6.0F, -20.0F)));
		EntityModelLayerRegistry.registerModelLayer(babyZombieOverlay, () -> getBipedEntityModelData(new class_5605(0.5F), 64, 64).method_62137(class_623.field_52918));
		EntityModelLayerRegistry.registerModelLayer(armorStandOverlay, () -> class_5607.method_32110(ArmorStandOverlayEntityModel.getModelData(new class_5605(0.01F), 0.0F), 64, 64));
		EntityModelLayerRegistry.registerModelLayer(babyArmorStandOverlay, () -> class_5607.method_32110(ArmorStandOverlayEntityModel.getModelData(new class_5605(0.01F), 0.0F), 64, 64).method_62137(class_551.field_52918));
		EntityModelLayerRegistry.registerModelLayer(halloweenHat, HalloweenHatModel::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(playerFace, () -> PlayerFaceModel.getTexturedModelData(new class_5605(0.0F)));
	}
	public static void tick() {
		entityCapeY = (entityCapeY + 0.5F) % 80.0F;
	}
	public static double getEntityCapeY() {
		return entityCapeY % 80.0F;
	}
	public static class_5607 getBipedEntityModelData(class_5605 dilation, int width, int height) {
		return class_5607.method_32110(class_572.method_32011(dilation, 0.0F), width, height);
	}
	public static class_5607 getBeeEntityModelData(class_5605 dilation) {
		class_5609 modelData = new class_5609();
		class_5610 modelPartData = modelData.method_32111();
		class_5610 modelPartData2 = modelPartData.method_32117("bone", class_5606.method_32108(), class_5603.method_32090(0.0F, 19.0F, 0.0F));
		class_5610 modelPartData3 = modelPartData2.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32098(-3.5F, -4.0F, -5.0F, 7.0F, 7.0F, 10.0F, dilation), class_5603.field_27701);
		modelPartData3.method_32117("stinger", class_5606.method_32108().method_32101(26, 7).method_32098(0.0F, -1.0F, 5.0F, 0.0F, 1.0F, 2.0F, dilation), class_5603.field_27701);
		modelPartData3.method_32117("left_antenna", class_5606.method_32108().method_32101(2, 0).method_32098(1.5F, -2.0F, -3.0F, 1.0F, 2.0F, 3.0F, dilation), class_5603.method_32090(0.0F, -2.0F, -5.0F));
		modelPartData3.method_32117("right_antenna", class_5606.method_32108().method_32101(2, 3).method_32098(-2.5F, -2.0F, -3.0F, 1.0F, 2.0F, 3.0F, dilation), class_5603.method_32090(0.0F, -2.0F, -5.0F));
		class_5605 outerDilation = dilation.method_32094(0.001F);
		modelPartData2.method_32117("right_wing", class_5606.method_32108().method_32101(0, 18).method_32098(-9.0F, 0.0F, 0.0F, 9.0F, 0.0F, 6.0F, outerDilation), class_5603.method_32091(-1.5F, -4.0F, -3.0F, 0.0F, -0.2618F, 0.0F));
		modelPartData2.method_32117("left_wing", class_5606.method_32108().method_32101(0, 18).method_32096().method_32098(0.0F, 0.0F, 0.0F, 9.0F, 0.0F, 6.0F, outerDilation), class_5603.method_32091(1.5F, -4.0F, -3.0F, 0.0F, 0.2618F, 0.0F));
		modelPartData2.method_32117("front_legs", class_5606.method_32108().method_32104("front_legs", -5.0F, 0.0F, 0.0F, 7, 2, 0, 26, 1), class_5603.method_32090(1.5F, 3.0F, -2.0F));
		modelPartData2.method_32117("middle_legs", class_5606.method_32108().method_32104("middle_legs", -5.0F, 0.0F, 0.0F, 7, 2, 0, 26, 3), class_5603.method_32090(1.5F, 3.0F, 0.0F));
		modelPartData2.method_32117("back_legs", class_5606.method_32108().method_32104("back_legs", -5.0F, 0.0F, 0.0F, 7, 2, 0, 26, 5), class_5603.method_32090(1.5F, 3.0F, 2.0F));
		return class_5607.method_32110(modelData, 64, 64);
	}
}