/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.model;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_9998;
import net.minecraft.client.model.*;
import java.util.function.Function;

public class ArmorStandOverlayEntityModel extends class_583<class_9998> {
	public final class_630 head;
	public final class_630 body;
	public final class_630 rightArm;
	public final class_630 leftArm;
	public final class_630 rightLeg;
	public final class_630 leftLeg;
	public ArmorStandOverlayEntityModel(class_630 root) {
		this(root, class_1921::method_23580);
	}
	public ArmorStandOverlayEntityModel(class_630 root, Function<class_2960, class_1921> renderLayerFactory) {
		super(root, renderLayerFactory);
		this.head = root.method_32086("head");
		this.body = root.method_32086("body");
		this.rightArm = root.method_32086("right_arm");
		this.leftArm = root.method_32086("left_arm");
		this.rightLeg = root.method_32086("right_leg");
		this.leftLeg = root.method_32086("left_leg");
	}
	public static class_5609 getModelData(class_5605 dilation, float pivotOffsetY) {
		class_5609 modelData = new class_5609();
		class_5610 modelPartData = modelData.method_32111();
		modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, -7.99F, -4.0F, 8.0F, 8.0F, 8.0F, dilation), class_5603.method_32090(0.0F, 0.0F + pivotOffsetY, 0.0F));
		modelPartData.method_32117("body", class_5606.method_32108().method_32101(16, 16).method_32098(-4.0F, 0.0F, -2.0F, 8.0F, 12.0F, 4.0F, dilation), class_5603.method_32090(0.0F, 0.0F + pivotOffsetY, 0.0F));
		modelPartData.method_32117("right_arm", class_5606.method_32108().method_32101(40, 16).method_32098(-3.0F, -2.0F, -2.0F, 4.0F, 12.0F, 4.0F, dilation), class_5603.method_32090(-5.0F, 2.0F + pivotOffsetY, 0.0F));
		modelPartData.method_32117("left_arm", class_5606.method_32108().method_32101(40, 16).method_32096().method_32098(-1.0F, -2.0F, -2.0F, 4.0F, 12.0F, 4.0F, dilation), class_5603.method_32090(5.0F, 2.0F + pivotOffsetY, 0.0F));
		modelPartData.method_32117("right_leg", class_5606.method_32108().method_32101(0, 16).method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F, dilation), class_5603.method_32090(-1.9F, 12.0F + pivotOffsetY, 0.0F));
		modelPartData.method_32117("left_leg", class_5606.method_32108().method_32101(0, 16).method_32096().method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F, dilation), class_5603.method_32090(1.9F, 12.0F + pivotOffsetY, 0.0F));
		return modelData;
	}

	public void setAngles(class_9998 armorStandEntityRenderState) {
		float multiplier = 0.017453292F;
		super.method_2819(armorStandEntityRenderState);
		this.head.field_3654 = multiplier * armorStandEntityRenderState.field_53251.method_10256();
		this.head.field_3675 = multiplier * armorStandEntityRenderState.field_53251.method_10257();
		this.head.field_3674 = multiplier * armorStandEntityRenderState.field_53251.method_10258();

		this.body.field_3654 = multiplier * armorStandEntityRenderState.field_53252.method_10256();
		this.body.field_3675 = multiplier * armorStandEntityRenderState.field_53252.method_10257();
		this.body.field_3674 = multiplier * armorStandEntityRenderState.field_53252.method_10258();

		this.leftArm.field_3654 = multiplier * armorStandEntityRenderState.field_53253.method_10256();
		this.leftArm.field_3675 = multiplier * armorStandEntityRenderState.field_53253.method_10257();
		this.leftArm.field_3674 = multiplier * armorStandEntityRenderState.field_53253.method_10258();

		this.rightArm.field_3654 = multiplier * armorStandEntityRenderState.field_53254.method_10256();
		this.rightArm.field_3675 = multiplier * armorStandEntityRenderState.field_53254.method_10257();
		this.rightArm.field_3674 = multiplier * armorStandEntityRenderState.field_53254.method_10258();

		this.leftLeg.field_3654 = multiplier * armorStandEntityRenderState.field_53255.method_10256();
		this.leftLeg.field_3675 = multiplier * armorStandEntityRenderState.field_53255.method_10257();
		this.leftLeg.field_3674 = multiplier * armorStandEntityRenderState.field_53255.method_10258();

		this.rightLeg.field_3654 = multiplier * armorStandEntityRenderState.field_53256.method_10256();
		this.rightLeg.field_3675 = multiplier * armorStandEntityRenderState.field_53256.method_10257();
		this.rightLeg.field_3674 = multiplier * armorStandEntityRenderState.field_53256.method_10258();
	}
}