/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.mclegoman.perspective.client.contributor.Contributor;
import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.events.AprilFoolsPrank;
import com.mclegoman.perspective.client.events.AprilFoolsPrankDataLoader;
import net.minecraft.class_10055;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_922;

public class ContributorOverlayFeatureRenderer<P extends class_10055, M extends class_591> extends class_3887<P, M> {
	private final M model;
	public ContributorOverlayFeatureRenderer(class_3883<P, M> context, M model) {
		super(context);
		this.model = model;
	}
	public void render(class_4587 matrices, class_4597 vertexConsumers, int light, P state, float limbAngle, float limbDistance) {
		String uuid = (PerspectiveConfig.config.allowAprilFools.value() && AprilFoolsPrank.isAprilFools() && !AprilFoolsPrankDataLoader.registry.isEmpty()) ? AprilFoolsPrank.getContributor(((PerspectiveRenderState)state).perspective$getUUID()) : String.valueOf(((PerspectiveRenderState)state).perspective$getUUID());
		if (Contributor.shouldOverlayTexture(uuid)) {
			class_2960 texture = Contributor.getOverlayTexture(uuid);
			if (texture != null) {
				class_591 playerModel = this.method_17165();
				this.model.field_3398.method_17138(playerModel.field_3398);
				this.model.field_3394.method_17138(playerModel.field_3394);
				this.model.field_3391.method_17138(playerModel.field_3391);
				this.model.field_3401.method_17138(playerModel.field_3401);
				this.model.field_27433.method_17138(playerModel.field_27433);
				this.model.field_3392.method_17138(playerModel.field_3392);
				this.model.field_3397.method_17138(playerModel.field_3397);
				this.model.field_3484.method_17138(playerModel.field_3484);
				this.model.field_3486.method_17138(playerModel.field_3486);
				this.model.field_3482.method_17138(playerModel.field_3482);
				this.model.field_3479.method_17138(playerModel.field_3479);
				this.model.field_3483.method_17138(playerModel.field_3483);
				this.model.field_3398.field_3665 = playerModel.field_3398.field_3665;
				this.model.field_3394.field_3665 = playerModel.field_3394.field_3665;
				this.model.field_3391.field_3665 = playerModel.field_3391.field_3665;
				this.model.field_3401.field_3665 = playerModel.field_3401.field_3665;
				this.model.field_27433.field_3665 = playerModel.field_27433.field_3665;
				this.model.field_3392.field_3665 = playerModel.field_3392.field_3665;
				this.model.field_3397.field_3665 = playerModel.field_3397.field_3665;
				this.model.field_3484.field_3665 = playerModel.field_3484.field_3665;
				this.model.field_3486.field_3665 = playerModel.field_3486.field_3665;
				this.model.field_3482.field_3665 = playerModel.field_3482.field_3665;
				this.model.field_3479.field_3665 = playerModel.field_3479.field_3665;
				this.model.field_3483.field_3665 = playerModel.field_3483.field_3665;
				playerModel.method_64254(this.model);
				this.model.method_62110(state);
				this.model.method_60879(matrices, vertexConsumers.getBuffer(Contributor.isEmissive(uuid) ? class_1921.method_42600(texture) : class_1921.method_23580(texture)), light, class_922.method_23622(state, 0.0F));
			}
		}
	}
}