/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.google.gson.JsonObject;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import java.util.Optional;
import net.minecraft.class_10042;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_560;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_922;

public class CowFlowerFeatureRenderer extends class_3887<class_10042, class_560> {
	private final class_776 blockRenderManager;
	public CowFlowerFeatureRenderer(class_3883<class_10042, class_560> context, class_776 blockRenderManager) {
		super(context);
		this.blockRenderManager = blockRenderManager;
	}
	public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10042 state, float f, float g) {
		if (!state.field_53457) {
			boolean bl = state.field_53462 && state.field_53333;
			if (!state.field_53333 || bl) {
				class_2680 blockState = getBlockstate(state);
				if (!blockState.method_26215()) {
					int overlay = class_922.method_23622(state, 0.0F);
					class_1087 bakedModel = this.blockRenderManager.method_3349(blockState);
					matrixStack.method_22903();
					matrixStack.method_46416(0.2F, -0.35F, 0.5F);
					matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-48.0F));
					matrixStack.method_22905(-1.0F, -1.0F, 1.0F);
					matrixStack.method_46416(-0.5F, -0.5F, -0.5F);
					this.renderBlockstate(matrixStack, vertexConsumerProvider, i, bl, blockState, overlay, bakedModel);
					matrixStack.method_22909();
					matrixStack.method_22903();
					matrixStack.method_46416(0.2F, -0.35F, 0.5F);
					matrixStack.method_22907(class_7833.field_40716.rotationDegrees(42.0F));
					matrixStack.method_46416(0.1F, 0.0F, -0.6F);
					matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-48.0F));
					matrixStack.method_22905(-1.0F, -1.0F, 1.0F);
					matrixStack.method_46416(-0.5F, -0.5F, -0.5F);
					this.renderBlockstate(matrixStack, vertexConsumerProvider, i, bl, blockState, overlay, bakedModel);
					matrixStack.method_22909();
					matrixStack.method_22903();
					this.method_17165().method_2800().method_22703(matrixStack);
					matrixStack.method_46416(0.0F, -0.7F, -0.2F);
					matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-78.0F));
					matrixStack.method_22905(-1.0F, -1.0F, 1.0F);
					matrixStack.method_46416(-0.5F, -0.5F, -0.5F);
					this.renderBlockstate(matrixStack, vertexConsumerProvider, i, bl, blockState, overlay, bakedModel);
					matrixStack.method_22909();
				}
			}
		}
	}
	private void renderBlockstate(class_4587 matrices, class_4597 vertexConsumers, int light, boolean renderAsModel, class_2680 blockState, int overlay, class_1087 model) {
		if (renderAsModel) this.blockRenderManager.method_3350().method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_1921.method_23287(class_1059.field_5275)), blockState, model, 0.0F, 0.0F, 0.0F, light, overlay);
		else this.blockRenderManager.method_3353(blockState, matrices, vertexConsumers, light, overlay);
	}
	private class_2680 getBlockstate(class_10042 state) {
		if (state != null) {
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(state);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							// 1.21.5 adds cow variants, so i'm adding a default "temperate" variant in the mean time.
							String cowVariant = "temperate";
							if (variants.has(cowVariant)) {
								JsonObject typeRegistry = class_3518.method_15296(variants, cowVariant);
								if (typeRegistry != null) {
									boolean enabled = class_3518.method_15258(typeRegistry, "enabled", true);
									if (enabled) {
										if (typeRegistry.has("block") || typeRegistry.has("mushroom")) {
											JsonObject block = typeRegistry.has("block") ? class_3518.method_15296(typeRegistry, "block") : class_3518.method_15296(typeRegistry, "mushroom");
											if (block.has("identifier")) {
												class_2960 blockId = IdentifierHelper.identifierFromString(class_3518.method_15253(block, "identifier", "minecraft:air"));
												if (class_7923.field_41175.method_10250(blockId)) return class_7923.field_41175.method_63535(blockId).method_9564();
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return class_2246.field_10124.method_9564();
	}
}
