/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.common.data.Data;
import java.util.Optional;
import net.minecraft.class_10042;
import net.minecraft.class_10047;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_560;
import net.minecraft.class_922;

public class CowOverlayFeatureRenderer<T extends class_10042, M extends class_560> extends class_3887<T, M> {
	private final M model;
	private final M babyModel;
	public CowOverlayFeatureRenderer(class_3883<T, M> context, M model, M babyModel) {
		super(context);
		this.model = model;
		this.babyModel = babyModel;
	}
	public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T state, float limbAngle, float limbDistance) {
		M entityModel = state.field_53457 ? this.babyModel : this.model;
		entityModel.method_62089(state);
		class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23578(getFinalTexture(state)));
		entityModel.method_60879(matrices, vertexConsumer, light, class_922.method_23622(state, 0.0F));
	}
	public class_2960 getFinalTexture(class_10042 state) {
		boolean isTexturedEntity = true;
		Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(state);
		String type = (state instanceof class_10047 mooshroomState) ? String.valueOf(mooshroomState.field_53493).toLowerCase() : "temperate";
		class_2960 defaultId = class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/" + (state instanceof class_10047 ? "mooshroom" : "cow") + "/" + type + "_" + (state instanceof class_10047 ? "mooshroom" : "cow") + "_overlay.png");
		if (entityData.isPresent()) {
			JsonObject entitySpecific = entityData.get().getEntitySpecific();
			if (entitySpecific != null) {
				if (entitySpecific.has(type)) {
					JsonObject typeRegistry = class_3518.method_15296(entitySpecific, type);
					if (typeRegistry != null) {
						isTexturedEntity = class_3518.method_15258(typeRegistry, "enabled", true);
					}
				}
			}
			if (isTexturedEntity) return TexturedEntity.getTexture(state, type + "_", "_overlay", defaultId);
		}
		return defaultId;
	}
}