/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.entity.states.PerspectiveLivingRenderState;
import net.minecraft.class_10042;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import org.joml.Quaternionf;

public class EntityCapeFeatureRenderer<T extends class_10042> extends class_3887<T, LivingEntityCapeModel<T>> {
	private final LivingEntityCapeModel<T> model;
	private final class_2960 capeTexture;
	private final float scale;
	private final float offsetX;
	private final float offsetY;
	private final float offsetZ;
	private final Quaternionf rotation;
	private EntityCapeFeatureRenderer(class_3883<T, LivingEntityCapeModel<T>> featureRendererContext, LivingEntityCapeModel<T> model, class_2960 capeTexture, float offsetX, float offsetY, float offsetZ, Quaternionf rotation, float scale) {
		super(featureRendererContext);
		this.model = model;
		this.capeTexture = capeTexture;
		this.offsetX = offsetX;
		this.offsetY = offsetY;
		this.offsetZ = offsetZ;
		this.rotation = rotation;
		this.scale = scale;
	}
	public static class Builder<T extends class_10042> {
		class_3883<T, LivingEntityCapeModel<T>> featureRendererContext;
		LivingEntityCapeModel<T> model;
		class_2960 capeTexture;
		float scale = 1.0F;
		float offsetX = 0.0F;
		float offsetY = 0.0F;
		float offsetZ = 0.125F;
		Quaternionf rotation = new Quaternionf();
		public Builder(class_3883<T, LivingEntityCapeModel<T>> featureRendererContext, LivingEntityCapeModel<T> model, class_2960 capeTexture) {
			this.featureRendererContext = featureRendererContext;
			this.model = model;
			this.capeTexture = capeTexture;
		}
		public Builder scale(float scale) {
			this.scale = scale;
			return this;
		}
		public Builder offsetX(float x) {
			this.offsetX = x;
			return this;
		}
		public Builder offsetY(float y) {
			this.offsetY = y;
			return this;
		}
		public Builder offsetZ(float z) {
			this.offsetZ = z;
			return this;
		}
		public Builder rotation(Quaternionf rotation) {
			this.rotation = rotation;
			return this;
		}
		public EntityCapeFeatureRenderer<T> build() {
			return new EntityCapeFeatureRenderer<>(this.featureRendererContext, this.model, this.capeTexture, offsetX, offsetY, offsetZ, rotation, scale);
		}
	}
	public void render(class_4587 matrixStack, class_4597 vertexConsumers, int light, T state, float limbAngle, float limbDistance) {
		float delta = ClientData.minecraft.method_61966().method_60637(true);
		matrixStack.method_22903();
		if (state.field_53457) {
			matrixStack.method_22905(0.5F, 0.5F, 0.5F);
			matrixStack.method_46416(0.0F, 1.5F, 0.0F);
		}
		matrixStack.method_22905(this.scale, this.scale, this.scale);
		matrixStack.method_46416(this.offsetX, this.offsetY, this.offsetZ);
		matrixStack.method_22907(rotation);
		double g = (Math.cos(EntityModels.getEntityCapeY() * (2.0F * 3.141592653589793F / 80.0F)) + 1.0F) * 0.48F;
		float i = class_3532.method_17821(delta, ((PerspectiveLivingRenderState)state).perspective$getPrevBodyYaw(), state.field_53446);
		double j = class_3532.method_15374(i * 0.017453292F);
		double k = -class_3532.method_15362(i * 0.017453292F);
		float l = class_3532.method_15363((float)g * 10.0F, -6.0F, 32.0F);
		float m = class_3532.method_15363((float)(0.0F * j + 0.0F * k) * 100.0F, 0.0F, 150.0F);
		float n = class_3532.method_15363((float)(0.0F * k - 0.0F * j) * 100.0F, -20.0F, 20.0F);
		if (state.field_53334) l += 25.0F;
		matrixStack.method_22907(class_7833.field_40714.rotationDegrees(6.0F + m / 2.0F + l));
		matrixStack.method_22907(class_7833.field_40718.rotationDegrees(n / 2.0F));
		matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F - n / 2.0F));

		this.model.renderCape(matrixStack, vertexConsumers.getBuffer(class_1921.method_23580(TexturedEntity.getTexture(state, "", "_cape", capeTexture))), state, light, class_4608.field_21444);
		matrixStack.method_22909();
	}
}
