/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.model.MuddyFlowerModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10053;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_587;
import net.minecraft.class_922;

@Environment(EnvType.CLIENT)
public class MuddyFlowerFeatureRenderer<S extends class_10053, P extends class_587> extends class_3887<S, P> {
	private final MuddyFlowerModel<S> model;
	private final class_2960 texture;
	public MuddyFlowerFeatureRenderer(class_3883<S, P> context, MuddyFlowerModel<S> model, class_2960 texture) {
		super(context);
		this.model = model;
		this.texture = texture;
	}
	public void render(class_4587 matrices, class_4597 vertexConsumers, int light, S state, float limbAngle, float limbDistance) {
		class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23580(TexturedEntity.getTexture(state, "", "_muddy_flower", this.texture)));
		this.model.render(matrices, vertexConsumer, light, class_922.method_23622(state, 0.0F), this.method_17165());
	}
}
