/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_922;

@Environment(EnvType.CLIENT)
public class OverlayFeatureRenderer<S extends class_10042, M extends class_583<? super S>> extends class_3887<S, M> {
	private final M model;
	private final M babyModel;
	private final class_2960 texture;
	public OverlayFeatureRenderer(class_3883<S, M> context, M model, M babyModel, class_2960 texture) {
		super(context);
		this.model = model;
		this.babyModel = babyModel;
		this.texture = texture;
	}
	public void render(class_4587 matrices, class_4597 vertexConsumers, int light, S state, float limbAngle, float limbDistance) {
		M entityModel = state.field_53457 ? this.babyModel : this.model;
		if (entityModel != null) {
			entityModel.method_2819(state);
			class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23580(TexturedEntity.getTexture(state, "", "_overlay", this.texture)));
			entityModel.method_60879(matrices, vertexConsumer, light, class_922.method_23622(state, 0.0F));
		}
	}
}
