/*
    perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.entity.renderer.feature;

import com.mclegoman.perspective.client.contributor.Contributor;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.PlayerFaceModel;
import com.mclegoman.perspective.client.entity.states.PerspectivePlayerRenderState;
import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import net.minecraft.class_10055;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_591;
import net.minecraft.class_922;

public class PlayerFaceFeatureRenderer extends class_3887<class_10055, class_591> {
	private final PlayerFaceModel<class_10055> model;
	public PlayerFaceFeatureRenderer(class_3883<class_10055, class_591> context, class_5599 entityModels) {
		super(context);
		this.model = new PlayerFaceModel<>(entityModels.method_32072(EntityModels.playerFace));
	}
	public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_10055 state, float limbAngle, float limbDistance) {
		if (!state.field_53333) {
			if (((PerspectivePlayerRenderState)state).perspective$getBlinking()) {
				// We don't need to check if we can blink, since we do that when setting blinking.
				//if (Contributor.getContributorData(uuid).getShouldBlink()) {}
				this.model.face.method_17138(this.method_17165().field_3398);
				class_2960 texture = Contributor.getBlinkTexture(((PerspectiveRenderState)state).perspective$getUUID().toString(), state.field_53520.comp_1626());
				this.model.method_60879(matrices, vertexConsumers.getBuffer(texture.equals(state.field_53520.comp_1626()) ? class_1921.method_23572(texture) : class_1921.method_23580(texture)), light, class_922.method_23622(state, 0.0F));
			}
		}
	}
}