/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.events;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.util.JsonResourceReloader;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class AprilFoolsPrankDataLoader extends JsonResourceReloader {
	public static final Map<String, PrankData> registry = new HashMap<>();
	public static final String ID = "prank";
	public AprilFoolsPrankDataLoader() {
		super(new Gson(), ID);
	}
	private void add(List<class_2960> textures, boolean isSlim, String contributor) {
		try {
			registry.put(contributor + (isSlim ? "_slim" : "_wide"), new PrankData(textures, isSlim, contributor));
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to add april fools prank to registry: {}", error));
		}
	}
	private void addSkins(JsonArray textureIds, boolean isSlim, String contributor) {
		List<class_2960> textures = new ArrayList<>();
		for (JsonElement skin : textureIds) {
			String id = skin.getAsString();
			String namespace = IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, id);
			String texture = IdentifierHelper.getStringPart(IdentifierHelper.Type.KEY, id);
			if (namespace != null && texture != null) {
				texture = texture.toLowerCase();
				texture = !texture.startsWith("textures/") ? "textures/" + texture : texture;
				texture = !texture.endsWith(".png") ? texture + ".png" : texture;
				textures.add(class_2960.method_60655(namespace, texture));
			}
		}
		if (!textures.isEmpty()) add(textures, isSlim, contributor);
	}
	private void reset() {
		try {
			registry.clear();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to reset april fools prank registry: {}", error));
		}
	}
	@Override
	public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
		try {
			reset();
			for (class_3298 resource : manager.method_14489(class_2960.method_60655(Data.getVersion().getID(), ID + ".json"))) {
				JsonObject reader = class_3518.method_15255(resource.method_43039());
				if (class_3518.method_15258(reader, "replace", false)) reset();
				JsonArray values = class_3518.method_15292(reader, "values", new JsonArray());
				for (JsonElement element : values) {
					if (element instanceof JsonObject value) {
						String contributor = class_3518.method_15253(value, "contributor", "772eb47b-a24e-4d43-a685-6ca9e9e132f7");
						JsonObject skins = class_3518.method_15281(value, "skins", new JsonObject());
						addSkins(class_3518.method_15292(skins, "slim", new JsonArray()), true, contributor);
						addSkins(class_3518.method_15292(skins, "wide", new JsonArray()), false, contributor);
					}
				}
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to load prank values: {}", error));
		}
	}
	public record PrankData(List<class_2960> textures, boolean isSlim, String contributor) {
	}
}