/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.events;

import com.mclegoman.luminance.common.data.Data;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import java.util.Arrays;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class PerspectiveExecute extends com.mclegoman.luminance.client.events.Execute {
	public static void onStartItemUse(class_1799 stack, class_1937 world, class_1657 user, class_1268 hand) {
		PerspectiveEvents.OnStartItemUse.registry.forEach((id, runnable) -> {
			try {
				runnable.run(stack, world, user, hand);
			} catch (Exception error) {
				Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to execute OnStartItemUse event with id: {}: {}", id, error));
			}
		});
	}
	public static void onFinishItemUse(class_1799 stack, class_1937 world, class_1309 user) {
		PerspectiveEvents.OnFinishItemUse.registry.forEach((id, runnable) -> {
			try {
				runnable.run(stack, world, user);
			} catch (Exception error) {
				Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to execute OnFinishItemUse event with id: {}: {}", id, error));
			}
		});
	}
	public static class_2561 getVariable(class_2960 id, String[] args) {
		try {
			return PerspectiveEvents.Variables.registry.get(id).call(args);
		} catch (Exception error) {
			return class_2561.method_43470(id.toString() + Arrays.toString(args));
		}
	}
}
