/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.hide;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.util.JsonResourceReloader;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_7923;

public class DynamicCrosshairDataLoader extends JsonResourceReloader {
	public static final List<class_1792> activeRegistry = new ArrayList<>();
	public static final List<class_1792> heldRegistry = new ArrayList<>();
	public static final String resourceLocation = "perspective/dynamic_crosshair";
	public DynamicCrosshairDataLoader() {
		super(new Gson(), resourceLocation);
	}
	private void add(class_1792 value, ItemType itemType) {
		try {
			switch (itemType) {
				case active -> {
					if (!activeRegistry.contains(value)) activeRegistry.add(value);
				}
				case held -> {
					if (!heldRegistry.contains(value)) heldRegistry.add(value);
				}
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to add dynamic crosshair item to registry: {}", error));
		}
	}
	private void reset() {
		try {
			activeRegistry.clear();
			heldRegistry.clear();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to reset dynamic crosshair item registry: {}", error));
		}
	}

	@Override
	public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
		try {
			reset();
			layout$perspective(manager);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to apply dynamic crosshair item dataloader: {}", Data.getVersion().getID(), error));
		}
	}
	private void layout$perspective(class_3300 manager) {
		List<class_3298> hideLists = manager.method_14489(class_2960.method_60655(Data.getVersion().getID(), "dynamic_crosshair.json"));
		for (class_3298 resource : hideLists) {
			try {
				JsonObject reader = class_3518.method_15255(resource.method_43039());
				if (class_3518.method_15270(reader, "replace")) reset();
				for (JsonElement value : class_3518.method_15292(class_3518.method_15281(reader, "active", new JsonObject()), "values", new JsonArray())) add(class_7923.field_41178.method_63535(class_2960.method_60654(value.getAsString())), ItemType.active);
				for (JsonElement value : class_3518.method_15292(class_3518.method_15281(reader, "held", new JsonObject()), "values", new JsonArray())) add(class_7923.field_41178.method_63535(class_2960.method_60654(value.getAsString())), ItemType.held);
			} catch (Exception error) {
				Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to load perspective dynamic crosshair item list: {}", error));
			}
		}
	}
	private enum ItemType {
		active,
		held
	}
}