/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.hide;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.util.JsonResourceReloader;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class HideArmorDataLoader extends JsonResourceReloader {
	public static final List<String> registry = new ArrayList<>();
	public static final String resourceLocation = "perspective/hide_armor";

	public HideArmorDataLoader() {
		super(new Gson(), resourceLocation);
	}

	private void add(String value) {
		try {
			if (!registry.contains(value)) registry.add(value);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to add hide armor to registry: {}", error));
		}
	}

	private void reset() {
		try {
			registry.clear();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to reset hide armor registry: {}", error));
		}
	}

	@Override
	public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
		try {
			reset();
			layout$perspective(manager);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to apply hide armor dataloader: {}", Data.getVersion().getID(), error));
		}
	}

	private void layout$perspective(class_3300 manager) {
		List<class_3298> hideLists = manager.method_14489(class_2960.method_60655(Data.getVersion().getID(), "hide_armor.json"));
		for (class_3298 resource : hideLists) {
			try {
				JsonObject reader = class_3518.method_15255(resource.method_43039());
				if (class_3518.method_15270(reader, "replace")) reset();
				for (JsonElement value : class_3518.method_15292(reader, "values", new JsonArray())) add(value.getAsString());
			} catch (Exception error) {
				Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to load perspective hide armor list: {}", error));
			}
		}
	}
}