/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.hud;

import com.mclegoman.perspective.client.config.PerspectiveDefaultConfig;
import com.mclegoman.perspective.client.entity.TexturedEntityDataReloader;
import com.mclegoman.perspective.client.events.AprilFoolsPrank;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.update.Update;
import com.mclegoman.perspective.client.zoom.Zoom;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import org.quiltmc.config.api.values.ValueTreeNode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class DebugOverlay {
	public static Type debugType = Type.none;
	public static class_124 shaderColor;

	public static void renderDebugHUD(class_332 context) {
		List<class_2561> debugTexts = new ArrayList<>();
		debugTexts.add(class_2561.method_43470(Data.getVersion().getName() + " " + Data.getVersion().getFriendlyString(false)));
		if (debugType.equals(Type.misc)) {
			debugTexts.add(class_2561.method_43473());
			debugTexts.add(class_2561.method_43470("debug: " + PerspectiveConfig.config.debug.value()));
			debugTexts.add(class_2561.method_43470("isAprilFools(): " + AprilFoolsPrank.isAprilFools()));
			debugTexts.add(class_2561.method_43470("isZooming(): " + Zoom.isZooming()));
			debugTexts.add(class_2561.method_43470("getZoomLevel(): " + Zoom.getZoomLevel()));
			debugTexts.add(Translation.getCombinedText(class_2561.method_43470("getZoomType(): "), Translation.getZoomTypeTranslation(Zoom.getZoomType().method_12836(), Zoom.getZoomType().method_12832())));
			debugTexts.add(class_2561.method_43470("isNewerVersionFound(): " + Update.isNewerVersionFound()));
		}
		if (debugType.equals(Type.normalConfig) || debugType.equals(Type.defaultConfig)) {
			debugTexts.add(class_2561.method_43473());
			debugTexts.add(Translation.getTranslation(Data.getVersion().getID(), "debug.config", new class_124[]{class_124.field_1067}));
			if (debugType.equals(Type.normalConfig)) debugTexts.addAll(getDebugConfigText(ConfigType.normal));
			else if (debugType.equals(Type.defaultConfig)) debugTexts.addAll(getDebugConfigText(ConfigType.defaults));
		}
		if (debugType.equals(Type.texturedEntities) || debugType.equals(Type.enabledTexturedEntities)) {
			debugTexts.add(class_2561.method_43473());
			debugTexts.add(Translation.getTranslation(Data.getVersion().getID(), "debug.textured_entity" + (debugType.equals(Type.enabledTexturedEntities) ? ".enabled" : ""), new class_124[]{class_124.field_1067}));
			TexturedEntityDataReloader.getRegistryMap().forEach((id, data) -> {
				if (debugType.equals(Type.enabledTexturedEntities) && data.getEnabled() || debugType.equals(Type.texturedEntities)) debugTexts.add(class_2561.method_43470(id.toString() + ":" + data.getNamespace() + ":" + data.getType() + ":" + data.getName()));
			});
		}
		Overlays.renderOverlays(context, debugTexts, 0, 0, true);
	}

	public enum Type {
		none,
		misc,
		normalConfig,
		defaultConfig,
		texturedEntities,
		enabledTexturedEntities;
		private static final Type[] values = values();
		public Type prev() {
			return values[getIndex(false)];
		}
		public Type next() {
			return values[getIndex(true)];
		}
		private int getIndex(boolean forwards) {
			return nextIndex(forwards);
		}
		private int nextIndex(boolean forwards) {
			return forwards ? (this.ordinal() + 1) % values.length : (this.ordinal() - 1) < 0 ? values.length - 1 : this.ordinal() - 1;
		}
	}
	public static List<class_2561> getDebugConfigText(ConfigType... types) {
		List<class_2561> text = new ArrayList<>();
		if (Arrays.stream(types).toList().contains(ConfigType.normal)) {
			text.add(Translation.getTranslation(Data.getVersion().getID(), "debug.config.normal", new class_124[]{class_124.field_1067}));
			for (ValueTreeNode treeNode : PerspectiveConfig.config.nodes())
				text.add(class_2561.method_43470(treeNode.key() + ": " + PerspectiveConfig.config.getValue(treeNode.key()).value()));
		}
		if (Arrays.stream(types).toList().contains(ConfigType.defaults)) {
			text.add(Translation.getTranslation(Data.getVersion().getID(), "debug.config.default", new class_124[]{class_124.field_1067}));
			for (ValueTreeNode treeNode : PerspectiveDefaultConfig.config.nodes())
				text.add(class_2561.method_43470(treeNode.key() + ": " + PerspectiveDefaultConfig.config.getValue(treeNode.key()).value()));
		}
		return text;
	}
	public enum ConfigType {
		normal,
		defaults
	}
}