/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.hud;

import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.shaders.ShaderPacks;
import com.mclegoman.perspective.client.hide.Hide;
import com.mclegoman.perspective.client.hide.HideHudTypes;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class HUDHelper {
	public static void tick() {
		if (Keybindings.cycleDebug != null) {
			if (Keybindings.cycleDebug.method_1436()) {
				DebugOverlay.shaderColor = ShaderPacks.getRandomColor();
				DebugOverlay.debugType = ClientData.minecraft.field_1690.field_1832.method_1434() ? DebugOverlay.debugType.prev() : DebugOverlay.debugType.next();
			}
		}
		if (Keybindings.toggleVerOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.versionOverlay);
		if (Keybindings.togglePosOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.positionOverlay);
		if (Keybindings.toggleDayOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.dayOverlay);
		if (Keybindings.toggleBiomeOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.biomeOverlay);
		if (Keybindings.toggleDeathsOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.deathsOverlay);
		if (Keybindings.toggleTotemsOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.totemsOverlay);
		if (Keybindings.toggleCPSOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.cpsOverlay);
		if (Keybindings.toggleArmorOverlay.method_1436()) PerspectiveConfig.toggle(PerspectiveConfig.config.armorOverlay);
	}
	public static boolean shouldHideHUD() {
		return Hide.shouldHideHud(HideHudTypes.zoom) || Hide.shouldHideHud(HideHudTypes.holdPerspectiveBack) || Hide.shouldHideHud(HideHudTypes.holdPerspectiveFront);
	}
	public static boolean shouldHideHand() {
		return Hide.shouldHideHand(HideHudTypes.zoom);
	}
	public static int addY(int y) {
		return y + 12;
	}
}