/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.hud;

import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.config.value.QualityToggle;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.events.PerspectiveEvents;
import com.mclegoman.perspective.client.time.GameDate;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.util.Mouse;
import com.mclegoman.perspective.client.util.Position;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.common.util.Identifiers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1438;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1474;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1534;
import net.minecraft.class_155;
import net.minecraft.class_1606;
import net.minecraft.class_1646;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4019;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5762;
import net.minecraft.class_7102;
import net.minecraft.class_7923;
import net.minecraft.entity.passive.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Overlays {
	private static final List<String> timeOverlayTypes = new ArrayList<>();
	public static void init() {
		timeOverlayTypes.add("false");
		timeOverlayTypes.add("twelve_hour");
		timeOverlayTypes.add("twenty_four_hour");
		GameDate.bootstrap();
		Mouse.ProcessCPS.register(Identifiers.CPS_OVERLAY, PerspectiveConfig.config.cpsOverlay::value);
		createVariables();
	}
	private static void createVariables() {
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "position"), (args) -> {
			if (ClientData.minecraft.field_1724 != null) {
				boolean integer = args[0] != null && args[0].equalsIgnoreCase("true");
				return Translation.getTranslation(Data.getVersion().getID(), "position.description", new Object[]{Position.getX(ClientData.minecraft.field_1724.method_19538(), integer), Position.getY(ClientData.minecraft.field_1724.method_19538(), integer), Position.getZ(ClientData.minecraft.field_1724.method_19538(), integer)});
			}
			return class_2561.method_43470("?");
		});
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "time"), (args) -> {
			if (ClientData.minecraft.field_1687 != null) {
				long time = ClientData.minecraft.field_1687.method_8532() % 24000L;
				int rawHour = (int) (time / 1000 + 6) % 24;
				int rawMinute = (int) (time / 16.666666) % 60;
				String hour = String.valueOf(rawHour);
				String minute = String.valueOf(rawMinute < 10 ? "0" + rawMinute : rawMinute);
				class_2561 suffix = class_2561.method_43473();
				if (args[0] != null && args[0].equalsIgnoreCase("twelve_hour")) {
					hour = String.valueOf(rawHour == 0 || rawHour == 12 ? 12 : rawHour % 12);
					if (rawHour < 10 && rawHour != 0) hour = "0" + hour;
					suffix = rawHour < 12 ? Translation.getTranslation(Data.getVersion().getID(), "time_overlay.am") : Translation.getTranslation(Data.getVersion().getID(), "time_overlay.pm");
				}
				return Translation.getTranslation(Data.getVersion().getID(), "time", new Object[]{hour, minute, suffix});
			}
			return class_2561.method_43470("?");
		});
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "day"), (args) -> class_2561.method_43470(String.valueOf(ClientData.minecraft.field_1687 != null ? ClientData.minecraft.field_1687.method_8532() / 24000L : "?")));
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "date"), (args) -> {
			boolean worldExists = ClientData.minecraft.field_1687 != null;
			if (worldExists) {
				class_2960 typeId = GameDate.getTypeIdFromConfig();
				if (GameDate.exists(typeId)) {
					GameDate.Type type = GameDate.get(typeId); // This shouldn't ever be null.
					long time = ClientData.minecraft.field_1687.method_8532();
					class_2561 day = Translation.getTranslation(typeId.method_12836(), "date." + typeId.method_12832() + ".day", new Object[]{
							Translation.getTranslation(typeId.method_12836(), "date." + typeId.method_12832() + ".day." + GameDate.getDayOfWeek(time, type)),
							GameDate.getDayOfMonth(time, type)
					});
					int monthValue = GameDate.getMonth(time, type);
					class_2561 month = class_2561.method_43469("gui." + typeId.method_12836() + ".date." + typeId.method_12832() + ".month." + monthValue, Translation.getTranslation(Data.getVersion().getID(), "date.month." + monthValue));
					class_2561 year = Translation.getTranslation(typeId.method_12836(), "date." + typeId.method_12832() + ".year", new Object[]{GameDate.getYear(time, type)});
					return Translation.getTranslation(Data.getVersion().getID(), "date", new Object[]{Translation.getTranslation(typeId.method_12836(), "date." + typeId.method_12832() + ".date", new Object[]{day, month, year})});
				} else return Translation.getTranslation(Data.getVersion().getID(), "date.invalid");
			} else return class_2561.method_43470("?");
		});
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "biome"), (args) -> {
			String biome = ClientData.minecraft.field_1724 != null && ClientData.minecraft.field_1687 != null ? ClientData.minecraft.field_1687.method_23753(ClientData.minecraft.field_1724.method_24515()).method_40229().map((biomeKey) -> biomeKey.method_29177().toString(), (biome_) -> "[unregistered " + biome_ + "]") : null;
			return biome != null ? class_2561.method_43471("biome." + IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, biome) + "." + IdentifierHelper.getStringPart(IdentifierHelper.Type.KEY, biome)) : class_2561.method_43470("?");
		});
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "stat_used"), (args) -> class_2561.method_43470(args[0] != null && ClientData.minecraft.field_1724 != null ? String.valueOf(ClientData.minecraft.field_1724.method_3143().method_15025(class_3468.field_15372.method_14956(class_7923.field_41178.method_63535(class_2960.method_60654(args[0]))))) : "?"));
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "stat_custom"), (args) -> class_2561.method_43470(args[0] != null && ClientData.minecraft.field_1724 != null ? String.valueOf(ClientData.minecraft.field_1724.method_3143().method_15025(class_3468.field_15419.method_14956(class_7923.field_41183.method_63535(class_2960.method_60654(args[0]))))) : "?"));
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "cps_left"), (args) -> class_2561.method_43470(String.valueOf(Mouse.getLeftCPS())));
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "cps_middle"), (args) -> class_2561.method_43470(String.valueOf(Mouse.getMiddleCPS())));
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "cps_right"), (args) -> class_2561.method_43470(String.valueOf(Mouse.getRightCPS())));
		PerspectiveEvents.Variables.register(class_2960.method_60655(Data.getVersion().getID(), "looking_at"), (args) -> getLookingAt((class_1309) ClientData.minecraft.field_1719));
	}
	public static void updateStats() {
		if (ClientData.minecraft.method_1562() != null) ClientData.minecraft.method_1562().method_52787(new class_2799(class_2799.class_2800.field_12775));
	}
	public static String getCurrentTimeOverlay() {
		return PerspectiveConfig.config.timeOverlay.value();
	}
	public static boolean isValidTimeOverlay(String timeOverlay) {
		return timeOverlayTypes.contains(timeOverlay);
	}
	public static void cycleTimeOverlay(boolean direction) {
		int currentIndex = timeOverlayTypes.indexOf(getCurrentTimeOverlay());
		PerspectiveConfig.config.timeOverlay.setValue(timeOverlayTypes.get(direction ? (currentIndex + 1) % timeOverlayTypes.size() : (currentIndex - 1 + timeOverlayTypes.size()) % timeOverlayTypes.size()), false);
	}
	public static class_2561 getEntityPositionTextTitle() {
		return Translation.getTranslation(Data.getVersion().getID(), "position.title");
	}
	public static class_2561 getEntityPositionTextDescription(class_243 pos) {
		return Translation.getTranslation(Data.getVersion().getID(), "position.description", new Object[]{
				Position.getX(pos, true),
				Position.getY(pos, true),
				Position.getZ(pos, true),
		});
	}
	public static void renderOverlays(class_332 context) {
		// TODO: Update config to have a overlays List<String> which gets parsed, this will replace the current overlay values, and the config screen will add ways to add them and custom ones!
		if (!ClientData.minecraft.method_53526().method_53536() && !ClientData.minecraft.field_1690.field_1842 && !HUDHelper.shouldHideHUD()) {
			if (DebugOverlay.debugType.equals(DebugOverlay.Type.none)) {
				// Version Overlay
				if (PerspectiveConfig.config.versionOverlay.value())
					context.method_27535(ClientData.minecraft.field_1772, Translation.getTranslation(Data.getVersion().getID(), "version_overlay", new Object[]{class_155.method_16673().method_48019()}), 2, 2, 0xffffff);
				// Other Overlays
				int y = 40;
				List<class_2561> overlayTexts = new ArrayList<>();
				if (PerspectiveConfig.config.positionOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "position_overlay") + "](Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "position.title") + "]," + "Variable[" + Data.getVersion().getID() + ":position](true))"));
				}
				if (!PerspectiveConfig.config.timeOverlay.value().equals("false")) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "time_overlay") + "](Variable[" + Data.getVersion().getID() + ":time](" + PerspectiveConfig.config.timeOverlay.value() + "))"));
				}
				if (PerspectiveConfig.config.dayOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "day_overlay") + "](Variable[" + Data.getVersion().getID() + ":day])"));
				}
				if (PerspectiveConfig.config.dateOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "date_overlay") + "](Variable[" + Data.getVersion().getID() + ":date])"));
				}
				if (PerspectiveConfig.config.biomeOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "biome_overlay") + "](Variable[" + Data.getVersion().getID() + ":biome])"));
				}
				if (PerspectiveConfig.config.deathsOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "deaths_overlay") + "](Variable[" + Data.getVersion().getID() + ":stat_custom](" + class_3468.field_15421 + "))"));
				}
				if (PerspectiveConfig.config.totemsOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "totems_overlay") + "](Variable[" + Data.getVersion().getID() + ":stat_used](minecraft:totem_of_undying))"));
				}
				if (PerspectiveConfig.config.cpsOverlay.value()) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "cps_overlay") + "](Variable[" + Data.getVersion().getID() + ":cps_left],Variable[" + Data.getVersion().getID() + ":cps_middle],Variable[" + Data.getVersion().getID() + ":cps_right])"));
				}
				if (PerspectiveConfig.config.lookingAtOverlay.value() != QualityToggle.off) {
					overlayTexts.add(Translation.getParsedTextFromString("Translatable[" + Translation.getTranslationKey(Data.getVersion().getID(), "looking_at_overlay") + "](Variable[" + Data.getVersion().getID() + ":looking_at])"));
				}
				renderOverlays(context, overlayTexts, 0, y, false);
			} else DebugOverlay.renderDebugHUD(context);
		}
	}
	public static void renderOverlay(class_332 context, int x, int y, class_2561 text) {
		renderOverlay(context, x, y, text, -1873784752, 0xffffff, false);
	}
	public static void renderOverlay(class_332 context, int x, int y, class_2561 text, int backgroundColor, int textColor, boolean shadow) {
		context.method_25294(x, y, x + ClientData.minecraft.field_1772.method_27525(text) + 4, y + 12, backgroundColor);
		context.method_51439(ClientData.minecraft.field_1772, text, x + 2, y + 2, textColor, shadow);
	}
	public static void renderOverlays(class_332 context, List<class_2561> overlays, int x, int y, boolean wrap) {
		renderOverlays(context, overlays, x, y, wrap, 0);
	}
	public static void renderOverlays(class_332 context, List<class_2561> overlays, int x, int y, boolean wrap, int wrapY) {
		int wrapX = 0;
		for (class_2561 overlay : overlays) {
			if (!overlay.equals(class_2561.method_43473())) {
				wrapX = Math.max(wrapX, ClientData.minecraft.field_1772.method_27525(overlay));
				if (wrap && (y > ClientData.minecraft.method_22683().method_4502() - 2 - 9)) {
					y = wrapY;
					x += (wrapX + 4);
				}
				Overlays.renderOverlay(context, x, y, overlay);
			}
			y = HUDHelper.addY(y);
		}
	}
	public static class_2561 getLookingAt(class_1309 entity) {
		if (entity != null) {
			class_239 hitResult = ClientData.minecraft.field_1765;
			if (hitResult != null) {
				switch (hitResult.method_17783()) {
					case field_1331 -> {
						return getLookingAtEntity((class_3966) hitResult, PerspectiveConfig.config.lookingAtOverlay.value(), entity);
					} case field_1332 -> {
						return getBlock((class_3965) hitResult, PerspectiveConfig.config.lookingAtOverlay.value(), entity);
					}
				}
			}
		}
		return getLookingAtFallbackText();
	}
	private static class_2561 getLookingAtEntity(class_3966 hitResult, QualityToggle quality, class_1309 entity) {
		switch (quality) {
			case fast -> {
				return hitResult.method_17782().method_5864().method_5897();
			}
			case fancy -> {
				Optional<class_2561> variant = getLookingAtEntityVariant(hitResult.method_17782());
				return Translation.getCombinedText((class_5250) variant.orElse(class_2561.method_43473()), (variant.isPresent() ? class_2561.method_43470(" ") : class_2561.method_43473()), (class_5250) hitResult.method_17782().method_5864().method_5897());
			}
		}
		return getLookingAtFallbackText();
	}
	private static Optional<class_2561> getLookingAtEntityVariant(class_1297 entity) {
		Optional<TexturedEntityEntry> texturedEntity = TexturedEntity.getEntity(entity);
		switch (entity) {
			case class_1453 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_6584().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_4019 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_47845().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1534 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_43404().method_55840().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1463 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_47855().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1646 holderEntity -> {
				String profession = holderEntity.method_7231().method_16924().comp_818().toLowerCase();
				class_2960 variant = class_2960.method_60654(holderEntity.method_47882().toString().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473(), !profession.equals("none") ? class_2561.method_43470(" ") : class_2561.method_43473(), !profession.equals("none") ? class_2561.method_43471("merchant.level." + holderEntity.method_7231().method_16925()) : class_2561.method_43473(), !profession.equals("none") ? class_2561.method_43470(" ") : class_2561.method_43473(), !profession.equals("none") ? class_2561.method_48321(holderEntity.method_5864().method_5882() + ".profession", Translation.getTitleCase(profession)) : class_2561.method_43473()));
			}
			case class_1438 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_47847().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1498 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_27077().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1462 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_61472().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1501 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_6809().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_5762 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_33225().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_7102 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_41354().method_55840().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1493 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_58062().method_55840().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1451 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_47843().method_55840().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			case class_1474 holderEntity -> {
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? (class_5250) holderEntity.method_47862().method_47871() : class_2561.method_43473()));
			}
			case class_1606 holderEntity -> {
				class_2960 variant = holderEntity.method_7121() != null ? class_2960.method_60654(holderEntity.method_7121().name().toLowerCase()) : null;
				return texturedEntity.isPresent() || variant != null ? Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), (texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant()) && variant != null ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473())) : Optional.empty();
			}
			case class_1472 holderEntity -> {
				class_2960 variant = class_2960.method_60654(holderEntity.method_6633().name().toLowerCase());
				return Optional.of(Translation.getCombinedText(texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName())).orElseGet(class_2561::method_43473), texturedEntity.isPresent() && !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_43470(" ") : class_2561.method_43473(), texturedEntity.isEmpty() || !texturedEntity.get().getOverrideLookingAtVariant() ? class_2561.method_48321(getLookingAtIdVariantTranslationKey(holderEntity, variant), Translation.getTitleCase(variant.method_12832())) : class_2561.method_43473()));
			}
			default -> {
			}
		}
		return texturedEntity.map(texturedEntityEntry -> class_2561.method_43470(texturedEntityEntry.getName()));
	}
	private static String getLookingAtIdVariantTranslationKey(class_1297 entity, class_2960 variant) {
		return variant.method_42093(entity.method_5864().method_5882() + ".variant");
	}
	private static class_2561 getBlock(class_3965 hitResult, QualityToggle quality, class_1309 entity) {
		switch (quality) {
			case fast -> {
				return entity.method_37908().method_8320(hitResult.method_17777()).method_26204().method_9518();
			}
			case fancy -> {
				return entity.method_37908().method_8320(((class_3965)entity.method_5745(entity.method_45325(class_5134.field_47758), ClientData.minecraft.method_61966().method_60637(true), true)).method_17777()).method_26204().method_9518();
			}
		}
		return getLookingAtFallbackText();
	}
	private static class_2561 getLookingAtFallbackText() {
		return Translation.getTranslation(Data.getVersion().getID(), "looking_at_overlay.none");
	}
}