/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.item;

import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.entity.TexturedEntityDataReloader;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ItemGroup {
	protected static ItemGroupData texturedEntity;
	public static void init() {
		// The items in the item group are refreshed on world load.
		// Ideally, we would be able to refresh them on resource load as well.
		ItemGroupEvents.modifyEntriesEvent(texturedEntity.key()).register(content -> {
			for (TexturedEntityEntry data : TexturedEntityDataReloader.getSortedRegistry()) {
				if (data.getEnabled() && data.getItemGroup() && !data.getName().equalsIgnoreCase("default")) {
					addItem(data, content);
				}
			}
		});
	}
	private static void addItem(TexturedEntityEntry data, FabricItemGroupEntries content) {
		class_1799 itemStack = class_1802.field_8493.method_7854();
		itemStack.method_57379(class_9334.field_50239, Translation.getItemTranslation(Data.getVersion().getID(), "textured_entity_spawn_egg", new Object[]{data.getName(), class_2561.method_43471("entity." + data.getNamespace() + "." + data.getType())}));
		class_2487 entityData = new class_2487();
		entityData.method_10582("id", class_2960.method_60655(data.getNamespace(), data.getType()).toString());
		entityData.method_10582("CustomName", "[{\"text\": " + data.getName() + "}]");
		itemStack.method_57379(class_9334.field_49609, class_9279.method_57456(entityData));
		if (data.getItemModel() != null) itemStack.method_57379(class_9334.field_54199, data.getItemModel());
		content.method_45417(itemStack, net.minecraft.class_1761.class_7705.field_40192);
	}
	public static ItemGroupData register(class_2960 id, net.minecraft.class_1761 itemGroup) {
		class_5321<net.minecraft.class_1761> key = class_5321.method_29179(class_7923.field_44687.method_46765(), id);
		return new ItemGroupData(key, class_2378.method_39197(class_7923.field_44687, key, itemGroup));
	}
	private static class_1799 getIconStack() {
		class_1799 itemStack = class_1802.field_8493.method_7854();
		itemStack.method_57379(class_9334.field_54199, class_2960.method_60654("technoblade_pig_spawn_egg"));
		return itemStack;
	}
	static {
		texturedEntity = register(class_2960.method_60655(Data.getVersion().getID(), "textured_entity"), FabricItemGroup.builder().method_47320(ItemGroup::getIconStack).method_47321(Translation.getItemGroupTranslation(Data.getVersion().getID(), "textured_entity", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name")})).method_47324());
	}

	public record ItemGroupData(class_5321<net.minecraft.class_1761> key, net.minecraft.class_1761 itemGroup) {
	}
}
