/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.keybindings;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_304;
import org.lwjgl.glfw.GLFW;

public class Keybindings {
	public static final class_304 cycleCrosshair;
	public static final class_304 cycleDebug;
	public static final class_304 cycleShaders;
	public static final class_304 holdPerspectiveThirdPersonBack;
	public static final class_304 holdPerspectiveThirdPersonFront;
	public static final class_304 holdZoom;
	public static final class_304 openConfig;
	public static final class_304 randomizeShader;
	public static final class_304 setPerspectiveFirstPerson;
	public static final class_304 setPerspectiveThirdPersonBack;
	public static final class_304 setPerspectiveThirdPersonFront;
	public static final class_304 takePanoScreenshot;
	public static final class_304 toggleArmour;
	public static final class_304 toggleBlockOutline;
	public static final class_304 toggleNametags;
	public static final class_304 togglePlayers;
	public static final class_304 toggleVerOverlay;
	public static final class_304 togglePosOverlay;
	public static final class_304 toggleDayOverlay;
	public static final class_304 toggleBiomeOverlay;
	public static final class_304 toggleDeathsOverlay;
	public static final class_304 toggleTotemsOverlay;
	public static final class_304 toggleCPSOverlay;
	public static final class_304 toggleArmorOverlay;
	public static final class_304 toggleShaders;
	public static final class_304 holdShaders;
	public static final class_304 toggleZoom;
	public static final class_304 toggleZoomCinematic;
	public static final class_304 adjustHoldPerspective;
	public static final class_304[] allKeybindings;

	static {
		allKeybindings = new class_304[]{
				cycleCrosshair = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "cycle_crosshair", GLFW.GLFW_KEY_UNKNOWN),
				cycleDebug = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "debug", GLFW.GLFW_KEY_UNKNOWN, Data.getVersion().isDevelopmentBuild()),
				cycleShaders = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "cycle_shaders", GLFW.GLFW_KEY_F7),
				holdPerspectiveThirdPersonBack = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "hold_perspective_third_person_back", GLFW.GLFW_KEY_Z),
				holdPerspectiveThirdPersonFront = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "hold_perspective_third_person_front", GLFW.GLFW_KEY_V),
				holdZoom = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "hold_zoom", GLFW.GLFW_KEY_R),
				openConfig = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "open_config", GLFW.GLFW_KEY_END),
				randomizeShader = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "random_shader", GLFW.GLFW_KEY_UNKNOWN),
				setPerspectiveFirstPerson = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "set_perspective_first_person", GLFW.GLFW_KEY_UNKNOWN),
				setPerspectiveThirdPersonBack = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "set_perspective_third_person_back", GLFW.GLFW_KEY_UNKNOWN),
				setPerspectiveThirdPersonFront = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "set_perspective_third_person_front", GLFW.GLFW_KEY_UNKNOWN),
				takePanoScreenshot = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "take_panorama_screenshot", GLFW.GLFW_KEY_UNKNOWN),
				toggleArmour = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_armor", GLFW.GLFW_KEY_UNKNOWN),
				toggleBlockOutline = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_block_outline", GLFW.GLFW_KEY_UNKNOWN),
				toggleNametags = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_nametags", GLFW.GLFW_KEY_UNKNOWN),
				togglePlayers = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_players", GLFW.GLFW_KEY_UNKNOWN),
				toggleVerOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_version_overlay", GLFW.GLFW_KEY_UNKNOWN),
				togglePosOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_position_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleDayOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_day_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleBiomeOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_biome_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleDeathsOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_deaths_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleTotemsOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_totems_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleCPSOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_cps_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleArmorOverlay = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_armor_overlay", GLFW.GLFW_KEY_UNKNOWN),
				toggleShaders = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_shaders", GLFW.GLFW_KEY_F8),
				holdShaders = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "hold_shaders", GLFW.GLFW_KEY_UNKNOWN),
				toggleZoom = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_zoom", GLFW.GLFW_KEY_UNKNOWN),
				toggleZoomCinematic = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "toggle_zoom_cinematic", GLFW.GLFW_KEY_UNKNOWN),
				adjustHoldPerspective = KeybindingHelper.getKeybinding(Data.getVersion().getID(), Data.getVersion().getID(), "adjust_hold_perspective", GLFW.GLFW_KEY_H)
		};
	}
	public static void init() {
		Data.getVersion().sendToLog(LogType.INFO, Translation.getString("Initializing keybindings!"));
	}
}