/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.logo;


import com.mclegoman.luminance.client.logo.LogoHelper;
import com.mclegoman.luminance.client.translation.Translation;
import com.mclegoman.luminance.client.util.CompatHelper;
import com.mclegoman.luminance.common.util.Couple;
import com.mclegoman.luminance.common.util.DateHelper;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.events.AprilFoolsPrank;
import com.mclegoman.perspective.client.events.PerspectiveEvents;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.common.util.Identifiers;
import java.time.LocalDate;
import java.time.Month;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import net.minecraft.class_7833;

public class PerspectiveLogo {
	public static void init() {
		PerspectiveEvents.ClientResourceReloaders.register(Identifiers.PRIDE, new PrideLogoDataLoader());
		PerspectiveEvents.ClientResourceReloaders.register(Identifiers.SPLASHES, new SplashesDataloader());
		CompatHelper.addOverrideModMenuIcon(new Couple<>(Data.getVersion().getID(), "pride"), () -> {
			class_2960 id = getLogo(Logo.Type.PRIDE).getIconTexture();
			return "assets/" + id.method_12836() + "/" + id.method_12832();
		}, PerspectiveLogo::isPride);
		CompatHelper.addOverrideModMenuIcon(new Couple<>(Data.getVersion().getID(), "birthday/minecraft"), () -> {
			class_2960 id = getLogo(Logo.Type.SPECIAL, "birthday/minecraft").getIconTexture();
			return "assets/" + id.method_12836() + "/" + id.method_12832();
		}, PerspectiveLogo::isMinecraftBirthday);
		CompatHelper.addLuminanceModMenuBadge(Data.getVersion().getID());
	}
	public static boolean isPerspectiveBirthday() {
		// Perspective's official birthday is June 14th.
		LocalDate date = DateHelper.getDate();
		return date.getMonth() == Month.JUNE && date.getDayOfMonth() >= 14 && date.getDayOfMonth() <= 15;
	}
	public static boolean isMinecraftBirthday() {
		// May 17, 2009 (Source: https://www.minecraft.net/en-us/article/the-15th-anniversary-cape)
		LocalDate date = DateHelper.getDate();
		return date.getMonth() == Month.MAY && date.getDayOfMonth() >= 17 && date.getDayOfMonth() <= 18;
	}
	public static LogoData getDefaultLogo(String arg) {
		return new LogoData("default", Data.getVersion().getID(), class_2960.method_60655(Data.getVersion().getID(), getLogoTexture("default", Data.getVersion().getID())), class_2960.method_60655(Data.getVersion().getID(), getIconTexture("default", Data.getVersion().getID())));
	}
	public static LogoData getExperimentalLogo(String arg) {
		return new LogoData("experimental", Data.getVersion().getID(), class_2960.method_60655(Data.getVersion().getID(), getLogoTexture("experimental", Data.getVersion().getID())), class_2960.method_60655(Data.getVersion().getID(), getIconTexture("experimental", Data.getVersion().getID())));
	}
	public static String getLogoTexture(String type, String id) {
		return "textures/logos/" + type + "/" + id + ".png";
	}
	public static String getIconTexture(String type, String id) {
		return "textures/icons/" + type + "/" + id + ".png";
	}
	public static boolean isPride() {
		return isActuallyPride() || isForcePride();
	}
	public static Couple<Boolean, String> isSpecial() {
		return isMinecraftBirthday() ? new Couple<>(true, "birthday/minecraft") : new Couple<>(false, "");
	}
	public static boolean isActuallyPride() {
		return DateHelper.isPride();
	}
	public static boolean isForcePride() {
		return PerspectiveConfig.config.forcePride.value();
	}
	private static LogoData getPrideLogo(String arg) {
		if (!PerspectiveConfig.config.forcePrideType.value().equals("random")) return getPrideLogoFromId(PerspectiveConfig.config.forcePrideType.value(), arg);
		else return PrideLogoDataLoader.getLogo();
	}
	public static LogoData getPrideLogoFromId(String id, String arg) {
		for (LogoData logoData : PrideLogoDataLoader.registry) if (id.equals(logoData.getId())) return logoData;
		return getDefaultLogo(arg);
	}
	private static LogoData getSpecialLogo(String arg) {
		String type = "special";
		String id = arg.toLowerCase();
		return new LogoData(type, id, class_2960.method_60655(Data.getVersion().getID(), getLogoTexture(type, id)), class_2960.method_60655(Data.getVersion().getID(), getIconTexture(type, id)));
	}
	public static Logo getLogo(Logo.Type type) {
		return getLogo(type, "");
	}
	public static Logo getLogo(Logo.Type type, String arg) {
		switch (type) {
			case PRIDE -> {
				return new Logo(getPrideLogo(arg));
			}
			case EXPERIMENTAL -> {
				return new Logo(getExperimentalLogo(arg));
			}
			case SPECIAL -> {
				return new Logo(getSpecialLogo(arg));
			}
			default -> {
				return new Logo(getDefaultLogo(arg));
			}
		}
	}
	public static class_2960 getLogoTexture(boolean experimental) {
		Couple<Boolean, String> special = isSpecial();
		return getLogo((experimental ? Logo.Type.EXPERIMENTAL : (special.getFirst() ? Logo.Type.SPECIAL : (isPride() ? Logo.Type.PRIDE : Logo.Type.DEFAULT))), special.getSecond()).getLogoTexture();
	}
	public static void renderLogo(class_332 context, int x, int y, int width, int height, class_2960 logoTexture) {
		renderLogo(context, x, y, width, height, logoTexture, AprilFoolsPrank.isAprilFools());
	}
	public static void renderLogo(class_332 context, int x, int y, int width, int height, class_2960 logoTexture, boolean flip) {
		class_4587 matrixStack = context.method_51448();
		matrixStack.method_22903();
		if (flip) {
			matrixStack.method_46416(0, -(110 * (height / 256.0F)), 0);
			matrixStack.method_22904(x + width / 2.0, y + height / 2.0F, 0);
			matrixStack.method_22907(class_7833.field_40717.rotationDegrees(180.0F));
			matrixStack.method_22904(-(x + width / 2.0), -(y + height / 2.0F), 0);
		}
		context.method_25290(class_1921::method_62277, logoTexture, x, y, 0.0F, 0.0F, width, (int) (height * 0.6875F), width, height);
		LogoHelper.renderDevelopmentOverlay(context, (int) ((x + ((float) width / 2)) - ((width * 0.75F) / 2)), (int) (y + (height - (height * 0.54F))), width, height, Data.getVersion().isDevelopmentBuild(), 0, 0);
		matrixStack.method_22909();
	}
	public record Logo(LogoData data) {
		public class_2960 getIconTexture() {
			return data.getIconTexture();
		}
		public class_2960 getLogoTexture() {
			return data.getLogoTexture();
		}
		public enum Type implements class_3542 {
			DEFAULT("default"),
			PRIDE("pride"),
			EXPERIMENTAL("experimental"),
			SPECIAL("special");
			private final String name;
			Type(String name) {
				this.name = name;
			}
			public String toString() {
					return this.name;
				}
			public String method_15434() {
				return this.name;
			}
		}
	}
	public static class Widget extends class_339 {
		private final boolean experimental;
		public Widget(int x, int y, boolean experimental) {
			super(x, y, 256, 64, class_2561.method_43473());
			this.experimental = experimental;
		}
		public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
			renderLogo(context, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), getLogoTexture(experimental));
			createSplashText(context, this.method_25368(), this.method_46426(), this.method_46427() + 32, ClientData.minecraft.field_1772, SplashesDataloader.getSplashText(), -20.0F, AprilFoolsPrank.isAprilFools());
		}
		@Override
		protected void method_47399(class_6382 builder) {
		}
		@Override
		protected boolean method_25351(int button) {
			return false;
		}
	}
	public static void createSplashText(class_332 context, int width, int x, int y, class_327 textRenderer, Translation.Data splashText, float rotation, boolean flip) {
		if (splashText != null && !(Boolean) com.mclegoman.luminance.client.data.ClientData.minecraft.field_1690.method_54581().method_41753()) {
			class_4587 matrixStack = context.method_51448();
			matrixStack.method_22903();
			matrixStack.method_46416((float)(x + width), (float)y, 0.0F);
			matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotation + (flip ? 180.0F : 0.0F)));
			float scale = (1.8F - class_3532.method_15379(class_3532.method_15374((float)(class_156.method_658() % 1000L) / 1000.0F * ((float)Math.PI * 2F)) * 0.1F)) * 100.0F / (float)(textRenderer.method_27525(Translation.getText(splashText)) + 32);
			matrixStack.method_22905(scale, scale, scale);
			context.method_27534(textRenderer, Translation.getText(splashText), 0, -8 + (flip ? textRenderer.field_2000 : 0), 16776960);
			matrixStack.method_22909();
		}
	}
}
