/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.logo;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.util.JsonResourceReloader;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class PrideLogoDataLoader extends JsonResourceReloader {
	public static final List<LogoData> registry = new ArrayList<>();
	public static final String identifier = "pride_logos";
	private static LogoData logo;
	public static LogoData getLogo() {
		return logo;
	}
	public static void randomizeLogo() {
		if (registry.size() > 1) {
			List<LogoData> logos = new ArrayList<>(registry);
			if (getLogo() != null) logos.remove(getLogo());
			logo = logos.get(new Random().nextInt(logos.size()));
		} else {
			if (registry.size() == 1) logo = registry.getFirst();
			else logo = PerspectiveLogo.getDefaultLogo("");
		}
	}
	public static List<String> getLogoNames() {
		List<String> logos = new ArrayList<>();
		for (LogoData logoData : registry) logos.add(logoData.getId());
		return logos;
	}
	public PrideLogoDataLoader() {
		super(new Gson(), identifier);
	}
	private void add(String id, class_2960 logoTexture, class_2960 iconTexture) {
		registry.removeIf(logoData -> logoData.getId().equals(id));
		registry.add(new LogoData("pride", id, logoTexture, iconTexture));
	}
	private void reset() {
		registry.clear();
	}
	@Override
	public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
		try {
			reset();
			prepared.forEach(this::layout$perspective);
			randomizeLogo();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to apply pride logo dataloader: {}", error));
		}
	}
	private void layout$perspective(class_2960 identifier, JsonElement jsonElement) {
		try {
			JsonObject reader = jsonElement.getAsJsonObject();
			String id = class_3518.method_15253(reader, "id", identifier.method_12832());
			String logoTexture = class_3518.method_15253(reader, "logo_texture", getDefaultLogoTexture(id));
			String iconTexture = class_3518.method_15253(reader, "icon_texture", getDefaultIconTexture(id));
			add(id, IdentifierHelper.identifierFromString(logoTexture.endsWith(".png") ? logoTexture : logoTexture + ".png"), IdentifierHelper.identifierFromString(iconTexture.endsWith(".png") ? iconTexture : iconTexture + ".png"));
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to load perspective pride logo: {}", error));
		}
	}
	private String getDefaultLogoTexture(String id) {
		return PerspectiveLogo.getLogoTexture("pride", id);
	}
	private String getDefaultIconTexture(String id) {
		return PerspectiveLogo.getIconTexture("pride", id);
	}
}