/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.logo;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.util.JsonResourceReloader;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.events.AprilFoolsPrank;
import com.mclegoman.perspective.client.events.Halloween;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class SplashesDataloader extends JsonResourceReloader {
	public static final List<Translation.Data> registry = new ArrayList<>();
	public static final String id = "splashes";
	private static Translation.Data splashText;
	public static Translation.Data getSplashText() {
		if (PerspectiveLogo.isPerspectiveBirthday()) return new Translation.Data("splashes.perspective.special.birthday.perspective", true);
		else if (PerspectiveLogo.isMinecraftBirthday()) return new Translation.Data("splashes.perspective.special.birthday.minecraft", true);
		else if (PerspectiveLogo.isActuallyPride()) return new Translation.Data("splashes.perspective.special.pride_month", true);
		else if (AprilFoolsPrank.isAprilFools() && !AprilFoolsPrank.isForceAprilFools()) return new Translation.Data("splashes.perspective.special.april_fools", true);
		else if (Halloween.isHalloween() && !Halloween.isForceHalloween()) return new Translation.Data("splashes.perspective.special.halloween", true);
		else return splashText;
	}
	public static void randomizeSplashText() {
		if (registry.size() > 1) {
			List<Translation.Data> splashes = new ArrayList<>(registry);
			if (getSplashText() != null) splashes.remove(getSplashText());
			splashText = splashes.get(new Random().nextInt(splashes.size()));
		} else {
			if (registry.size() == 1) splashText = registry.getFirst();
			else splashText = new Translation.Data("", false);
		}
	}
	public SplashesDataloader() {
		super(new Gson(), id);
	}
	private void add(String text, Boolean translatable) {
		try {
			Translation.Data splash = new Translation.Data(text, translatable);
			if (!registry.contains(splash)) registry.add(splash);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to add splash text to registry: {}", error));
		}
	}
	private void reset() {
		try {
			registry.clear();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to reset splash text registry: {}", error));
		}
	}
	@Override
	public void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
		try {
			reset();
			for (class_3298 resource : manager.method_14489(class_2960.method_60655(Data.getVersion().getID(), id + ".json"))) {
				JsonObject reader = class_3518.method_15255(resource.method_43039());
				if (class_3518.method_15258(reader, "replace", false)) reset();
				JsonArray translatableTexts = class_3518.method_15261(reader, "translatable");
				for (JsonElement splashText : translatableTexts) add(splashText.getAsString(), true);
				JsonArray literalTexts = class_3518.method_15261(reader, "literal");
				for (JsonElement splashText : literalTexts) add(splashText.getAsString(), false);
			}
			randomizeSplashText();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to load splash text from dataloader: {}", error));
		}
	}
}