/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.panorama;

import com.mclegoman.luminance.client.util.CompatHelper;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import java.io.File;
import java.io.FileWriter;
import java.util.*;
import java.util.concurrent.Callable;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_3264;
import net.minecraft.class_5498;
import net.minecraft.class_9779;

public class Panorama {
	private static final Map<String, Callable<Boolean>> incompatible = new HashMap<>();

	public static void addIncompatibleCallable(String id, Callable<Boolean> callable) {
		if (!incompatible.containsKey(id)) incompatible.put(id, callable);
	}
	public static void addIncompatibleMod(String modID) {
		addIncompatibleCallable(modID, () -> Data.isModInstalled(modID));
	}

	public static void init() {
		addIncompatibleMod("canvas");
		addIncompatibleCallable("iris_shaders_enabled", CompatHelper::isIrisShadersEnabled);
	}
	private static boolean isCompatible() {
		boolean compatible = true;
		for (Callable<Boolean> value : incompatible.values()) {
			try {
				if (value.call()) {
					compatible = false;
					break;
				}
			} catch (Exception error) {
				compatible = false;
				break;
			}
		}
		return compatible;
	}

	public static List<String> getIncompatible() {
		List<String> incompatibleFound = new ArrayList<>();
		incompatible.forEach((id, callable) -> {
			try {
				if (callable.call()) incompatibleFound.add(id);
			} catch (Exception error) {
				incompatibleFound.add(id);
			}
		});
		return incompatibleFound;
	}

	public static void tick() {
		if (Keybindings.takePanoScreenshot.method_1436()) takePanorama(1024, 0.0F);
	}

	private static String getFilename() {
		String currentTime = class_156.method_44893();
		String filename = currentTime;
		int i = 1;
		boolean shouldReturn = false;
		while (!shouldReturn) {
			String filename1 = currentTime + (i == 1 ? "" : "_" + i);
			File file = new File(ClientData.minecraft.field_1697.getPath() + "/resourcepacks/", filename1);
			if (!file.exists()) {
				filename = filename1;
				shouldReturn = true;
			}
			i++;
		}
		return filename;
	}

	private static boolean shouldTakePanorama() {
		return PerspectiveConfig.config.debug.value() || isCompatible();
	}

	private static void takePanorama(int resolution, float startingYaw) {
		try {
			if (shouldTakePanorama()) {
				if (ClientData.minecraft.field_1724 != null) {
					float playerPitch = ClientData.minecraft.field_1724.method_36455();
					float playerYaw = ClientData.minecraft.field_1724.method_36454();

					int framebufferWidth = ClientData.minecraft.method_22683().method_4489();
					int framebufferHeight = ClientData.minecraft.method_22683().method_4506();
					class_276 framebuffer = ClientData.minecraft.method_1522();

					class_5498 playerPerspective = ClientData.minecraft.field_1690.method_31044();
					if (!playerPerspective.method_31034()) ClientData.minecraft.field_1690.method_31043(class_5498.field_26664);

					ClientData.minecraft.field_1773.method_35769(false);
					ClientData.minecraft.field_1773.method_35770(true);

					String panoramaName = getFilename();
					File resourcePackDir = new File(ClientData.minecraft.field_1697.getPath() + "/resourcepacks/" + panoramaName);
					File screenshotsDir = new File(resourcePackDir + "/assets/minecraft/textures/gui/title/background");

					if (screenshotsDir.mkdirs()) {
						// Pre-render world
						for (int l = 0; l < 100; ++l) {
							framebuffer.method_1235(true);
							ClientData.minecraft.field_1773.method_3188(class_9779.field_51956);
						}
						// Create pack.png
						ClientData.minecraft.method_22683().method_35642(64);
						ClientData.minecraft.method_22683().method_35643(64);
						framebuffer.method_1234(64, 64);
						framebuffer.method_1235(true);
						ClientData.minecraft.field_1773.method_3188(class_9779.field_51956);
						ScreenshotRecorder.saveScreenshot(resourcePackDir, "pack.png", ClientData.minecraft.method_1522());

						ClientData.minecraft.method_22683().method_35642(resolution);
						ClientData.minecraft.method_22683().method_35643(resolution);
						framebuffer.method_1234(resolution, resolution);

						// Create panoramic screenshots
						for (int l = 0; l < 6; ++l) {
							switch (l) {
								case 0 -> {
									ClientData.minecraft.field_1724.method_36456((startingYaw + 0.0F) % 360.0F);
									ClientData.minecraft.field_1724.method_36457(0.0F);
								}
								case 1 -> {
									ClientData.minecraft.field_1724.method_36456((startingYaw + 90.0F) % 360.0F);
									ClientData.minecraft.field_1724.method_36457(0.0F);
								}
								case 2 -> {
									ClientData.minecraft.field_1724.method_36456((startingYaw + 180.0F) % 360.0F);
									ClientData.minecraft.field_1724.method_36457(0.0F);
								}
								case 3 -> {
									ClientData.minecraft.field_1724.method_36456((startingYaw + 270.0F) % 360.0F);
									ClientData.minecraft.field_1724.method_36457(0.0F);
								}
								case 4 -> {
									ClientData.minecraft.field_1724.method_36456((startingYaw + 0.0F) % 360.0F);
									ClientData.minecraft.field_1724.method_36457(-90.0F);
								}
								case 5 -> {
									ClientData.minecraft.field_1724.method_36456((startingYaw + 0.0F) % 360.0F);
									ClientData.minecraft.field_1724.method_36457(90.0F);
								}
							}
							framebuffer.method_1235(true);
							ClientData.minecraft.field_1773.method_3188(class_9779.field_51956);
							ScreenshotRecorder.saveScreenshot(screenshotsDir, "panorama_" + l + ".png", ClientData.minecraft.method_1522());
						}

						// Create pack.mcmeta
						File packFile = new File(resourcePackDir + "/pack.mcmeta");
						if (packFile.createNewFile()) {
							FileWriter packWriter = new FileWriter(packFile);
							packWriter.write("{\"pack\": {\"pack_format\": " + class_155.method_16673().method_48017(class_3264.field_14188) + ", \"supported_formats\": {\"min_inclusive\": 1, \"max_inclusive\": 2147483647}, \"description\": \"" + panoramaName + "\"}}\"}}");
							packWriter.close();
						}
					}

					ClientData.minecraft.field_1724.method_36457(playerPitch);
					ClientData.minecraft.field_1724.method_36456(playerYaw);

					ClientData.minecraft.method_22683().method_35642(framebufferWidth);
					ClientData.minecraft.method_22683().method_35643(framebufferHeight);
					framebuffer.method_1234(framebufferWidth, framebufferHeight);
					if (!playerPerspective.method_31034()) ClientData.minecraft.field_1690.method_31043(playerPerspective);
					ClientData.minecraft.field_1773.method_35769(true);
					ClientData.minecraft.field_1773.method_35770(false);
					ClientData.minecraft.method_1522().method_1235(true);
					ClientData.minecraft.field_1724.method_7353(Translation.getTranslation(Data.getVersion().getID(), "message.take_panorama_screenshot.success", new Object[]{class_2561.method_43470(panoramaName).method_27692(class_124.field_1073).method_27694((style) -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, resourcePackDir.getAbsolutePath())))}), false);
				}
			} else {
				String[] incompatible = getIncompatible().toString().replace("[", "").replace("]", "").replace(" ", "").split(",");
				if (ClientData.minecraft.field_1724 != null) {
					class_2561[] incompatibleTranslated = new class_2561[incompatible.length];
					for (int i = 0; i < incompatible.length; i++) incompatibleTranslated[i] = Translation.getTranslation(Data.getVersion().getID(), "message.take_panorama_screenshot.fail.incompatible." + incompatible[i]);
					ClientData.minecraft.field_1724.method_7353(Translation.getTranslation(Data.getVersion().getID(), "message.take_panorama_screenshot.fail", new Object[]{class_2561.method_43470("")}), false);
					for (class_2561 text : incompatibleTranslated) ClientData.minecraft.field_1724.method_7353(text, false);
				}
				else Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to take panorama: {}", Arrays.toString(incompatible)));
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to take panoramic screenshot: {}", error));
		}
	}
}