/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.panorama;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_276;

public class ScreenshotRecorder {
	public static void saveScreenshot(File gameDirectory, String fileName, class_276 framebuffer) {
		if (!RenderSystem.isOnRenderThread()) RenderSystem.recordRenderCall(() -> saveScreenshotInner(gameDirectory, fileName, framebuffer));
		else saveScreenshotInner(gameDirectory, fileName, framebuffer);
	}
	private static void saveScreenshotInner(File screenshotDir, String fileName, class_276 framebuffer) {
		try {
			screenshotDir.mkdirs();
			class_1011 nativeImage = net.minecraft.class_318.method_1663(framebuffer);
			class_156.method_27958().execute(() -> {
				try {
					nativeImage.method_4325(new File(screenshotDir, fileName));
				} catch (Exception error) {
					Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Couldn't save screenshot: {}", error));
				} finally {
					nativeImage.close();
				}
			});
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to take screenshot: {}", error));
		}
	}
}