/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.perspective;

import com.mclegoman.perspective.client.config.PerspectiveDefaultConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import net.minecraft.class_3532;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class Perspective {
	private static boolean holdThirdPersonBackLock;
	private static net.minecraft.class_5498 holdThirdPersonBackPrev;
	private static boolean holdThirdPersonFrontLock;
	private static net.minecraft.class_5498 holdThirdPersonFrontPrev;
	public static boolean isHoldingAdjust() {
		return Keybindings.adjustHoldPerspective.method_1434();
	}
	public static boolean isHoldingPerspective() {
		return isHoldingPerspectiveBack() || isHoldingPerspectiveFront();
	}
	public static boolean isHoldingPerspectiveBack() {
		return holdThirdPersonBackLock ;
	}
	public static boolean isHoldingPerspectiveFront() {
		return holdThirdPersonFrontLock;
	}
	public static net.minecraft.class_5498 getPerspective() {
		return ClientData.minecraft.field_1690.method_31044();
	}
	public static float getHoldPerspectiveBackMultiplier() {
		return PerspectiveConfig.config.holdPerspectiveBackMultiplier.value();
	}
	public static float getHoldPerspectiveFrontMultiplier() {
		return PerspectiveConfig.config.holdPerspectiveFrontMultiplier.value();
	}
	public static void tick() {
		if (Keybindings.setPerspectiveFirstPerson.method_1436())
			setPerspective(net.minecraft.class_5498.field_26664);
		if (Keybindings.setPerspectiveThirdPersonBack.method_1436())
			setPerspective(net.minecraft.class_5498.field_26665);
		if (Keybindings.setPerspectiveThirdPersonFront.method_1436())
			setPerspective(net.minecraft.class_5498.field_26666);
		getHoldAll();
		if (!(isHoldingPerspective() && isHoldingAdjust()) && hasUpdated) {
			PerspectiveConfig.config.holdPerspectiveBackMultiplier.serializeAndInvokeCallbacks();
			PerspectiveConfig.config.holdPerspectiveFrontMultiplier.serializeAndInvokeCallbacks();
		}
	}
	private static void setThirdPersonFront(net.minecraft.class_5498 perspective) {
		if (!Keybindings.holdPerspectiveThirdPersonBack.method_1434() && !holdThirdPersonBackLock) {
			if (!holdThirdPersonFrontLock) {
				holdThirdPersonFrontPrev = perspective;
				if (ClientData.minecraft.field_1690.method_31044().equals(net.minecraft.class_5498.field_26666))
					setPerspective(net.minecraft.class_5498.field_26664);
				else
					setPerspective(net.minecraft.class_5498.field_26666);
			}
			holdThirdPersonFrontLock = true;
		}
	}
	private static void setThirdPersonBack(net.minecraft.class_5498 perspective) {
		if (!Keybindings.holdPerspectiveThirdPersonFront.method_1434() && !holdThirdPersonFrontLock) {
			if (!holdThirdPersonBackLock) {
				ClientData.minecraft.field_1769.method_3292();
				holdThirdPersonBackPrev = perspective;
				if (ClientData.minecraft.field_1690.method_31044().equals(net.minecraft.class_5498.field_26665))
					setPerspective(net.minecraft.class_5498.field_26664);
				else
					setPerspective(net.minecraft.class_5498.field_26665);
			}
			holdThirdPersonBackLock = true;
		}
	}
	private static void getHoldAll() {
		getHoldFront(ClientData.minecraft.field_1690.method_31044());
		getHoldBack(ClientData.minecraft.field_1690.method_31044());
	}
	private static boolean isHoldFront() {
		return Keybindings.holdPerspectiveThirdPersonFront.method_1434();
	}
	private static void getHoldFront(net.minecraft.class_5498 perspective) {
		if (isHoldFront())
			setThirdPersonFront(perspective);
		clearHoldFront();
	}
	private static boolean isHoldBack() {
		return Keybindings.holdPerspectiveThirdPersonBack.method_1434();
	}
	private static void getHoldBack(net.minecraft.class_5498 perspective) {
		if (isHoldBack())
			setThirdPersonBack(perspective);
		clearHoldBack();
	}
	private static void clearHoldFront() {
		if (!Keybindings.holdPerspectiveThirdPersonFront.method_1434() && holdThirdPersonFrontLock) {
			holdThirdPersonFrontLock = false;
			if (isHoldBack()) getHoldBack(holdThirdPersonFrontPrev);
			else setPerspective(holdThirdPersonFrontPrev);
		}
	}
	private static void clearHoldBack() {
		if (!Keybindings.holdPerspectiveThirdPersonBack.method_1434() && holdThirdPersonBackLock) {
			holdThirdPersonBackLock = false;
			if (isHoldFront()) getHoldFront(holdThirdPersonBackPrev);
			else setPerspective(holdThirdPersonBackPrev);
		}
	}
	public static void setPerspective(net.minecraft.class_5498 perspective) {
		ClientData.minecraft.field_1769.method_3292();
		ClientData.minecraft.field_1690.method_31043(perspective);
	}





	private static boolean hasUpdated;

	public static float getMultiplier() {
		if (isHoldingPerspective()) {
			if (isHoldBack()) return PerspectiveConfig.config.holdPerspectiveBackMultiplier.value();
			else if (isHoldFront()) return PerspectiveConfig.config.holdPerspectiveFrontMultiplier.value();
		}
		return 1.0F;
	}
	public static void adjust(float amount, int multiplier) {
		if (isHoldingPerspective()) {
			for (int i = 0; i < multiplier; i++) {
				if (!(getMultiplier() <= 0.5F) || !(getMultiplier() >= 16.0F)) {
					if (isHoldBack()) {
						PerspectiveConfig.config.holdPerspectiveBackMultiplier.setValue(class_3532.method_15363(getMultiplier() + amount, 0.5F, 16.0F), false);
					} else if (isHoldFront()) {
						PerspectiveConfig.config.holdPerspectiveFrontMultiplier.setValue(class_3532.method_15363(getMultiplier() + amount, 0.5F, 16.0F), false);
					}
					hasUpdated = true;
				}
			}
		}
	}
	public static void reset() {
		if (isHoldingPerspective()) {
			if (isHoldBack()) {
				PerspectiveConfig.config.holdPerspectiveBackMultiplier.setValue(class_3532.method_15363(PerspectiveDefaultConfig.config.holdPerspectiveBackMultiplier.value(), 0.5F, 16.0F), false);
			} else if (isHoldFront()) {
				PerspectiveConfig.config.holdPerspectiveFrontMultiplier.setValue(class_3532.method_15363(PerspectiveDefaultConfig.config.holdPerspectiveFrontMultiplier.value(), 0.5F, 16.0F), false);
			}
			hasUpdated = true;
		}
	}
}